/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ptp.remotetools.utils.stream.IStreamListener;
import org.eclipse.ptp.remotetools.utils.stream.StreamObserver;

public class StreamBridge {
    IStreamListener dataForwarder = null;
    StreamObserver streamObserver = null;

    public StreamBridge(InputStream input, OutputStream output, String name) {
        this.dataForwarder = new DataForwarder(this, output);
        this.streamObserver = new StreamObserver(input, this.dataForwarder, name);
    }

    public StreamBridge(InputStream input, OutputStream output) {
        this.dataForwarder = new DataForwarder(this, output);
        this.streamObserver = new StreamObserver(input, this.dataForwarder);
    }

    public void kill() {
        if (this.streamObserver != null) {
            this.streamObserver.kill();
        }
        this.dataForwarder = null;
        this.streamObserver = null;
    }

    public void run() {
        this.streamObserver.start();
    }

    private class DataForwarder
    implements IStreamListener {
        OutputStream output;
        StreamBridge bridge;

        public DataForwarder(StreamBridge bridge, OutputStream output) {
            this.output = output;
            this.bridge = bridge;
        }

        @Override
        public void newBytes(byte[] bytes, int length) {
            try {
                this.output.write(bytes, 0, length);
            }
            catch (IOException iOException) {
                this.bridge.kill();
            }
        }

        @Override
        public void streamClosed() {
            this.bridge.kill();
        }

        @Override
        public void streamError(Exception e) {
            this.bridge.kill();
        }
    }
}

