/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.io.File;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPath;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPathElement;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeInfo;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludePreferences;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class InclusionContext {
    private static final IPath UNRESOLVED_INCLUDE = Path.EMPTY;
    private final ITranslationUnit fTu;
    private final IProject fProject;
    private final IPath fCurrentDirectory;
    private final IncludePreferences fPreferences;
    private final IncludeSearchPath fIncludeSearchPath;
    private final Map<IncludeInfo, IPath> fIncludeResolutionCache;
    private final Map<IPath, IncludeInfo> fInverseIncludeResolutionCache;
    private final IIndex fIndex;
    private final Set<IPath> fHeadersToInclude;
    private final Set<IPath> fHeadersAlreadyIncluded;

    public InclusionContext(ITranslationUnit tu, IIndex index) {
        this.fTu = tu;
        this.fIndex = index;
        ICProject cProject = this.fTu.getCProject();
        this.fPreferences = new IncludePreferences(cProject);
        this.fProject = cProject.getProject();
        this.fCurrentDirectory = this.fTu.getResource().getParent().getLocation();
        IScannerInfo scannerInfo = this.fTu.getScannerInfo(true);
        this.fIncludeSearchPath = CPreprocessor.configureIncludeSearchPath((File)this.fCurrentDirectory.toFile(), (IScannerInfo)scannerInfo);
        this.fIncludeResolutionCache = new HashMap<IncludeInfo, IPath>();
        this.fInverseIncludeResolutionCache = new HashMap<IPath, IncludeInfo>();
        this.fHeadersToInclude = new HashSet<IPath>();
        this.fHeadersAlreadyIncluded = new HashSet<IPath>();
    }

    public ITranslationUnit getTranslationUnit() {
        return this.fTu;
    }

    public IIndex getIndex() {
        return this.fIndex;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IncludePreferences getPreferences() {
        return this.fPreferences;
    }

    public boolean isCXXLanguage() {
        return this.fTu.isCXXLanguage();
    }

    public IPath getCurrentDirectory() {
        return this.fCurrentDirectory;
    }

    public IPath resolveInclude(IncludeInfo include) {
        IPath path = this.fIncludeResolutionCache.get(include);
        if (path == null) {
            String directory = this.fCurrentDirectory.toOSString();
            String filePath = CPreprocessor.getAbsoluteInclusionPath((String)include.getName(), (String)directory);
            if (filePath != null) {
                path = new Path(filePath);
            } else if (!include.isSystem() && !this.fIncludeSearchPath.isInhibitUseOfCurrentFileDirectory() && InclusionContext.fileExists(filePath = ScannerUtility.createReconciledPath((String)directory, (String)include.getName()))) {
                path = new Path(filePath);
            }
            if (path == null) {
                IncludeSearchPathElement[] includeSearchPathElementArray = this.fIncludeSearchPath.getElements();
                int n = includeSearchPathElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IncludeSearchPathElement pathElement = includeSearchPathElementArray[n2];
                    if (!(include.isSystem() && pathElement.isForQuoteIncludesOnly() || !InclusionContext.fileExists(filePath = pathElement.getLocation(include.getName())))) {
                        path = new Path(filePath);
                        break;
                    }
                    ++n2;
                }
            }
            if (path == null) {
                path = UNRESOLVED_INCLUDE;
            }
            this.fIncludeResolutionCache.put(include, path);
            this.fInverseIncludeResolutionCache.put(path, include);
        }
        return path == UNRESOLVED_INCLUDE ? null : path;
    }

    public IncludeInfo getIncludeForHeaderFile(IPath fullPath) {
        IncludeInfo include = this.fInverseIncludeResolutionCache.get(fullPath);
        if (include != null) {
            return include;
        }
        String headerLocation = fullPath.toOSString();
        String shortestInclude = null;
        boolean isSystem = false;
        IncludeSearchPathElement[] includeSearchPathElementArray = this.fIncludeSearchPath.getElements();
        int n = includeSearchPathElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeSearchPathElement pathElement = includeSearchPathElementArray[n2];
            String includeDirective = pathElement.getIncludeDirective(headerLocation);
            if (includeDirective != null && (shortestInclude == null || shortestInclude.length() > includeDirective.length())) {
                shortestInclude = includeDirective;
                isSystem = !pathElement.isForQuoteIncludesOnly();
            }
            ++n2;
        }
        if (shortestInclude == null) {
            return null;
        }
        include = new IncludeInfo(shortestInclude, isSystem);
        this.fInverseIncludeResolutionCache.put(fullPath, include);
        return include;
    }

    public void removeExportedHeaders() throws CoreException {
        HashMap<IPath, IIndexFile> filesByPath = new HashMap<IPath, IIndexFile>();
        IIndexFile[] iIndexFileArray = this.fIndex.getAllFiles();
        int n = iIndexFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFile file = iIndexFileArray[n2];
            IPath path = InclusionContext.getPath(file);
            filesByPath.put(path, file);
            ++n2;
        }
        HashSet<IPath> exportedHeaders = new HashSet<IPath>();
        for (IPath path : this.fHeadersToInclude) {
            IIndexFile file;
            if (exportedHeaders.contains(path) || (file = (IIndexFile)filesByPath.get(path)) == null) continue;
            ArrayDeque<IIndexFile> queue = new ArrayDeque<IIndexFile>();
            queue.add(file);
            while ((file = (IIndexFile)queue.pollFirst()) != null) {
                IIndexInclude[] iIndexIncludeArray = file.getIncludes();
                int n3 = iIndexIncludeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IIndexInclude include = iIndexIncludeArray[n4];
                    if (include.isIncludedFileExported() && (file = this.fIndex.resolveInclude(include)) != null && exportedHeaders.add(InclusionContext.getPath(file))) {
                        queue.add(file);
                    }
                    ++n4;
                }
            }
        }
        this.fHeadersToInclude.removeAll(exportedHeaders);
    }

    private static IPath getPath(IIndexFile file) throws CoreException {
        return IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
    }

    private static boolean fileExists(String absolutePath) {
        return new File(absolutePath).exists();
    }

    public Set<IPath> getHeadersToInclude() {
        return this.fHeadersToInclude;
    }

    public final void addHeaderToInclude(IPath header) {
        this.fHeadersToInclude.add(header);
    }

    public final boolean isToBeIncluded(IPath header) {
        return this.fHeadersToInclude.contains(header);
    }

    public Set<IPath> getHeadersAlreadyIncluded() {
        return this.fHeadersAlreadyIncluded;
    }

    public final void addHeaderAlreadyIncluded(IPath header) {
        this.fHeadersAlreadyIncluded.add(header);
    }

    public final boolean isAlreadyIncluded(IPath header) {
        return this.fHeadersAlreadyIncluded.contains(header);
    }

    public final boolean isIncluded(IPath header) {
        return this.fHeadersAlreadyIncluded.contains(header) || this.fHeadersToInclude.contains(header);
    }
}

