/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui.tabs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.ui.tabs.AbstractDebuggerTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DebuggerTab
extends AbstractDebuggerTab {
    public static final String TAB_ID = "org.eclipse.ptp.launch.applicationLaunch.debuggerTab";
    protected final boolean fAttachMode;
    protected Button fStopInMain;
    protected Button fAttachButton;

    public DebuggerTab(boolean attachMode) {
        this.fAttachMode = attachMode;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(2, true);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(1, 2, true, false);
        comp.setLayoutData((Object)gd);
        this.createDebuggerCombo(comp, this.fAttachMode ? 1 : 2);
        this.createOptionsComposite(comp);
        this.createDebuggerGroup(comp, 2);
    }

    public String getId() {
        return TAB_ID;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setInitializing(true);
        super.initializeFrom(config);
        try {
            String id = config.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox(config, id, LaunchUtils.getRemoteServicesId((ILaunchConfiguration)config) == null);
            this.initializeCommonControls(config);
        }
        catch (CoreException coreException) {}
        this.setInitializing(false);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.setInitializing(true);
        super.activated(workingCopy);
        try {
            String id = workingCopy.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox((ILaunchConfiguration)workingCopy, id, LaunchUtils.getRemoteServicesId((ILaunchConfiguration)workingCopy) == null);
            this.initializeCommonControls((ILaunchConfiguration)workingCopy);
        }
        catch (CoreException coreException) {}
        this.setInitializing(false);
    }

    public boolean isValid(ILaunchConfiguration config) {
        String mode;
        if (!this.validateDebuggerConfig(config)) {
            return false;
        }
        IPDebugConfiguration debugConfig = this.getDebugConfig();
        String string = mode = this.fAttachMode ? "attach" : "run";
        if (!debugConfig.supportsMode(mode)) {
            this.setErrorMessage(NLS.bind((String)Messages.DebuggerTab_Mode_not_supported, (Object[])new Object[]{mode}));
            return false;
        }
        return super.isValid(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        if (this.fAttachMode) {
            config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_START_MODE", "attach");
        } else {
            config.setAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", this.fStopInMain.getSelection());
            config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_START_MODE", "run");
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        if (this.fAttachMode) {
            config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_START_MODE", "attach");
        } else {
            config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_START_MODE", "run");
            config.setAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", true);
        }
    }

    protected void createOptionsComposite(Composite parent) {
        Composite optionsComp = new Composite(parent, 0);
        if (this.fAttachMode) {
            GridLayout layout = new GridLayout(1, false);
            optionsComp.setLayout((Layout)layout);
            optionsComp.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        } else {
            GridLayout layout = new GridLayout(2, false);
            optionsComp.setLayout((Layout)layout);
            optionsComp.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
            this.fStopInMain = this.createCheckButton(optionsComp, Messages.DebuggerTab_Stop_at_main_on_startup);
            GridData data = new GridData();
            data.horizontalAlignment = 1;
            this.fStopInMain.setLayoutData((Object)data);
            this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!DebuggerTab.this.isInitializing()) {
                        DebuggerTab.this.updateLaunchConfigurationDialog();
                    }
                }
            });
        }
    }

    protected void initializeCommonControls(ILaunchConfiguration config) {
        try {
            if (!this.fAttachMode) {
                this.fStopInMain.setSelection(config.getAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", true));
            }
        }
        catch (CoreException coreException) {}
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config, String selection, boolean noDefault) {
        IPDebugConfiguration[] debugConfigs = PTPDebugCorePlugin.getDefault().getDebugConfigurations();
        Arrays.sort(debugConfigs, new Comparator<IPDebugConfiguration>(){

            @Override
            public int compare(IPDebugConfiguration ic1, IPDebugConfiguration ic2) {
                return ic1.getName().compareTo(ic2.getName());
            }
        });
        ArrayList<IPDebugConfiguration> list = new ArrayList<IPDebugConfiguration>();
        String mode = this.fAttachMode ? "attach" : "run";
        String defaultSelection = selection;
        IPDebugConfiguration[] iPDebugConfigurationArray = debugConfigs;
        int n = debugConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IPDebugConfiguration debugConfig = iPDebugConfigurationArray[n2];
            if (debugConfig.supportsMode(mode)) {
                list.add(debugConfig);
                if (!noDefault && defaultSelection.equals("")) {
                    defaultSelection = debugConfig.getID();
                }
            }
            ++n2;
        }
        this.setInitializeDefault(selection.equals(""));
        this.loadDebuggerCombo(list.toArray(new IPDebugConfiguration[list.size()]), defaultSelection);
    }

    protected void updateComboFromSelection() {
        super.updateComboFromSelection();
        this.initializeCommonControls(this.getLaunchConfiguration());
    }

    protected boolean validateDebuggerConfig(ILaunchConfiguration config) {
        IPDebugConfiguration debugConfig = this.getDebugConfig();
        if (debugConfig == null) {
            this.setErrorMessage(Messages.DebuggerTab_No_debugger_available);
            return false;
        }
        return true;
    }

    protected boolean validatePlatform(ILaunchConfiguration config, IPDebugConfiguration debugConfig) {
        return true;
    }
}

