/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.model.PVariableFormat;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIResumedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIVariableInfo;
import org.eclipse.ptp.debug.core.pdi.model.IPDITargetExpression;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeRange;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.model.AbstractPValue;
import org.eclipse.ptp.internal.debug.core.model.PLocalVariable;
import org.eclipse.ptp.internal.debug.core.model.PStackFrame;
import org.eclipse.ptp.internal.debug.core.model.PValueFactory;

public class PExpression
extends PLocalVariable
implements IExpression {
    private IPDITargetExpression fPDIExpression;
    private final PStackFrame fStackFrame;
    private final String fText;
    private IPValue fValue = PValueFactory.NULL_VALUE;

    public PExpression(PStackFrame frame, IPDITargetExpression pdiExpression, IPDIVariableDescriptor varObject) {
        super(frame, varObject);
        this.setFormat(PVariableFormat.getFormat(Preferences.getInt((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fText = pdiExpression.getExpressionText();
        this.fPDIExpression = pdiExpression;
        this.fStackFrame = frame;
    }

    public boolean canEnableDisable() {
        return true;
    }

    public void dispose() {
        if (this.fPDIExpression != null) {
            try {
                this.fPDIExpression.dispose();
                this.fPDIExpression = null;
            }
            catch (PDIException pDIException) {}
        }
        if (this.fValue instanceof AbstractPValue) {
            ((AbstractPValue)this.fValue).dispose();
            this.fValue = PValueFactory.NULL_VALUE;
        }
        this.internalDispose(true);
        this.setDisposed(true);
    }

    public String getExpressionString() throws DebugException {
        return this.getExpressionText();
    }

    public String getExpressionText() {
        return this.fText;
    }

    public IPValue getValue() {
        PStackFrame frame = (PStackFrame)this.getStackFrame();
        try {
            return this.getValue(frame);
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public void handleDebugEvents(IPDIEvent[] events) {
        IPDIEvent[] iPDIEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIEvent event2 = iPDIEventArray[n2];
            IPDIEvent event = event2;
            if (event.contains(this.getTasks())) {
                IPDISessionObject reason;
                if (event instanceof IPDIResumedEvent) {
                    this.setChanged(false);
                    this.resetValue();
                } else if (event instanceof IPDIChangedEvent && (reason = ((IPDIChangedEvent)event).getReason()) instanceof IPDIVariableInfo) {
                    this.setChanged(false);
                    this.resetValue();
                }
            }
            ++n2;
        }
        super.handleDebugEvents(events);
    }

    public boolean isEnabled() {
        return true;
    }

    protected IPStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    protected synchronized IPValue getValue(PStackFrame frame) throws DebugException {
        if (this.fValue.equals(PValueFactory.NULL_VALUE) && frame.isSuspended()) {
            try {
                IPDIVariable variable = this.fPDIExpression.getVariable(frame.getPDIStackFrame());
                if (variable != null) {
                    IAIF aif = variable.getAIF();
                    if (aif != null && aif.getType() instanceof IAIFTypeArray) {
                        IAIFTypeRange range = ((IAIFTypeArray)aif.getType()).getRange();
                        this.fValue = PValueFactory.createIndexedValue(this, variable, 0, range.getSize());
                    } else {
                        this.fValue = PValueFactory.createValue(this, variable);
                    }
                }
            }
            catch (PDIException e) {
                PExpression.targetRequestFailed(e.getMessage(), null);
            }
        }
        return this.fValue;
    }

    protected boolean isBookkeepingEnabled() {
        return false;
    }

    protected void resetValue() {
        if (this.fValue instanceof AbstractPValue) {
            ((AbstractPValue)this.fValue).reset();
        }
        this.fValue = PValueFactory.NULL_VALUE;
    }
}

