/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignal;
import org.eclipse.ptp.internal.debug.core.model.PDebugElement;

public class PSignal
extends PDebugElement
implements IPSignal {
    private final IPDISignal pdiSignal;

    public PSignal(IPSession session, TaskSet tasks, IPDISignal pdiSignal) {
        super(session, tasks);
        this.pdiSignal = pdiSignal;
    }

    public boolean canModify() {
        return true;
    }

    public void dispose() {
    }

    public String getDescription() throws DebugException {
        return this.getPDISignal().getDescription();
    }

    public String getName() throws DebugException {
        return this.getPDISignal().getName();
    }

    public boolean isPassEnabled() throws DebugException {
        return !this.getPDISignal().isIgnore();
    }

    public boolean isStopEnabled() throws DebugException {
        return this.getPDISignal().isStopSet();
    }

    public void setPassEnabled(boolean enable) throws DebugException {
        this.handle(enable, this.isStopEnabled());
    }

    public void setStopEnabled(boolean enable) throws DebugException {
        this.handle(this.isPassEnabled(), enable);
    }

    public void signal() throws DebugException {
        try {
            this.getPDISession().resume(this.getTasks(), this.getPDISignal());
        }
        catch (PDIException e) {
            PSignal.targetRequestFailed(e.getMessage(), null);
        }
    }

    private void handle(boolean pass, boolean stop) throws DebugException {
        try {
            this.getPDISignal().handle(!pass, stop);
        }
        catch (PDIException e) {
            PSignal.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected IPDISignal getPDISignal() {
        return this.pdiSignal;
    }
}

