/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.managedbuilder.xlc.ui;

import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.rdt.core.activator.Activator;
import org.eclipse.ptp.rdt.managedbuilder.xlc.ui.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.Workbench;

public class CProjectDescriptionListener
implements ICProjectDescriptionListener {
    private static CProjectDescriptionListener instance = new CProjectDescriptionListener();
    protected boolean fOldInputType = false;

    protected CProjectDescriptionListener() {
    }

    public static void startListening() {
        CCorePlugin.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener((ICProjectDescriptionListener)instance, 1);
    }

    public static void stopListening() {
        CCorePlugin.getDefault().getProjectDescriptionManager().removeCProjectDescriptionListener((ICProjectDescriptionListener)instance);
    }

    public void handleEvent(CProjectDescriptionEvent event) {
        ICProjectDescription old = event.getOldCProjectDescription();
        ICProjectDescription act = event.getNewCProjectDescription();
        if (act != null && this.completedProjectCreation(old, act)) {
            final IProject project = event.getProject();
            final ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            Job convertToolChainJob = new Job(Messages.getString("CProjectDescriptionListener_jobName")){
                ICLanguageSettingEntry[] fCPPIncludePathEntries;
                ICLanguageSettingEntry[] fCPPMacroEntries;
                {
                    super($anonymous0);
                    this.fCPPIncludePathEntries = null;
                    this.fCPPMacroEntries = null;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    ManagedBuildInfo info = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)project);
                    if (info == null) {
                        return Status.OK_STATUS;
                    }
                    ManagedProject cfr_ignored_0 = (ManagedProject)info.getManagedProject();
                    ICProjectDescription des = mngr.getProjectDescription(project, true);
                    des.getConfigurations();
                    if (info != null) {
                        IConfiguration config = info.getDefaultConfiguration();
                        ICConfigurationDescription configDes = des.getActiveConfiguration();
                        IToolChain toolChain = config.getToolChain();
                        ITool[] iToolArray = toolChain.getTools();
                        int n = iToolArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITool tool = iToolArray[n2];
                            if (tool.getId().indexOf("org.eclipse.ptp.rdt.managedbuild.tool.xlc.cpp.compiler.exe.debug") != -1) {
                                final ITool cppCompiler = tool;
                                IInputType[] iInputTypeArray = cppCompiler.getInputTypes();
                                int n3 = iInputTypeArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    final IInputType inputType = iInputTypeArray[n4];
                                    if (inputType.getId().indexOf("org.eclipse.ptp.rdt.managedbuilder.xlc.ui.cpp.c.compiler.input") != -1) {
                                        Workbench.getInstance().getDisplay().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                String question;
                                                Shell shell = new Shell();
                                                String title = Messages.getString("CProjectDescriptionListener_dialogTitle");
                                                boolean continueConversion = MessageDialog.openQuestion((Shell)shell, (String)title, (String)(question = CProjectDescriptionListener.this.getConversionDialogString()));
                                                if (continueConversion) {
                                                    cppCompiler.removeInputType(inputType);
                                                    (this).CProjectDescriptionListener.this.fOldInputType = true;
                                                }
                                            }
                                        });
                                        if (!CProjectDescriptionListener.this.fOldInputType) break;
                                        try {
                                            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                                            mngr.setProjectDescription(project, des, true, monitor);
                                        }
                                        catch (CoreException e) {
                                            Activator.log((Throwable)e);
                                        }
                                        break;
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        if (CProjectDescriptionListener.this.fOldInputType && configDes.getRootFolderDescription() != null) {
                            ITool langSetting;
                            configDes.getRootFolderDescription().getLanguageSettings();
                            iToolArray = configDes.getRootFolderDescription().getLanguageSettings();
                            n = iToolArray.length;
                            n2 = 0;
                            while (n2 < n) {
                                langSetting = iToolArray[n2];
                                if (langSetting.getId().indexOf("org.eclipse.ptp.rdt.managedbuilder.xlc.ui.cpp.compiler.input") != -1) {
                                    this.fCPPIncludePathEntries = langSetting.getSettingEntries(1);
                                    this.fCPPMacroEntries = langSetting.getSettingEntries(4);
                                    break;
                                }
                                ++n2;
                            }
                            iToolArray = configDes.getRootFolderDescription().getLanguageSettings();
                            n = iToolArray.length;
                            n2 = 0;
                            while (n2 < n) {
                                langSetting = iToolArray[n2];
                                if (langSetting.getId().indexOf("org.eclipse.ptp.rdt.managedbuilder.xlc.ui.c.compiler.input") != -1) {
                                    this.updateIncludeSettings((ICLanguageSetting)langSetting);
                                    this.updateMacroSettings((ICLanguageSetting)langSetting);
                                    try {
                                        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                                        mngr.setProjectDescription(project, des, true, monitor);
                                    }
                                    catch (CoreException e) {
                                        Activator.log((Throwable)e);
                                    }
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }

                private boolean updateMacroSettings(ICLanguageSetting langSetting) {
                    ICLanguageSettingEntry[] entries = langSetting.getSettingEntries(4);
                    LinkedList<Object> newEntries = new LinkedList<Object>();
                    ICLanguageSettingEntry[] iCLanguageSettingEntryArray = entries;
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n2];
                        newEntries.add(entry);
                        ++n2;
                    }
                    boolean entriesChanged = false;
                    ICLanguageSettingEntry[] iCLanguageSettingEntryArray2 = this.fCPPMacroEntries;
                    int n3 = this.fCPPMacroEntries.length;
                    n = 0;
                    while (n < n3) {
                        ICLanguageSettingEntry cppMacroEntry = iCLanguageSettingEntryArray2[n];
                        String symbol = ((CMacroEntry)cppMacroEntry).getName();
                        boolean symbolFound = false;
                        ICLanguageSettingEntry[] iCLanguageSettingEntryArray3 = entries;
                        int n4 = entries.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            ICLanguageSettingEntry entry = iCLanguageSettingEntryArray3[n5];
                            if (((CMacroEntry)entry).getName().equals(symbol)) {
                                symbolFound = true;
                                break;
                            }
                            ++n5;
                        }
                        if (!symbolFound) {
                            entriesChanged = true;
                            CMacroEntry newEntry = new CMacroEntry(symbol, cppMacroEntry.getValue(), cppMacroEntry.getFlags());
                            newEntries.add(newEntry);
                        }
                        ++n;
                    }
                    if (entriesChanged) {
                        langSetting.setSettingEntries(4, newEntries.toArray(new ICLanguageSettingEntry[0]));
                    }
                    return entriesChanged;
                }

                private boolean updateIncludeSettings(ICLanguageSetting langSetting) {
                    ICLanguageSettingEntry[] entries = langSetting.getSettingEntries(1);
                    LinkedList<Object> newEntries = new LinkedList<Object>();
                    ICLanguageSettingEntry[] iCLanguageSettingEntryArray = entries;
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n2];
                        newEntries.add(entry);
                        ++n2;
                    }
                    boolean entriesChanged = false;
                    ICLanguageSettingEntry[] iCLanguageSettingEntryArray2 = this.fCPPIncludePathEntries;
                    int n3 = this.fCPPIncludePathEntries.length;
                    n = 0;
                    while (n < n3) {
                        ICLanguageSettingEntry cppIncludePathEntry = iCLanguageSettingEntryArray2[n];
                        IPath path = ((CIncludePathEntry)cppIncludePathEntry).getLocation();
                        boolean pathFound = false;
                        ICLanguageSettingEntry[] iCLanguageSettingEntryArray3 = entries;
                        int n4 = entries.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            ICLanguageSettingEntry entry = iCLanguageSettingEntryArray3[n5];
                            if (((CIncludePathEntry)entry).getLocation().equals((Object)path)) {
                                pathFound = true;
                                break;
                            }
                            ++n5;
                        }
                        if (!pathFound) {
                            entriesChanged = true;
                            CIncludePathEntry newEntry = new CIncludePathEntry(path, cppIncludePathEntry.getFlags());
                            newEntries.add(newEntry);
                        }
                        ++n;
                    }
                    if (entriesChanged) {
                        langSetting.setSettingEntries(1, newEntries.toArray(new ICLanguageSettingEntry[0]));
                    }
                    return entriesChanged;
                }
            };
            convertToolChainJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            convertToolChainJob.schedule();
        }
    }

    private boolean completedProjectCreation(ICProjectDescription old, ICProjectDescription act) {
        return (old == null || old.isCdtProjectCreating()) && !act.isCdtProjectCreating();
    }

    protected String getConversionDialogString() {
        return Messages.getString("CProjectDescriptionListener_dialogQuestion");
    }
}

