/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.internal.remote.rse.core.LocalProcessWrapper;
import org.eclipse.ptp.internal.remote.rse.core.LocalSpawnerSubsystem;
import org.eclipse.ptp.internal.remote.rse.core.RSEConnection;
import org.eclipse.ptp.internal.remote.rse.core.RSEFileManager;
import org.eclipse.ptp.internal.remote.rse.core.RSEProcess;
import org.eclipse.ptp.internal.remote.rse.core.SpawnerSubsystem;
import org.eclipse.ptp.internal.remote.rse.core.messages.Messages;
import org.eclipse.ptp.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.connectorservice.local.LocalConnectorService;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEProcessBuilder
extends AbstractRemoteProcessBuilder {
    private static final String EXIT_CMD = "exit";
    private static final String CMD_DELIMITER = ";";
    private final RSEConnection fConnection;
    private final RSEFileManager fFileMgr;
    private Map<String, String> fRemoteEnv = new HashMap<String, String>();

    public RSEProcessBuilder(IRemoteConnection conn, IRemoteFileManager fileMgr, List<String> command) {
        super(conn, command);
        this.fConnection = (RSEConnection)conn;
        this.fFileMgr = (RSEFileManager)fileMgr;
        this.fRemoteEnv = new HashMap<String, String>(conn.getEnv());
    }

    public RSEProcessBuilder(IRemoteConnection conn, IRemoteFileManager fileMgr, String ... command) {
        this(conn, fileMgr, Arrays.asList(command));
    }

    private String[] getEnvironment() {
        String[] env = new String[this.fRemoteEnv.size()];
        int pos = 0;
        for (Map.Entry<String, String> entry : this.fRemoteEnv.entrySet()) {
            env[pos++] = String.valueOf(entry.getKey()) + "=" + entry.getValue();
        }
        return env;
    }

    public Map<String, String> environment() {
        return this.fRemoteEnv;
    }

    public int getSupportedFlags() {
        return 0;
    }

    public IRemoteProcess start(int flags) throws IOException {
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        String remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = String.valueOf(remoteCmd) + " ";
            }
            remoteCmd = String.valueOf(remoteCmd) + this.spaceEscapify((String)cmdArgs.get(i));
            ++i;
        }
        IHostShell hostShell = null;
        try {
            SpawnerSubsystem subsystem;
            String initialDir = "";
            if (this.directory() != null) {
                initialDir = this.directory().toURI().getPath();
            }
            if ((subsystem = this.getSpawnerSubsystem()) instanceof LocalSpawnerSubsystem) {
                Process process = subsystem.spawnLocalRedirected(remoteCmd, initialDir, null, this.getEnvironment(), (IProgressMonitor)new NullProgressMonitor());
                return new LocalProcessWrapper(process);
            }
            if (subsystem != null) {
                hostShell = subsystem.spawnRedirected(remoteCmd, initialDir, null, this.getEnvironment(), (IProgressMonitor)new NullProgressMonitor());
                if (hostShell == null) {
                    hostShell = this.launchCommandWithRSE(remoteCmd, initialDir);
                }
            } else {
                hostShell = this.launchCommandWithRSE(remoteCmd, initialDir);
            }
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
            return null;
        }
        return new RSEProcess(hostShell, this.redirectErrorStream());
    }

    private IHostShell launchCommandWithRSE(String remoteCmd, String initialDir) throws IOException, SystemMessageException {
        remoteCmd = String.valueOf(remoteCmd) + ";exit";
        IShellService shellService = this.fConnection.getRemoteShellService();
        if (shellService == null) {
            throw new IOException(Messages.RSEProcessBuilder_0);
        }
        IHostShell hostShell = shellService.runCommand(initialDir, remoteCmd, this.getEnvironment(), (IProgressMonitor)new NullProgressMonitor());
        return hostShell;
    }

    private SpawnerSubsystem getSpawnerSubsystem() {
        ISubSystem[] subsystems;
        DStoreConnectorService connectorService = this.getDStoreConnectorService();
        if (connectorService == null && (connectorService = this.getLocalConnectorService()) == null) {
            return null;
        }
        ISubSystem[] iSubSystemArray = subsystems = connectorService.getSubSystems();
        int n = subsystems.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsystem = iSubSystemArray[n2];
            if (subsystem instanceof SpawnerSubsystem) {
                return (SpawnerSubsystem)subsystem;
            }
            ++n2;
        }
        return null;
    }

    private LocalConnectorService getLocalConnectorService() {
        IConnectorService[] iConnectorServiceArray = this.fConnection.getHost().getConnectorServices();
        int n = iConnectorServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService service = iConnectorServiceArray[n2];
            if (service instanceof LocalConnectorService) {
                return (LocalConnectorService)service;
            }
            ++n2;
        }
        return null;
    }

    private DStoreConnectorService getDStoreConnectorService() {
        IConnectorService[] iConnectorServiceArray = this.fConnection.getHost().getConnectorServices();
        int n = iConnectorServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService service = iConnectorServiceArray[n2];
            if (service instanceof DStoreConnectorService) {
                return (DStoreConnectorService)service;
            }
            ++n2;
        }
        return null;
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    public IFileStore directory() {
        if (super.directory() == null) {
            String cwd = this.environment().get("PWD");
            if (cwd == null) {
                cwd = this.environment().get("CD");
            }
            if (cwd != null) {
                return this.fFileMgr.getResource(cwd);
            }
        }
        return super.directory();
    }
}

