/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.ChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IEnableChannelDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceDomainComponent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnableChannelDialog
extends Dialog
implements IEnableChannelDialog {
    public static final String ENABLE_CHANNEL_ICON_FILE = "icons/elcl16/add_button.gif";
    private Text fChannelNameText = null;
    private Button fDiscardModeButton = null;
    private Button fOverwriteModeButton = null;
    private Text fSubBufferSizeText = null;
    private Text fNumberOfSubBuffersText = null;
    private Text fSwitchTimerText = null;
    private Text fReadTimerText = null;
    private Button fKernelButton = null;
    private Button fUstButton = null;
    private TraceDomainComponent fDomain = null;
    private VerifyListener fVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            e.doit = e.text.matches("[0-9]*");
        }
    };
    private IChannelInfo fChannelInfo = null;
    private boolean fIsKernel = true;
    private boolean fHasKernel;

    public EnableChannelDialog(Shell shell) {
        super(shell);
        this.setShellStyle(16);
    }

    @Override
    public IChannelInfo getChannelInfo() {
        return this.fChannelInfo;
    }

    @Override
    public void setDomainComponent(TraceDomainComponent domain) {
        this.fDomain = domain;
        this.fIsKernel = this.fDomain != null ? this.fDomain.isKernel() : true;
    }

    @Override
    public boolean isKernel() {
        return this.fIsKernel;
    }

    @Override
    public void setHasKernel(boolean hasKernel) {
        this.fIsKernel = this.fDomain != null ? this.fDomain.isKernel() : hasKernel;
        this.fHasKernel = hasKernel;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_EnableChannelDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(ENABLE_CHANNEL_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, true);
        dialogComposite.setLayout((Layout)layout);
        Label channelNameLabel = new Label(dialogComposite, 131072);
        channelNameLabel.setText(Messages.TraceControl_EnableChannelNameLabel);
        this.fChannelNameText = new Text(dialogComposite, 0);
        this.fChannelNameText.setToolTipText(Messages.TraceControl_EnableChannelNameTooltip);
        Label subBufferSizeLabel = new Label(dialogComposite, 131072);
        subBufferSizeLabel.setText(Messages.TraceControl_SubBufferSizePropertyName);
        this.fSubBufferSizeText = new Text(dialogComposite, 0);
        this.fSubBufferSizeText.setToolTipText(Messages.TraceControl_EnableChannelSubBufferSizeTooltip);
        this.fSubBufferSizeText.addVerifyListener(this.fVerifyListener);
        Label numSubBufferLabel = new Label(dialogComposite, 131072);
        numSubBufferLabel.setText(Messages.TraceControl_NbSubBuffersPropertyName);
        this.fNumberOfSubBuffersText = new Text(dialogComposite, 0);
        this.fNumberOfSubBuffersText.setToolTipText(Messages.TraceControl_EnableChannelNbSubBuffersTooltip);
        this.fNumberOfSubBuffersText.addVerifyListener(this.fVerifyListener);
        Label switchTimerLabel = new Label(dialogComposite, 131072);
        switchTimerLabel.setText(Messages.TraceControl_SwitchTimerPropertyName);
        this.fSwitchTimerText = new Text(dialogComposite, 0);
        this.fSwitchTimerText.setToolTipText(Messages.TraceControl_EnableChannelSwitchTimerTooltip);
        this.fSwitchTimerText.addVerifyListener(this.fVerifyListener);
        Label readTimerLabel = new Label(dialogComposite, 131072);
        readTimerLabel.setText(Messages.TraceControl_ReadTimerPropertyName);
        this.fReadTimerText = new Text(dialogComposite, 0);
        this.fReadTimerText.setToolTipText(Messages.TraceControl_EnableChannelReadTimerTooltip);
        this.fReadTimerText.addVerifyListener(this.fVerifyListener);
        Group discardModeGroup = new Group(dialogComposite, 32);
        discardModeGroup.setText(Messages.TraceControl_EnableChannelDiscardModeGroupName);
        layout = new GridLayout(2, true);
        discardModeGroup.setLayout((Layout)layout);
        this.fDiscardModeButton = new Button((Composite)discardModeGroup, 16);
        this.fDiscardModeButton.setText(Messages.TraceControl_EnableChannelDiscardModeLabel);
        this.fDiscardModeButton.setToolTipText(Messages.TraceControl_EnableChannelDiscardModeTooltip);
        this.fDiscardModeButton.setSelection(true);
        this.fOverwriteModeButton = new Button((Composite)discardModeGroup, 16);
        this.fOverwriteModeButton.setText(Messages.TraceControl_EnableChannelOverwriteModeLabel);
        this.fOverwriteModeButton.setToolTipText(Messages.TraceControl_EnableChannelOverwriteModeTooltip);
        this.fOverwriteModeButton.setSelection(false);
        Group domainGroup = new Group(dialogComposite, 32);
        domainGroup.setText(Messages.TraceControl_DomainDisplayName);
        layout = new GridLayout(2, true);
        domainGroup.setLayout((Layout)layout);
        this.fKernelButton = new Button((Composite)domainGroup, 16);
        this.fKernelButton.setText(Messages.TraceControl_KernelDomainDisplayName);
        this.fKernelButton.setSelection(this.fIsKernel);
        this.fUstButton = new Button((Composite)domainGroup, 16);
        this.fUstButton.setText(Messages.TraceControl_UstDisplayName);
        this.fUstButton.setSelection(!this.fIsKernel);
        if (this.fDomain != null || !this.fHasKernel) {
            this.fKernelButton.setEnabled(false);
            this.fUstButton.setEnabled(false);
        }
        GridData data = new GridData(4, 2, false, false, 3, 1);
        discardModeGroup.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fDiscardModeButton.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fOverwriteModeButton.setLayoutData((Object)data);
        data = new GridData(4, 2, false, false, 3, 1);
        domainGroup.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fKernelButton.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fUstButton.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.fChannelNameText.setLayoutData((Object)data);
        this.fSubBufferSizeText.setLayoutData((Object)data);
        this.fNumberOfSubBuffersText.setLayoutData((Object)data);
        this.fSwitchTimerText.setLayoutData((Object)data);
        this.fReadTimerText.setLayoutData((Object)data);
        this.setDefaults();
        return dialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 13, "&Default", true);
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        this.fChannelInfo = new ChannelInfo(this.fChannelNameText.getText());
        this.fChannelInfo.setSubBufferSize(Long.parseLong(this.fSubBufferSizeText.getText()));
        this.fChannelInfo.setNumberOfSubBuffers(Integer.parseInt(this.fNumberOfSubBuffersText.getText()));
        this.fChannelInfo.setSwitchTimer(Long.parseLong(this.fSwitchTimerText.getText()));
        this.fChannelInfo.setReadTimer(Long.parseLong(this.fReadTimerText.getText()));
        this.fChannelInfo.setOverwriteMode(this.fOverwriteModeButton.getSelection());
        this.fIsKernel = this.fKernelButton.getSelection();
        if (!this.fChannelInfo.getName().matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableChannelDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidChannelNameError) + " (" + this.fChannelInfo.getName() + ") \n"));
            return;
        }
        if (this.fDomain != null && this.fDomain.containsChild(this.fChannelInfo.getName())) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableChannelDialogTitle, (String)(String.valueOf(Messages.TraceControl_ChannelAlreadyExistsError) + " (" + this.fChannelInfo.getName() + ") \n"));
            return;
        }
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            this.setDefaults();
            return;
        }
        super.buttonPressed(buttonId);
    }

    private void setDefaults() {
        this.fSwitchTimerText.setText(String.valueOf(0L));
        this.fReadTimerText.setText(String.valueOf(200L));
        this.fOverwriteModeButton.setSelection(false);
        if (this.fKernelButton.getSelection()) {
            this.fSubBufferSizeText.setText(String.valueOf(262144L));
            this.fNumberOfSubBuffersText.setText(String.valueOf(4));
        } else {
            this.fSubBufferSizeText.setText(String.valueOf(4096L));
            this.fNumberOfSubBuffersText.setText(String.valueOf(8));
        }
    }
}

