/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.property.set.DelegatingSetProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

public class AnonymousPojoSetProperty
extends DelegatingSetProperty {
    private final String propertyName;
    private Map delegates;

    public AnonymousPojoSetProperty(String propertyName, Class elementType) {
        super((Object)elementType);
        this.propertyName = propertyName;
        this.delegates = new HashMap();
    }

    protected ISetProperty doGetDelegate(Object source) {
        IBeanSetProperty delegate;
        Class<?> beanClass = source.getClass();
        if (this.delegates.containsKey(beanClass)) {
            return (ISetProperty)this.delegates.get(beanClass);
        }
        try {
            delegate = PojoProperties.set(beanClass, this.propertyName, (Class)this.getElementType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public String toString() {
        String s = "?." + this.propertyName + "{}";
        Class elementType = (Class)this.getElementType();
        if (elementType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(elementType) + ">";
        }
        return s;
    }
}

