/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTIntConstNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class FuseLoopsRefactoring
extends FortranEditorRefactoring {
    private ArrayList<ASTProperLoopConstructNode> loopList;
    private ASTProperLoopConstructNode firstDoLoop;
    private ASTProperLoopConstructNode secondDoLoop;
    private int firstNormal;
    private int secondNormal;

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        this.loopList = new ArrayList();
        this.firstDoLoop = FuseLoopsRefactoring.getLoopNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (this.firstDoLoop == null) {
            this.fail(Messages.FuseLoopsRefactoring_NoSecondLoopErrorMsg);
        }
        this.secondDoLoop = this.getSecondLoopToAlign(this.firstDoLoop);
        if (this.secondDoLoop == null) {
            this.fail(Messages.FuseLoopsRefactoring_NoSecondLoopErrorMsg);
        }
        if (this.checkForIncorrectBounds()) {
            this.fail(Messages.FuseLoopsRefactoring_SelectLoopWithIntegers);
        }
        try {
            this.firstDoLoop.getStepInt();
            this.secondDoLoop.getStepInt();
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(Messages.FuseLoopsRefactoring_InvalidStepError);
        }
        if (!this.checkLoopCompatibility(this.firstDoLoop, this.secondDoLoop)) {
            this.fail(Messages.FuseLoopsRefactoring_IncompatibleLoopErorrMessage);
        }
        if (this.checkForLabels(this.firstDoLoop.getBody()) || this.checkForLabels(this.secondDoLoop.getBody())) {
            this.fail(Messages.FuseLoopsRefactoring_SelectLoopsWithoutLabels);
        }
        if (this.checkForCycleExit(this.firstDoLoop.getBody()) || this.checkForCycleExit(this.secondDoLoop.getBody())) {
            this.fail(Messages.FuseLoopsRefactoring_CycleExitFails);
        }
    }

    private ASTProperLoopConstructNode getSecondLoopToAlign(ASTProperLoopConstructNode loop) {
        ScopingNode.getLocalScope(loop).getOrCreateBody();
        IASTListNode body = loop.findNearestAncestor(IASTListNode.class);
        this.findAllLoopsInScope(body);
        int i = this.loopList.indexOf(loop);
        return this.loopList.get(i + 1);
    }

    private void findAllLoopsInScope(IASTNode node) {
        node.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
                FuseLoopsRefactoring.this.loopList.add(node);
            }
        });
    }

    private boolean checkForIncorrectBounds() {
        return !(this.firstDoLoop.getLowerBoundIExpr() instanceof ASTIntConstNode) || !(this.firstDoLoop.getUpperBoundIExpr() instanceof ASTIntConstNode) || !(this.secondDoLoop.getLowerBoundIExpr() instanceof ASTIntConstNode) || !(this.secondDoLoop.getUpperBoundIExpr() instanceof ASTIntConstNode);
    }

    private boolean checkForLabels(IASTListNode<IExecutionPartConstruct> body) {
        int i = 0;
        while (i < body.size()) {
            if (((IExecutionPartConstruct)body.get(i)).findFirstToken().getTerminal() == Terminal.T_ICON) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkForCycleExit(IASTNode node) {
        FindKeywordVisitor findCycleExit = new FindKeywordVisitor();
        node.accept(findCycleExit);
        boolean theanswer = findCycleExit.getHasCycleExit();
        return theanswer;
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.normalizeLoopIterations(this.firstDoLoop, this.secondDoLoop);
        this.fuseLoops(this.firstDoLoop, this.secondDoLoop);
        Reindenter.reindent(this.firstDoLoop, this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    void normalizeLoopIterations(ASTProperLoopConstructNode first, ASTProperLoopConstructNode second) {
        int fLow = first.getLowerBoundInt();
        int fHigh = first.getUpperBoundInt();
        int sLow = second.getLowerBoundInt();
        int sHigh = second.getUpperBoundInt();
        int fStep = first.getStepInt();
        int sStep = second.getStepInt();
        this.firstNormal = fHigh - fLow;
        this.firstNormal /= fStep;
        this.secondNormal = sHigh - sLow;
        this.secondNormal /= sStep;
        this.replaceIndexVariableNameWithUpdated(first.getBody(), fStep, fLow, first.getIndexVariable().getText());
        this.replaceIndexVariableNameWithUpdated(second.getBody(), sStep, sLow, second.getIndexVariable().getText());
        first.setLowerBoundIExpr(0);
        second.setLowerBoundIExpr(0);
        first.setUpperBoundIExpr(this.firstNormal);
        second.setUpperBoundIExpr(this.secondNormal);
        first.setStepInt(1);
        second.setStepInt(1);
    }

    private void replaceIndexVariableNameWithUpdated(IASTNode node, final int stepNum, final int low, final String iterationName) {
        node.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT && token.getText().equalsIgnoreCase(iterationName)) {
                    String s = "(" + token.getText() + "*" + Integer.toString(stepNum);
                    s = String.valueOf(s) + "+" + Integer.toString(low) + ")";
                    token.replaceWith(s);
                }
            }
        });
    }

    private void fuseLoops(ASTProperLoopConstructNode first, ASTProperLoopConstructNode second) {
        IASTListNode<IExecutionPartConstruct> firstBody = first.getBody();
        IASTListNode<IBodyConstruct> secondBody = FuseLoopsRefactoring.parseLiteralStatementSequence(second.getBody().toString());
        this.replaceIndexVariableName(secondBody, second.getIndexVariable().getText(), first.getIndexVariable().getText());
        firstBody.add(secondBody);
        second.removeFromTree();
    }

    private void replaceIndexVariableName(IASTNode node, final String name, final String replacer) {
        node.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT && token.getText().equals(name)) {
                    token.setText(replacer);
                }
            }
        });
    }

    private boolean checkLoopCompatibility(ASTProperLoopConstructNode first, ASTProperLoopConstructNode second) {
        this.calculateNormalizedLoopBounds(first, second);
        return this.firstNormal == this.secondNormal;
    }

    private void calculateNormalizedLoopBounds(ASTProperLoopConstructNode first, ASTProperLoopConstructNode second) {
        int fLow = first.getLowerBoundInt();
        int fHigh = first.getUpperBoundInt();
        int sLow = second.getLowerBoundInt();
        int sHigh = second.getUpperBoundInt();
        int fStep = first.getStepInt();
        int sStep = second.getStepInt();
        this.firstNormal = fHigh - fLow;
        this.firstNormal /= fStep;
        this.secondNormal = sHigh - sLow;
        this.secondNormal /= sStep;
    }

    public String getName() {
        return Messages.FuseLoopsRefactoring_LoopFusionName;
    }

    public class FindKeywordVisitor
    extends ASTVisitorWithLoops {
        private boolean hasCycleExit = false;

        public boolean getHasCycleExit() {
            return this.hasCycleExit;
        }

        @Override
        public void visitToken(Token token) {
            if (token.getTerminal() == Terminal.T_EXIT || token.getTerminal() == Terminal.T_CYCLE) {
                this.hasCycleExit = true;
            }
        }
    }
}

