/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.internal.callgraph.Messages;
import org.eclipse.linuxtools.internal.callgraph.StapData;
import org.eclipse.linuxtools.internal.callgraph.StapGraph;
import org.eclipse.linuxtools.internal.callgraph.StapGraphParser;
import org.eclipse.linuxtools.internal.callgraph.StapNode;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapParser;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapView;
import org.eclipse.linuxtools.internal.callgraph.graphlisteners.AutoScrollSelectionListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CallgraphView
extends SystemTapView {
    private StapGraphParser parser;
    private Action viewTreeview;
    private Action viewRadialview;
    private Action viewAggregateview;
    private Action viewLevelview;
    private Action viewRefresh;
    private Action animationSlow;
    private Action animationFast;
    private Action modeCollapsedNodes;
    private Action markersNext;
    private Action markersPrevious;
    private Action limits;
    private Action gotoNext;
    private Action gotoPrevious;
    private Action gotoLast;
    private Action play;
    private Action saveDot;
    private Action saveColDot;
    private Action saveCurDot;
    private Action saveText;
    ImageDescriptor playImage = CallgraphView.getImageDescriptor("icons/perform.png");
    ImageDescriptor pauseImage = CallgraphView.getImageDescriptor("icons/pause.gif");
    private IMenuManager menu;
    private IMenuManager gotoMenu;
    private IMenuManager view;
    private IMenuManager animation;
    private IMenuManager markers;
    private IMenuManager saveMenu;
    public IToolBarManager mgr;
    private Composite graphComp;
    private Composite treeComp;
    private StapGraph g;
    private int treeSize = 200;

    public IStatus initializeView(Display targetDisplay, IProgressMonitor monitor) {
        Display disp = targetDisplay;
        if (disp == null) {
            disp = Display.getCurrent();
        }
        if (disp == null) {
            disp = Display.getDefault();
        }
        this.treeSize = 200;
        this.makeTreeComp(this.treeSize);
        this.makeGraphComp();
        this.graphComp.setBackgroundMode(2);
        Canvas papaCanvas = new Canvas(this.graphComp, 2048);
        GridLayout papaLayout = new GridLayout(1, true);
        papaLayout.horizontalSpacing = 0;
        papaLayout.verticalSpacing = 0;
        papaLayout.marginHeight = 0;
        papaLayout.marginWidth = 0;
        papaCanvas.setLayout((Layout)papaLayout);
        GridData papaGD = new GridData(1, 1, false, false);
        papaGD.widthHint = 160;
        papaCanvas.setLayoutData((Object)papaGD);
        Image image = CallgraphView.getImageDescriptor("icons/up.gif").createImage();
        Button up = new Button((Composite)papaCanvas, 8);
        GridData buttonData = new GridData(0x1000000, 0x1000000, true, false);
        buttonData.widthHint = 150;
        buttonData.heightHint = 20;
        up.setData((Object)buttonData);
        up.setImage(image);
        up.setToolTipText(Messages.getString("CallgraphView.ThumbNailUp"));
        Canvas thumbCanvas = new Canvas((Composite)papaCanvas, 0);
        image = CallgraphView.getImageDescriptor("icons/down.gif").createImage();
        Button down = new Button((Composite)papaCanvas, 8);
        buttonData = new GridData(0x1000000, 0x1000000, true, false);
        buttonData.widthHint = 150;
        buttonData.heightHint = 0;
        down.setData((Object)buttonData);
        down.setImage(image);
        down.setToolTipText(Messages.getString("CallgraphView.ThumbNailDown"));
        this.g = new StapGraph(this.graphComp, 2048, this.treeComp, papaCanvas, this);
        this.g.setLayoutData(new GridData(this.masterComposite.getBounds().width, Display.getCurrent().getBounds().height - this.treeSize));
        up.addSelectionListener((SelectionListener)new AutoScrollSelectionListener(0, this.g));
        down.addSelectionListener((SelectionListener)new AutoScrollSelectionListener(1, this.g));
        GridData thumbGD = new GridData(1, 1, false, false);
        thumbGD.widthHint = 160;
        thumbCanvas.setLayoutData((Object)thumbGD);
        LightweightSystem lws = new LightweightSystem(thumbCanvas);
        ScrollableThumbnail thumb = new ScrollableThumbnail(this.g.getViewport());
        thumb.setSource(this.g.getContents());
        lws.setContents((IFigure)thumb);
        this.loadData(monitor);
        return this.finishLoad(monitor);
    }

    private IStatus loadData(IProgressMonitor mon) {
        IProgressMonitor monitor = mon;
        if (this.g.getNodeData(0) == null) {
            this.g.loadData(0, 0, StapGraph.CONSTANT_TOP_NODE_NAME, 1L, 1, -1, false, "");
        }
        this.g.setStartTime(this.parser.startTime);
        this.g.setEndTime(this.parser.endingTimeInNS);
        for (int id_parent : this.parser.serialMap.keySet()) {
            if (id_parent < 0) continue;
            boolean marked = false;
            String msg = "";
            if (this.g.getNodeData(id_parent) == null) {
                if (this.parser.markedMap.get(id_parent) != null) {
                    marked = true;
                    msg = this.parser.markedMap.remove(id_parent);
                }
                this.g.loadData(0, id_parent, this.parser.serialMap.get(id_parent), this.parser.timeMap.get(id_parent), 1, 0, marked, msg);
            }
            for (int key : this.parser.neighbourMaps.keySet()) {
                HashMap<Integer, ArrayList<Integer>> outNeighbours = this.parser.neighbourMaps.get(key);
                if (outNeighbours == null || outNeighbours.get(id_parent) == null) continue;
                for (int id_child : outNeighbours.get(id_parent)) {
                    if (this.g.getNodeData(id_child) != null && id_child < 0) {
                        this.g.addCalled(id_child);
                        continue;
                    }
                    if (this.g.getNodeData(id_child) != null) continue;
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    marked = false;
                    msg = "";
                    if (this.parser.markedMap.get(id_child) != null) {
                        marked = true;
                        msg = this.parser.markedMap.remove(id_child);
                    }
                    if (id_child == -1) continue;
                    if (this.parser.timeMap.get(id_child) == null) {
                        this.g.loadData(0, id_child, this.parser.serialMap.get(id_child), this.parser.timeMap.get(0), 1, id_parent, marked, msg);
                        continue;
                    }
                    this.g.loadData(0, id_child, this.parser.serialMap.get(id_child), this.parser.timeMap.get(id_child), 1, id_parent, marked, msg);
                }
            }
            if (this.parser.neighbourMaps.size() <= 1) continue;
            this.g.setThreaded();
        }
        monitor.worked(1);
        if (this.parser.markedMap.size() > 0) {
            for (int key : this.parser.markedMap.keySet()) {
                this.g.insertMessage(key, this.parser.markedMap.get(key));
            }
            this.parser.markedMap.clear();
        }
        if (this.g.aggregateTime == null) {
            this.g.aggregateTime = new HashMap();
        }
        if (this.g.aggregateCount == null) {
            this.g.aggregateCount = new HashMap();
        }
        this.g.aggregateCount.putAll(this.parser.countMap);
        this.g.aggregateTime.putAll(this.parser.aggregateTimeMap);
        this.g.setLastFunctionCalled(0);
        this.g.recursivelyCollapseAllChildrenOfNode(this.g.getTopNode());
        monitor.worked(1);
        this.setGraphOptions(true);
        this.g.initializeTree();
        this.g.setProject(this.parser.project);
        return Status.OK_STATUS;
    }

    private IStatus finishLoad(IProgressMonitor monitor) {
        if (this.g.aggregateCount == null) {
            this.g.aggregateCount = new HashMap();
        }
        this.g.aggregateCount.putAll(this.parser.countMap);
        if (this.g.aggregateTime == null) {
            this.g.aggregateTime = new HashMap();
        }
        this.g.aggregateTime.putAll(this.parser.aggregateTimeMap);
        if (this.parser.totalTime != -1L) {
            this.g.setTotalTime(this.parser.totalTime);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.g.initializeTree();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.g.setCallOrderList(this.parser.callOrderList);
        this.g.setProject(this.parser.project);
        this.initializePartControl();
        return Status.OK_STATUS;
    }

    public void setGraphOptions(boolean visible) {
        this.play.setEnabled(visible);
        this.saveFile.setEnabled(visible);
        this.saveDot.setEnabled(visible);
        this.saveColDot.setEnabled(visible);
        this.saveCurDot.setEnabled(visible);
        this.saveText.setEnabled(visible);
        this.viewTreeview.setEnabled(visible);
        this.viewRadialview.setEnabled(visible);
        this.viewAggregateview.setEnabled(visible);
        this.viewLevelview.setEnabled(visible);
        this.viewRefresh.setEnabled(visible);
        this.limits.setEnabled(visible);
        this.markersNext.setEnabled(visible);
        this.markersPrevious.setEnabled(visible);
        this.animationSlow.setEnabled(visible);
        this.animationFast.setEnabled(visible);
        this.modeCollapsedNodes.setEnabled(visible);
        this.gotoNext.setEnabled(visible);
        this.gotoPrevious.setEnabled(visible);
        this.gotoLast.setEnabled(visible);
    }

    public void makeTreeComp(int treeSize) {
        if (this.treeComp != null && !this.treeComp.isDisposed()) {
            this.treeComp.dispose();
        }
        this.treeComp = new Composite(this.masterComposite, 0);
        GridData treegd = new GridData(1, 4, false, true);
        treegd.widthHint = treeSize;
        this.treeComp.setLayout((Layout)new FillLayout());
        this.treeComp.setLayoutData((Object)treegd);
    }

    public void makeGraphComp() {
        if (this.graphComp != null && !this.graphComp.isDisposed()) {
            this.graphComp.dispose();
        }
        this.graphComp = new Composite(this.masterComposite, 0);
        GridData graphgd = new GridData(4, 4, true, true);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.graphComp.setLayout((Layout)gl);
        this.graphComp.setLayoutData((Object)graphgd);
    }

    private void initializePartControl() {
        this.setGraphOptions(true);
        if (this.graphComp == null) {
            return;
        }
        this.graphComp.setParent(this.masterComposite);
        if (this.treeComp != null) {
            this.treeComp.setParent(this.masterComposite);
        }
        this.graphComp.setSize(this.masterComposite.getSize().x, this.masterComposite.getSize().y);
    }

    public void createPartControl(Composite parent) {
        if (this.masterComposite != null) {
            this.masterComposite.dispose();
        }
        this.masterComposite = parent;
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        GridData gd = new GridData(100, 100);
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)gd);
        this.createActions();
        this.mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.menu = this.getViewSite().getActionBars().getMenuManager();
        this.addFileMenu();
        this.saveCurDot = new Action(Messages.getString("CallgraphView.SaveViewAsDot")){

            public void run() {
                CallgraphView.this.writeToDot(CallgraphView.this.g.getCollapseMode(), ((CallgraphView)CallgraphView.this).g.nodeMap.keySet());
            }
        };
        this.saveDot = new Action(Messages.getString("CallgraphView.SaveAllUncollapsedAsDot")){

            public void run() {
                CallgraphView.this.writeToDot(false, ((CallgraphView)CallgraphView.this).g.nodeDataMap.keySet());
            }
        };
        this.saveColDot = new Action(Messages.getString("CallgraphView.SaveAllCollapsedAsDot")){

            public void run() {
                CallgraphView.this.writeToDot(true, ((CallgraphView)CallgraphView.this).g.nodeDataMap.keySet());
            }
        };
        this.saveText = new Action(Messages.getString("CallgraphView.SaveCollapsedAsASCII")){

            public void run() {
                Shell sh = new Shell();
                FileDialog dialog = new FileDialog(sh, 8192);
                String filePath = dialog.open();
                if (filePath == null) {
                    return;
                }
                File f = new File(filePath);
                f.delete();
                try {
                    f.createNewFile();
                    BufferedWriter out = new BufferedWriter(new FileWriter(f));
                    StringBuilder builder = new StringBuilder();
                    builder.append("                           Function                           | Called |  Time\n");
                    for (StapData k : ((CallgraphView)CallgraphView.this).g.nodeDataMap.values()) {
                        if (!k.isCollapsed && !k.isOnlyChildWithThisName()) continue;
                        if (k.isCollapsed) {
                            StringBuilder name = new StringBuilder(k.name);
                            name = CallgraphView.this.fixString(name, 60);
                            builder.append(" " + name + " | ");
                            StringBuilder called = new StringBuilder("" + k.timesCalled);
                            called = CallgraphView.this.fixString(called, 6);
                            StringBuilder time = new StringBuilder(StapNode.numberFormat.format((float)k.getTime() / (float)CallgraphView.this.g.getTotalTime() * 100.0f) + "%");
                            time = CallgraphView.this.fixString(time, 6);
                            builder.append(called + " | " + time + "\n");
                        }
                        if (builder.length() <= 2000) continue;
                        out.append(builder.toString());
                        out.flush();
                        builder.setLength(0);
                    }
                    if (builder.length() > 0) {
                        out.append(builder.toString());
                    }
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        this.saveMenu = new MenuManager(Messages.getString("CallgraphView.SaveMenu"));
        this.file.add((IContributionItem)this.saveMenu);
        this.saveMenu.add((IAction)this.saveCurDot);
        this.saveMenu.add((IAction)this.saveColDot);
        this.saveMenu.add((IAction)this.saveText);
        this.saveMenu.add((IAction)this.saveDot);
        this.view = new MenuManager(Messages.getString("CallgraphView.ViewMenu"));
        this.animation = new MenuManager(Messages.getString("CallgraphView.AnimationMenu"));
        this.markers = new MenuManager(Messages.getString("CallgraphView.Markers"));
        this.gotoMenu = new MenuManager(Messages.getString("CallgraphView.GoTo"));
        this.menu.add((IContributionItem)this.view);
        this.menu.add((IContributionItem)this.gotoMenu);
        this.addHelpMenu();
        this.view.add((IAction)this.viewTreeview);
        this.view.add((IAction)this.viewRadialview);
        this.view.add((IAction)this.viewAggregateview);
        this.view.add((IAction)this.viewLevelview);
        this.view.add((IAction)this.getViewRefresh());
        this.view.add((IAction)this.modeCollapsedNodes);
        this.view.add((IAction)this.limits);
        this.view.add((IContributionItem)this.animation);
        this.gotoMenu.add((IAction)this.play);
        this.gotoMenu.add((IAction)this.gotoPrevious);
        this.gotoMenu.add((IAction)this.gotoNext);
        this.gotoMenu.add((IAction)this.gotoLast);
        this.gotoMenu.add((IContributionItem)this.markers);
        this.addKillButton();
        this.mgr.add((IAction)this.play);
        this.mgr.add((IAction)this.viewRadialview);
        this.mgr.add((IAction)this.viewTreeview);
        this.mgr.add((IAction)this.viewLevelview);
        this.mgr.add((IAction)this.viewAggregateview);
        this.mgr.add((IAction)this.modeCollapsedNodes);
        this.markers.add((IAction)this.markersNext);
        this.markers.add((IAction)this.markersPrevious);
        this.animation.add((IAction)this.animationSlow);
        this.animation.add((IAction)this.animationFast);
        this.setGraphOptions(false);
    }

    public StringBuilder fixString(StringBuilder name, int length) {
        if (name.length() > length) {
            name = new StringBuilder(name.substring(0, length - 1));
        } else {
            int diff = length - name.length();
            boolean left = true;
            while (diff > 0) {
                if (left) {
                    name.insert(0, " ");
                    left = false;
                } else {
                    name.append(" ");
                    left = true;
                }
                --diff;
            }
        }
        return name;
    }

    public void createViewActions() {
        this.viewTreeview = new Action(Messages.getString("CallgraphView.TreeView")){

            public void run() {
                CallgraphView.this.g.draw(2, CallgraphView.this.g.getAnimationMode(), CallgraphView.this.g.getRootVisibleNodeNumber());
                CallgraphView.this.g.scrollTo(((CallgraphView)CallgraphView.this).g.getNode((int)((CallgraphView)CallgraphView.this).g.getRootVisibleNodeNumber()).getLocation().x - ((CallgraphView)CallgraphView.this).g.getBounds().width / 2, ((CallgraphView)CallgraphView.this).g.getNode((int)((CallgraphView)CallgraphView.this).g.getRootVisibleNodeNumber()).getLocation().y);
                if (CallgraphView.this.play != null) {
                    CallgraphView.this.play.setEnabled(true);
                }
            }
        };
        ImageDescriptor treeImage = CallgraphView.getImageDescriptor("icons/tree_view.gif");
        this.viewTreeview.setImageDescriptor(treeImage);
        this.viewRadialview = new Action(Messages.getString("CallgraphView.RadialView")){

            public void run() {
                CallgraphView.this.g.draw(1, CallgraphView.this.g.getAnimationMode(), CallgraphView.this.g.getRootVisibleNodeNumber());
                if (CallgraphView.this.play != null) {
                    CallgraphView.this.play.setEnabled(true);
                }
            }
        };
        ImageDescriptor d = CallgraphView.getImageDescriptor("/icons/radial_view.gif");
        this.viewRadialview.setImageDescriptor(d);
        this.viewAggregateview = new Action(Messages.getString("CallgraphView.AggregateView")){

            public void run() {
                CallgraphView.this.g.draw(3, CallgraphView.this.g.getAnimationMode(), CallgraphView.this.g.getRootVisibleNodeNumber());
                if (CallgraphView.this.play != null) {
                    CallgraphView.this.play.setEnabled(false);
                }
            }
        };
        ImageDescriptor aggregateImage = CallgraphView.getImageDescriptor("/icons/view_aggregateview.gif");
        this.viewAggregateview.setImageDescriptor(aggregateImage);
        this.viewLevelview = new Action(Messages.getString("CallgraphView.LevelView")){

            public void run() {
                CallgraphView.this.g.draw(0, CallgraphView.this.g.getAnimationMode(), CallgraphView.this.g.getRootVisibleNodeNumber());
                if (CallgraphView.this.play != null) {
                    CallgraphView.this.play.setEnabled(true);
                }
            }
        };
        ImageDescriptor levelImage = CallgraphView.getImageDescriptor("/icons/showchild_mode.gif");
        this.viewLevelview.setImageDescriptor(levelImage);
        this.setViewRefresh(new Action(Messages.getString("CallgraphView.Reset")){

            public void run() {
                CallgraphView.this.g.reset();
            }
        });
        ImageDescriptor refreshImage = CallgraphView.getImageDescriptor("/icons/nav_refresh.gif");
        this.getViewRefresh().setImageDescriptor(refreshImage);
    }

    public void stapPermissionError() {
        Process p = null;
        try {
            p = new ProcessBuilder("/usr/bin/bash", "-c", "whoami").start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStreamReader isr = new InputStreamReader(p.getInputStream());
        BufferedReader br = new BufferedReader(isr);
        String user = null;
        try {
            user = br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SystemTapUIErrorMessages message = new SystemTapUIErrorMessages(Messages.getString("CallgraphView.StapError1"), Messages.getString("CallgraphView.StapError1"), NLS.bind((String)Messages.getString("CallgraphView.StapError2"), (Object)user));
        message.schedule();
    }

    public void createAnimateActions() {
        this.animationSlow = new Action(Messages.getString("CallgraphView.AnimationSlow"), 8){

            public void run() {
                CallgraphView.this.g.setAnimationMode(1);
                this.setChecked(true);
                CallgraphView.this.animationSlow.setChecked(true);
                CallgraphView.this.animationFast.setChecked(false);
            }
        };
        this.animationSlow.setChecked(true);
        this.animationFast = new Action(Messages.getString("CallgraphView.AnimationFast"), 8){

            public void run() {
                CallgraphView.this.g.setAnimationMode(3);
                CallgraphView.this.animationSlow.setChecked(false);
                CallgraphView.this.animationFast.setChecked(true);
            }
        };
        this.modeCollapsedNodes = new Action(Messages.getString("CallgraphView.CollapsedMode"), 2){

            public void run() {
                if (CallgraphView.this.g.isCollapseMode()) {
                    CallgraphView.this.g.setCollapseMode(false);
                    CallgraphView.this.g.draw(CallgraphView.this.g.getRootVisibleNodeNumber());
                } else {
                    CallgraphView.this.g.setCollapseMode(true);
                    CallgraphView.this.g.draw(CallgraphView.this.g.getRootVisibleNodeNumber());
                }
            }
        };
        ImageDescriptor newImage = CallgraphView.getImageDescriptor("icons/mode_collapsednodes.gif");
        this.modeCollapsedNodes.setImageDescriptor(newImage);
        this.limits = new Action(Messages.getString("CallgraphView.SetLimits"), 1){
            private Spinner limit;
            private Spinner buffer;
            private Shell sh;

            public void run() {
                this.sh = new Shell();
                this.sh.setLayout((Layout)new GridLayout());
                this.sh.setSize(150, 200);
                Label limitLabel = new Label((Composite)this.sh, 0);
                limitLabel.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                limitLabel.setText(Messages.getString("CallgraphView.MaxNodes"));
                this.limit = new Spinner((Composite)this.sh, 2048);
                this.limit.setMaximum(5000);
                this.limit.setSelection(CallgraphView.this.g.getMaxNodes());
                this.limit.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                Label bufferLabel = new Label((Composite)this.sh, 0);
                bufferLabel.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                bufferLabel.setText(Messages.getString("CallgraphView.MaxDepth"));
                this.buffer = new Spinner((Composite)this.sh, 2048);
                this.buffer.setMaximum(5000);
                this.buffer.setSelection(CallgraphView.this.g.getLevelBuffer());
                this.buffer.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                Button setLimit = new Button((Composite)this.sh, 8);
                setLimit.setText(Messages.getString("CallgraphView.SetValues"));
                setLimit.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                setLimit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean redraw = false;
                        if (limit.getSelection() >= 0 && buffer.getSelection() >= 0) {
                            CallgraphView.this.g.setMaxNodes(limit.getSelection());
                            CallgraphView.this.g.setLevelBuffer(buffer.getSelection());
                            if (CallgraphView.this.g.changeLevelLimits(CallgraphView.this.g.getLevelOfNode(CallgraphView.this.g.getRootVisibleNodeNumber()))) {
                                SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("CallgraphView.BufferTooHigh"), Messages.getString("CallgraphView.BufferTooHigh"), String.valueOf(Messages.getString("CallgraphView.BufferMessage1")) + Messages.getString("CallgraphView.BufferMessage2") + Messages.getString("CallgraphView.BufferMessage3") + Messages.getString("CallgraphView.BufferMessage4") + CallgraphView.this.g.getLevelBuffer() + Messages.getString("CallgraphView.BufferMessage5") + "\n" + "\n" + Messages.getString("CallgraphView.BufferMessage6") + Messages.getString("CallgraphView.BufferMessage7"));
                                mess.schedule();
                            }
                            redraw = true;
                        }
                        sh.dispose();
                        if (redraw) {
                            CallgraphView.this.g.draw();
                        }
                    }
                });
                this.sh.open();
            }
        };
    }

    public void createActions() {
        this.createViewActions();
        this.createAnimateActions();
        this.createMarkerActions();
        this.createMovementActions();
        this.modeCollapsedNodes.setChecked(true);
    }

    public void createMovementActions() {
        this.gotoNext = new Action(Messages.getString("CallgraphView.Next")){

            public void run() {
                CallgraphView.this.g.drawNextNode();
            }
        };
        this.gotoPrevious = new Action(Messages.getString("CallgraphView.Previous")){

            public void run() {
                int toDraw;
                if (CallgraphView.this.g.isCollapseMode()) {
                    CallgraphView.this.g.setCollapseMode(false);
                }
                if ((toDraw = CallgraphView.this.g.getPreviousCalledNode(CallgraphView.this.g.getRootVisibleNodeNumber())) != -1) {
                    CallgraphView.this.g.draw(toDraw);
                }
            }
        };
        this.gotoLast = new Action(Messages.getString("CallgraphView.Last")){

            public void run() {
                if (CallgraphView.this.g.isCollapseMode()) {
                    CallgraphView.this.g.setCollapseMode(false);
                }
                CallgraphView.this.g.draw(CallgraphView.this.g.getLastFunctionCalled());
            }
        };
        this.play = new Action(Messages.getString("CallgraphView.Play")){

            public void run() {
                if (CallgraphView.this.g.getDrawMode() != 3) {
                    CallgraphView.this.g.play();
                    CallgraphView.this.togglePlayImage();
                }
            }
        };
        this.play.setImageDescriptor(this.playImage);
    }

    protected void togglePlayImage() {
        if (this.play.getToolTipText() == Messages.getString("CallgraphView.Pause")) {
            this.play.setImageDescriptor(this.playImage);
            this.play.setToolTipText(Messages.getString("CallgraphView.Play"));
        } else {
            this.play.setImageDescriptor(this.pauseImage);
            this.play.setToolTipText("");
        }
    }

    public void createMarkerActions() {
        this.markersNext = new Action(Messages.getString("CallgraphView.nextMarker")){

            public void run() {
                CallgraphView.this.g.draw(CallgraphView.this.g.getNextMarkedNode());
            }
        };
        this.markersPrevious = new Action(Messages.getString("CallgraphView.previousMarker")){

            public void run() {
                CallgraphView.this.g.draw(CallgraphView.this.g.getPreviousMarkedNode());
            }
        };
    }

    protected boolean createOpenAction() {
        this.openFile = new Action(Messages.getString("CallgraphView.Open")){

            public void run() {
                FileDialog dialog = new FileDialog(new Shell(), -1);
                String filePath = dialog.open();
                if (filePath != null) {
                    StapGraphParser new_parser = new StapGraphParser();
                    new_parser.setSourcePath(filePath);
                    new_parser.setViewID("org.eclipse.linuxtools.callgraph.callgraphview");
                    new_parser.schedule();
                }
            }
        };
        return true;
    }

    protected boolean createOpenDefaultAction() {
        this.openDefault = new Action(Messages.getString("CallgraphView.OpenLastRun")){

            public void run() {
                StapGraphParser new_parser = new StapGraphParser();
                new_parser.setViewID("org.eclipse.linuxtools.callgraph.callgraphview");
                new_parser.schedule();
            }
        };
        return true;
    }

    public boolean setParser(SystemTapParser newParser) {
        if (newParser instanceof StapGraphParser) {
            this.parser = (StapGraphParser)newParser;
            return true;
        }
        return false;
    }

    public void setViewID() {
        this.viewID = "org.eclipse.linuxtools.callgraph.callgraphview";
    }

    public Action getAnimationSlow() {
        return this.animationSlow;
    }

    public void setAnimation_slow(Action animationSlow) {
        this.animationSlow = animationSlow;
    }

    public Action getAnimationFast() {
        return this.animationFast;
    }

    public void setAnimation_fast(Action animationFast) {
        this.animationFast = animationFast;
    }

    public IMenuManager getAnimation() {
        return this.animation;
    }

    public Action getModeCollapsednodes() {
        return this.modeCollapsedNodes;
    }

    public void setViewRefresh(Action viewRefresh) {
        this.viewRefresh = viewRefresh;
    }

    public Action getViewRefresh() {
        return this.viewRefresh;
    }

    public Action getGotoNext() {
        return this.gotoNext;
    }

    public Action getGotoPrevious() {
        return this.gotoPrevious;
    }

    public Action getGotoLast() {
        return this.gotoLast;
    }

    public Action getViewTreeview() {
        return this.viewTreeview;
    }

    public Action getViewRadialview() {
        return this.viewRadialview;
    }

    public Action getViewAggregateview() {
        return this.viewAggregateview;
    }

    public Action getViewLevelview() {
        return this.viewLevelview;
    }

    public Action getPlay() {
        return this.play;
    }

    public StapGraph getGraph() {
        return this.g;
    }

    public void setFocus() {
        if (this.masterComposite != null) {
            this.masterComposite.setFocus();
        }
    }

    public void updateMethod() {
        NullProgressMonitor m = new NullProgressMonitor();
        m.beginTask("Updating callgraph", 4);
        this.loadData((IProgressMonitor)m);
        m.worked(1);
        if (this.parser.totalTime > 0L) {
            this.finishLoad((IProgressMonitor)m);
        }
        m.worked(1);
        this.g.draw(1, 1, this.g.getFirstUsefulNode());
    }

    public SystemTapParser getParser() {
        return this.parser;
    }

    private void writeToDot(boolean mode, Set<Integer> keySet) {
        Shell sh = new Shell();
        FileDialog dialog = new FileDialog(sh, 8192);
        String filePath = dialog.open();
        if (filePath != null) {
            File f = new File(filePath);
            f.delete();
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                return;
            }
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(f));
                StringBuilder build = new StringBuilder("");
                out.write("digraph stapgraph {\n");
                for (int i : keySet) {
                    if (i == 0) continue;
                    StapData d = this.g.getNodeData(i);
                    if (d.isCollapsed != mode && !d.isOnlyChildWithThisName()) continue;
                    build.append(String.valueOf(i) + " [label=\"" + d.name + " ");
                    build.append(String.valueOf(StapNode.numberFormat.format((float)d.getTime() / (float)this.g.getTotalTime() * 100.0f)) + "%\"]\n");
                    int j = d.parent;
                    if (mode) {
                        j = d.collapsedParent;
                    }
                    if (!keySet.contains(j) || j == 0) continue;
                    String called = mode ? " [label=\"" + this.g.getNodeData((int)i).timesCalled + "\"]\n" : "\n";
                    build.append(String.valueOf(j) + "->" + i);
                    build.append(called);
                    out.write(build.toString());
                    build.setLength(0);
                }
                out.write("}");
                out.flush();
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.callgraph", (String)path);
    }
}

