/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenTraceHandler
extends AbstractHandler {
    private TmfTraceElement fTrace = null;

    public boolean isEnabled() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fTrace = null;
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfTraceElement) {
            this.fTrace = (TmfTraceElement)element;
        }
        return this.fTrace != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        if (this.fTrace == null) {
            return null;
        }
        final TmfTraceElement traceElement = this.fTrace.getElementUnderTraceFolder();
        Thread thread = new Thread(){

            @Override
            public void run() {
                IFile file;
                final ITmfTrace trace = traceElement.instantiateTrace();
                ITmfEvent traceEvent = traceElement.instantiateEvent();
                if (trace == null || traceEvent == null) {
                    OpenTraceHandler.displayErrorMsg(Messages.OpenTraceHandler_NoTraceType);
                    if (trace != null) {
                        trace.dispose();
                    }
                    return;
                }
                String traceEditorId = traceElement.getEditorId();
                final String editorId = traceEditorId != null ? traceEditorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                try {
                    trace.initTrace(traceElement.getResource(), traceElement.getLocation().getPath(), traceEvent.getClass());
                }
                catch (TmfTraceException e) {
                    OpenTraceHandler.displayErrorMsg(String.valueOf(Messages.OpenTraceHandler_InitError) + "\n\n" + (Object)((Object)e));
                    trace.dispose();
                    return;
                }
                try {
                    file = traceElement.createBookmarksFile();
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error opening trace " + traceElement.getName(), e);
                    OpenTraceHandler.displayErrorMsg(String.valueOf(Messages.OpenTraceHandler_Error) + "\n\n" + e.getMessage());
                    trace.dispose();
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TmfEditorInput editorInput = new TmfEditorInput(file, trace);
                            IWorkbench wb = PlatformUI.getWorkbench();
                            IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                            IEditorPart editor = activePage.findEditor((IEditorInput)new FileEditorInput(file));
                            if (editor != null && editor instanceof IReusableEditor) {
                                activePage.reuseEditor((IReusableEditor)editor, (IEditorInput)editorInput);
                                activePage.activate((IWorkbenchPart)editor);
                            } else {
                                activePage.openEditor((IEditorInput)editorInput, editorId);
                                IDE.setDefaultEditor((IFile)file, (String)editorId);
                            }
                        }
                        catch (PartInitException e) {
                            OpenTraceHandler.displayErrorMsg(String.valueOf(Messages.OpenTraceHandler_Error) + "\n\n" + e.getMessage());
                            Activator.getDefault().logError("Error opening trace " + traceElement.getName(), e);
                            trace.dispose();
                        }
                    }
                });
            }
        };
        thread.start();
        return null;
    }

    private static void displayErrorMsg(final String errorMsg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                mb.setText(Messages.OpenTraceHandler_Title);
                mb.setMessage(errorMsg);
                mb.open();
            }
        });
    }
}

