/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceValidationHelper;
import org.eclipse.ui.dialogs.FileSystemElement;

public final class TmfTraceType {
    private static final char SEPARATOR = ':';
    public static final String TMF_TRACE_TYPE_ID = "org.eclipse.linuxtools.tmf.ui.tracetype";
    public static final String CATEGORY_ELEM = "category";
    public static final String TYPE_ELEM = "type";
    public static final String DEFAULT_EDITOR_ELEM = "defaultEditor";
    public static final String EVENTS_TABLE_TYPE_ELEM = "eventsTableType";
    public static final String STATISTICS_VIEWER_ELEM = "statisticsViewerType";
    public static final String ID_ATTR = "id";
    public static final String NAME_ATTR = "name";
    public static final String CATEGORY_ATTR = "category";
    public static final String TRACE_TYPE_ATTR = "trace_type";
    public static final String EVENT_TYPE_ATTR = "event_type";
    public static final String ICON_ATTR = "icon";
    public static final String CLASS_ATTR = "class";
    public static final String CUSTOM_TXT_CATEGORY = "Custom Text";
    public static final String CUSTOM_XML_CATEGORY = "Custom XML";
    private final Map<String, IConfigurationElement> fTraceTypeAttributes = new HashMap<String, IConfigurationElement>();
    private final Map<String, IConfigurationElement> fTraceCategories = new HashMap<String, IConfigurationElement>();
    private final Map<String, TraceTypeHelper> fTraceTypes = new LinkedHashMap<String, TraceTypeHelper>();
    private static TmfTraceType fInstance = null;

    public static String getCategoryName(String categoryId) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("category") && categoryId.equals(element.getAttribute(ID_ATTR))) {
                return element.getAttribute(NAME_ATTR);
            }
            ++n2;
        }
        return "";
    }

    public static Object getTraceTypeElement(IResource resource, String element) {
        block5: {
            try {
                if (resource == null) break block5;
                String traceType = resource.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                IConfigurationElement[] iConfigurationElementArray = TmfTraceType.getTypeElements();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ce = iConfigurationElementArray[n2];
                    if (ce.getAttribute(ID_ATTR).equals(traceType)) {
                        IConfigurationElement[] viewerCE = ce.getChildren(element);
                        if (viewerCE.length == 1) {
                            return viewerCE[0].createExecutableExtension(CLASS_ATTR);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error creating the element from the resource", e);
            }
        }
        return null;
    }

    public static IConfigurationElement[] getTypeElements() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
        LinkedList<IConfigurationElement> typeElements = new LinkedList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(TYPE_ELEM)) {
                typeElements.add(element);
            }
            ++n2;
        }
        return typeElements.toArray(new IConfigurationElement[typeElements.size()]);
    }

    private TmfTraceType() {
        this.init();
    }

    public static TmfTraceType getInstance() {
        if (fInstance == null) {
            fInstance = new TmfTraceType();
        }
        return fInstance;
    }

    public String[] getAvailableTraceTypes() {
        ArrayList<String> traceTypes = new ArrayList<String>();
        List<String> customTypes = this.getCustomTraceTypes();
        for (String key : this.fTraceTypes.keySet()) {
            TraceTypeHelper tt = this.fTraceTypes.get(key);
            traceTypes.add(String.valueOf(tt.getCategoryName()) + ':' + tt.getName());
        }
        traceTypes.addAll(customTypes);
        return traceTypes.toArray(new String[traceTypes.size()]);
    }

    public static List<String> getCustomTraceTypes(String type) {
        String traceTypeName;
        CustomTraceDefinition def;
        int n;
        int n2;
        CustomTraceDefinition[] customTraceDefinitionArray;
        ArrayList<String> traceTypes = new ArrayList<String>();
        if (type.equals(CUSTOM_TXT_CATEGORY)) {
            customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
            n2 = customTraceDefinitionArray.length;
            n = 0;
            while (n < n2) {
                def = customTraceDefinitionArray[n];
                traceTypeName = ((CustomTxtTraceDefinition)def).definitionName;
                traceTypes.add(traceTypeName);
                ++n;
            }
        }
        if (type.equals(CUSTOM_XML_CATEGORY)) {
            customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
            n2 = customTraceDefinitionArray.length;
            n = 0;
            while (n < n2) {
                def = customTraceDefinitionArray[n];
                traceTypeName = ((CustomXmlTraceDefinition)def).definitionName;
                traceTypes.add(traceTypeName);
                ++n;
            }
        }
        return traceTypes;
    }

    public List<String> getCustomTraceTypes() {
        TraceTypeHelper tt;
        String traceTypeName;
        Object def;
        ArrayList<String> traceTypes = new ArrayList<String>();
        String[] keySet = this.fTraceTypes.keySet().toArray(new String[0]);
        Object[] objectArray = keySet;
        int n = keySet.length;
        int n2 = 0;
        while (n2 < n) {
            String key = objectArray[n2];
            if (this.fTraceTypes.get(key).getCategoryName().equals(CUSTOM_TXT_CATEGORY) || this.fTraceTypes.get(key).getCategoryName().equals(CUSTOM_XML_CATEGORY)) {
                this.fTraceTypes.remove(key);
            }
            ++n2;
        }
        objectArray = CustomTxtTraceDefinition.loadAll();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            def = objectArray[n2];
            traceTypeName = "Custom Text:" + ((CustomTxtTraceDefinition)def).definitionName;
            tt = new TraceTypeHelper(traceTypeName, CUSTOM_TXT_CATEGORY, ((CustomTxtTraceDefinition)def).definitionName, null);
            this.fTraceTypes.put(traceTypeName, tt);
            traceTypes.add(traceTypeName);
            ++n2;
        }
        objectArray = CustomXmlTraceDefinition.loadAll();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            def = objectArray[n2];
            traceTypeName = "Custom XML:" + ((CustomXmlTraceDefinition)def).definitionName;
            tt = new TraceTypeHelper(traceTypeName, CUSTOM_XML_CATEGORY, ((CustomXmlTraceDefinition)def).definitionName, null);
            this.fTraceTypes.put(traceTypeName, tt);
            traceTypes.add(traceTypeName);
            ++n2;
        }
        return traceTypes;
    }

    public TraceTypeHelper getTraceType(String id) {
        return this.fTraceTypes.get(id);
    }

    private void populateCategoriesAndTraceTypes() {
        if (this.fTraceTypes.isEmpty()) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String elementName = ce.getName();
                if (elementName.equals(TYPE_ELEM)) {
                    String traceTypeId = ce.getAttribute(ID_ATTR);
                    this.fTraceTypeAttributes.put(traceTypeId, ce);
                } else if (elementName.equals("category")) {
                    String categoryId = ce.getAttribute(ID_ATTR);
                    this.fTraceCategories.put(categoryId, ce);
                }
                ++n2;
            }
            for (String typeId : this.fTraceTypeAttributes.keySet()) {
                IConfigurationElement ce = this.fTraceTypeAttributes.get(typeId);
                String category = this.getCategory(ce);
                String attribute = ce.getAttribute(NAME_ATTR);
                ITmfTrace trace = null;
                try {
                    trace = (ITmfTrace)ce.createExecutableExtension(TRACE_TYPE_ATTR);
                }
                catch (CoreException coreException) {}
                TraceTypeHelper tt = new TraceTypeHelper(typeId, category, attribute, trace);
                this.fTraceTypes.put(typeId, tt);
            }
        }
    }

    private String getCategory(IConfigurationElement ce) {
        IConfigurationElement category;
        String categoryId = ce.getAttribute("category");
        if (categoryId != null && (category = this.fTraceCategories.get(categoryId)) != null && !category.getName().equals("")) {
            return category.getAttribute(NAME_ATTR);
        }
        return "[no category]";
    }

    public List<String> getTraceCategories() {
        ArrayList<String> categoryNames = new ArrayList<String>();
        for (String key : this.fTraceTypes.keySet()) {
            String categoryName = this.fTraceTypes.get(key).getCategoryName();
            if (categoryNames.contains(categoryName)) continue;
            categoryNames.add(categoryName);
        }
        return categoryNames;
    }

    public List<TraceTypeHelper> getTraceTypes(String category) {
        this.init();
        ArrayList<TraceTypeHelper> traceNames = new ArrayList<TraceTypeHelper>();
        for (String key : this.fTraceTypes.keySet()) {
            String categoryName = this.fTraceTypes.get(key).getCategoryName();
            if (!categoryName.equals(category)) continue;
            traceNames.add(this.fTraceTypes.get(key));
        }
        return traceNames;
    }

    private void init() {
        this.populateCategoriesAndTraceTypes();
        this.getCustomTraceTypes();
    }

    private static List<File> isolateTraces(List<FileSystemElement> selectedResources) {
        ArrayList<File> traces = new ArrayList<File>();
        Iterator<FileSystemElement> resources = selectedResources.iterator();
        HashMap<String, File> fileSystemObjects = new HashMap<String, File>();
        while (resources.hasNext()) {
            File resource = (File)resources.next().getFileSystemObject();
            String key = resource.getAbsolutePath();
            fileSystemObjects.put(key, resource);
        }
        ArrayList files = new ArrayList(fileSystemObjects.keySet());
        Collections.sort(files);
        String prefix = null;
        int i = 0;
        while (i < files.size()) {
            File file = (File)fileSystemObjects.get(files.get(i));
            String name = file.getAbsolutePath();
            if (prefix == null || !name.startsWith(prefix)) {
                prefix = name;
                traces.add(file);
            }
            ++i;
        }
        return traces;
    }

    public boolean validate(String traceTypeName, String fileName) {
        return traceTypeName == null || "".equals(traceTypeName) || traceTypeName.startsWith(CUSTOM_TXT_CATEGORY) || traceTypeName.startsWith(CUSTOM_XML_CATEGORY) || this.fTraceTypes.get(traceTypeName).validate(fileName);
    }

    public boolean validate(TraceValidationHelper traceToValidate) {
        return this.validate(traceToValidate.getTraceType(), traceToValidate.getTraceToScan());
    }

    public boolean validateTrace(String traceTypeName, List<FileSystemElement> selectedResources) {
        List<File> traces = TmfTraceType.isolateTraces(selectedResources);
        return this.validateTraceFiles(traceTypeName, traces);
    }

    public boolean validateTraceFiles(String traceTypeName, List<File> traces) {
        if (!(traceTypeName == null || "".equals(traceTypeName) || traceTypeName.startsWith(CUSTOM_TXT_CATEGORY) || traceTypeName.startsWith(CUSTOM_XML_CATEGORY))) {
            for (File trace : traces) {
                if (this.validate(traceTypeName, trace.getAbsolutePath())) continue;
                return false;
            }
        }
        return true;
    }

    public IConfigurationElement getTraceAttributes(String traceType) {
        return this.fTraceTypeAttributes.get(traceType);
    }

    public String getTraceTypeId(String category, String traceType) {
        for (String key : this.fTraceTypes.keySet()) {
            if (!this.fTraceTypes.get(key).getCategoryName().equals(category.trim()) || !this.fTraceTypes.get(key).getName().equals(traceType.trim())) continue;
            return key;
        }
        return null;
    }
}

