/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.FloatDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;
import org.eclipse.linuxtools.internal.tmf.core.Messages;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFEnumField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFFloatField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFIntegerArrayField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFIntegerField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFStringField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFStructField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFVariantField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfEnumPair;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;

public abstract class CtfTmfEventField
extends TmfEventField {
    protected CtfTmfEventField(String name, Object value, ITmfEventField[] fields) {
        super(name.startsWith("_") ? name.substring(1) : name, value, fields);
    }

    public static CtfTmfEventField parseField(Definition fieldDef, String fieldName) {
        CtfTmfEventField field = null;
        if (fieldDef instanceof IntegerDefinition) {
            IntegerDefinition intDef = (IntegerDefinition)fieldDef;
            int base = intDef.getDeclaration().getBase();
            field = new CTFIntegerField(fieldName, intDef.getValue(), base, intDef.getDeclaration().isSigned());
        } else if (fieldDef instanceof EnumDefinition) {
            EnumDefinition enumDef = (EnumDefinition)fieldDef;
            field = new CTFEnumField(fieldName, new CtfEnumPair(enumDef.getValue(), enumDef.getIntegerValue()));
        } else if (fieldDef instanceof StringDefinition) {
            field = new CTFStringField(fieldName, ((StringDefinition)fieldDef).getValue());
        } else if (fieldDef instanceof FloatDefinition) {
            FloatDefinition floatDef = (FloatDefinition)fieldDef;
            field = new CTFFloatField(fieldName, floatDef.getValue());
        } else if (fieldDef instanceof ArrayDefinition) {
            ArrayDefinition arrayDef = (ArrayDefinition)fieldDef;
            ArrayDeclaration arrayDecl = arrayDef.getDeclaration();
            if (arrayDef.isString()) {
                field = new CTFStringField(fieldName, fieldDef.toString());
            } else if (arrayDecl.getElementType() instanceof IntegerDeclaration) {
                ArrayList<Long> values = new ArrayList<Long>(arrayDecl.getLength());
                int i = 0;
                while (i < arrayDecl.getLength()) {
                    values.add(((IntegerDefinition)arrayDef.getElem(i)).getValue());
                    ++i;
                }
                field = new CTFIntegerArrayField(fieldName, values, ((IntegerDeclaration)arrayDecl.getElementType()).getBase(), ((IntegerDeclaration)arrayDecl.getElementType()).isSigned());
            }
        } else if (fieldDef instanceof SequenceDefinition) {
            SequenceDefinition seqDef = (SequenceDefinition)fieldDef;
            SequenceDeclaration seqDecl = seqDef.getDeclaration();
            if (seqDef.getLength() == 0) {
                field = new CTFStringField(fieldName, "");
            } else if (seqDef.isString()) {
                field = new CTFStringField(fieldName, seqDef.toString());
            } else if (seqDecl.getElementType() instanceof IntegerDeclaration) {
                ArrayList<Long> values = new ArrayList<Long>(seqDef.getLength());
                int i = 0;
                while (i < seqDef.getLength()) {
                    values.add(((IntegerDefinition)seqDef.getElem(i)).getValue());
                    ++i;
                }
                field = new CTFIntegerArrayField(fieldName, values, ((IntegerDeclaration)seqDecl.getElementType()).getBase(), ((IntegerDeclaration)seqDecl.getElementType()).isSigned());
            }
        } else if (fieldDef instanceof StructDefinition) {
            StructDefinition strDef = (StructDefinition)fieldDef;
            String curFieldName = null;
            ArrayList<CtfTmfEventField> list = new ArrayList<CtfTmfEventField>();
            for (Map.Entry entry : strDef.getDefinitions().entrySet()) {
                curFieldName = (String)entry.getKey();
                Definition curFieldDef = (Definition)entry.getValue();
                CtfTmfEventField curField = CtfTmfEventField.parseField(curFieldDef, curFieldName);
                list.add(curField);
            }
            field = new CTFStructField(fieldName, list.toArray(new CtfTmfEventField[list.size()]));
        } else if (fieldDef instanceof VariantDefinition) {
            VariantDefinition varDef = (VariantDefinition)fieldDef;
            String curFieldName = varDef.getCurrentFieldName();
            Definition curFieldDef = (Definition)varDef.getDefinitions().get(curFieldName);
            if (curFieldDef != null) {
                CtfTmfEventField subField = CtfTmfEventField.parseField(curFieldDef, curFieldName);
                field = new CTFVariantField(fieldName, subField);
            } else {
                field = new CTFStringField(curFieldName, "");
            }
        } else {
            field = new CTFStringField(fieldName, String.valueOf(Messages.TmfEventField_UnsupportedType) + fieldDef.getClass().toString());
        }
        return field;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + '=' + this.getFormattedValue();
    }

    public static final String formatNumber(long value, int base, boolean signed) {
        String s;
        switch (base) {
            case 2: {
                s = "0b" + Long.toBinaryString(value);
                break;
            }
            case 8: {
                s = "0" + Long.toOctalString(value);
                break;
            }
            case 16: {
                s = "0x" + Long.toHexString(value);
                break;
            }
            default: {
                if (!signed && value < 0L) {
                    BigInteger bigInteger = BigInteger.valueOf(value);
                    BigInteger powerOfTwo = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(1L));
                    powerOfTwo = powerOfTwo.multiply(BigInteger.valueOf(2L));
                    bigInteger = bigInteger.add(powerOfTwo);
                    s = bigInteger.toString();
                    break;
                }
                s = Long.toString(value);
            }
        }
        return s;
    }
}

