/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.AbstractDataAdapter;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.info.InfoAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelDataAdapter
extends AbstractDataAdapter {
    public static final String ID = "id";
    public static final String IDREF = "idref";
    public static final String NAME = "name";
    public static final String COUNT = "count";
    public static final String SAMPLE = "sample";
    public static final String LINE = "line";
    public static final String SYMBOL_DATA = "symboldata";
    public static final String SYMBOL_DETAILS = "symboldetails";
    public static final String SYMBOL = "symbol";
    public static final String FILE = "file";
    public static final String SETUP = "setup";
    public static final String EVENT_SETUP = "eventsetup";
    public static final String TIMER_SETUP = "timersetup";
    public static final String SETUP_COUNT = "setupcount";
    public static final String EVENT_NAME = "eventname";
    public static final String RTC_INTERRUPTS = "rtcinterrupts";
    public static final String PROFILE = "profile";
    public static final String MODEL_DATA = "model-data";
    public static final String MODULE = "module";
    public static final String DEPENDENT = "dependent";
    public static final String BINARY = "binary";
    public static final String IMAGE = "image";
    public static final String SYMBOLS = "symbols";
    public static final String SYMBOL_TABLE = "symboltable";
    public static final String DETAIL_TABLE = "detailtable";
    public static final String DETAIL_DATA = "detaildata";
    private boolean isParseable = true;
    private Document newDoc;
    private Element oldRoot;
    private Element newRoot;
    public static final Comparator<Element> SAMPLE_COUNT_ORDER = new Comparator<Element>(){

        @Override
        public int compare(Element a, Element b) {
            Element a_countTag = (Element)a.getElementsByTagName(ModelDataAdapter.COUNT).item(0);
            Element b_countTag = (Element)b.getElementsByTagName(ModelDataAdapter.COUNT).item(0);
            Element a_LineTag = (Element)a.getElementsByTagName(ModelDataAdapter.LINE).item(0);
            Element b_LineTag = (Element)b.getElementsByTagName(ModelDataAdapter.LINE).item(0);
            Integer a_count = Integer.parseInt(a_countTag.getTextContent().trim());
            Integer b_count = Integer.parseInt(b_countTag.getTextContent().trim());
            Integer a_line = Integer.parseInt(a_LineTag.getTextContent().trim());
            Integer b_line = Integer.parseInt(b_LineTag.getTextContent().trim());
            if (a_count.compareTo(b_count) == 0) {
                return a_line.compareTo(b_line);
            }
            return -a_count.compareTo(b_count);
        }
    };

    public ModelDataAdapter(InputStream is) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            try {
                Element elem;
                Document oldDoc = builder.parse(is);
                this.oldRoot = elem = (Element)oldDoc.getElementsByTagName(PROFILE).item(0);
                this.newDoc = builder.newDocument();
                this.newRoot = this.newDoc.createElement(MODEL_DATA);
                this.newDoc.appendChild(this.newRoot);
            }
            catch (IOException iOException) {
                this.isParseable = false;
            }
            catch (SAXException sAXException) {
                this.isParseable = false;
            }
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void process() {
        this.createXML();
    }

    private void createXML() {
        Element oldImage = (Element)this.oldRoot.getElementsByTagName(BINARY).item(0);
        Element newImage = this.newDoc.createElement(IMAGE);
        String binName = oldImage.getAttribute(NAME);
        newImage.setAttribute(NAME, binName);
        Element countTag = (Element)oldImage.getElementsByTagName(COUNT).item(0);
        String imageCount = countTag.getTextContent().trim();
        newImage.setAttribute(COUNT, imageCount);
        if (!InfoAdapter.hasTimerSupport()) {
            Element setupTag = (Element)this.oldRoot.getElementsByTagName(SETUP).item(0);
            Element eventSetupTag = (Element)setupTag.getElementsByTagName(EVENT_SETUP).item(0);
            String setupcount = eventSetupTag.getAttribute(SETUP_COUNT);
            newImage.setAttribute(SETUP_COUNT, setupcount);
        }
        Element oldSymbolTableTag = (Element)this.oldRoot.getElementsByTagName(SYMBOL_TABLE).item(0);
        NodeList oldSymbolDataList = oldSymbolTableTag.getElementsByTagName(SYMBOL_DATA);
        Element oldDetailTableTag = (Element)this.oldRoot.getElementsByTagName(DETAIL_TABLE).item(0);
        NodeList oldDetailTableList = oldDetailTableTag.getElementsByTagName(SYMBOL_DETAILS);
        HashMap<String, HashMap<String, String>> oldSymbolDataListMap = this.parseDataList(oldSymbolDataList);
        HashMap<String, NodeList> oldDetailTableListMap = this.parseDetailTable(oldDetailTableList);
        ArrayList<Element> oldImageList = new ArrayList<Element>();
        oldImageList.add(oldImage);
        NodeList oldModuleList = oldImage.getElementsByTagName(MODULE);
        Element dependentTag = this.newDoc.createElement(DEPENDENT);
        if (oldModuleList.getLength() > 0) {
            dependentTag.setAttribute(COUNT, "0");
            int t = 0;
            while (t < oldModuleList.getLength()) {
                oldImageList.add((Element)oldModuleList.item(t));
                ++t;
            }
        }
        for (Element oldImg : oldImageList) {
            Element newImg;
            if (oldImg.getTagName().equals(BINARY)) {
                newImg = newImage;
            } else {
                newImg = this.newDoc.createElement(IMAGE);
                String imgName = oldImg.getAttribute(NAME);
                newImg.setAttribute(NAME, imgName);
                Element modCountTag = (Element)oldImg.getElementsByTagName(COUNT).item(0);
                String imgCount = modCountTag.getTextContent().trim();
                newImg.setAttribute(COUNT, imgCount);
            }
            Element newSymbolsTag = this.newDoc.createElement(SYMBOLS);
            NodeList oldSymbolList = oldImg.getElementsByTagName(SYMBOL);
            int i = 0;
            while (i < oldSymbolList.getLength()) {
                Element oldSymbol = (Element)oldSymbolList.item(i);
                if (oldSymbol.getParentNode().isSameNode(oldImg)) {
                    Element newSymbol = this.newDoc.createElement(SYMBOL);
                    String idref = oldSymbol.getAttribute(IDREF);
                    String symbolCount = ((Element)oldSymbol.getElementsByTagName(COUNT).item(0)).getTextContent().trim();
                    newSymbol.setAttribute(COUNT, symbolCount);
                    HashMap<String, String> symbolData = oldSymbolDataListMap.get(idref);
                    newSymbol.setAttribute(NAME, symbolData.get(NAME));
                    newSymbol.setAttribute(FILE, symbolData.get(FILE));
                    newSymbol.setAttribute(LINE, symbolData.get(LINE));
                    NodeList detailDataList = oldDetailTableListMap.get(idref);
                    HashMap<String, Element> tmp = new HashMap<String, Element>();
                    TreeSet<Element> sorted = new TreeSet<Element>(SAMPLE_COUNT_ORDER);
                    int l = 0;
                    while (l < detailDataList.getLength()) {
                        Element detailData = (Element)detailDataList.item(l);
                        String sampleFile = detailData.getAttribute(FILE);
                        String sampleLine = detailData.getAttribute(LINE);
                        if (sampleFile.equals("") && !sampleLine.equals("")) {
                            sampleFile = symbolData.get(FILE);
                        } else {
                            if (sampleFile.equals("")) {
                                sampleFile = "??";
                            }
                            if (sampleLine.equals("")) {
                                sampleLine = "0";
                            }
                        }
                        Element detailDataCount = (Element)detailData.getElementsByTagName(COUNT).item(0);
                        String count = detailDataCount.getTextContent().trim();
                        if (tmp.containsKey(sampleLine)) {
                            Element elem = (Element)((Element)tmp.get(sampleLine)).getElementsByTagName(COUNT).item(0);
                            int val = Integer.parseInt(elem.getTextContent().trim()) + Integer.parseInt(count);
                            elem.setTextContent(String.valueOf(val));
                        } else {
                            Element sampleTag = this.newDoc.createElement(SAMPLE);
                            Element fileTag = this.newDoc.createElement(FILE);
                            fileTag.setTextContent(sampleFile);
                            Element lineTag = this.newDoc.createElement(LINE);
                            lineTag.setTextContent(sampleLine);
                            Element sampleCountTag = this.newDoc.createElement(COUNT);
                            sampleCountTag.setTextContent(count);
                            sampleTag.appendChild(fileTag);
                            sampleTag.appendChild(lineTag);
                            sampleTag.appendChild(sampleCountTag);
                            tmp.put(sampleLine, sampleTag);
                        }
                        ++l;
                    }
                    for (Element elem : tmp.values()) {
                        sorted.add(elem);
                    }
                    for (Element e : sorted) {
                        newSymbol.appendChild(e);
                    }
                    newSymbolsTag.appendChild(newSymbol);
                }
                ++i;
            }
            newImg.appendChild(newSymbolsTag);
            if (oldImg.getTagName().equals(MODULE)) {
                dependentTag.appendChild(newImg);
                int currVal = Integer.parseInt(dependentTag.getAttribute(COUNT));
                int val = Integer.parseInt(newImg.getAttribute(COUNT));
                dependentTag.setAttribute(COUNT, String.valueOf(currVal + val));
                continue;
            }
            this.newRoot.appendChild(newImg);
        }
        if (oldModuleList.getLength() > 0) {
            newImage.appendChild(dependentTag);
        }
    }

    private HashMap<String, NodeList> parseDetailTable(NodeList oldDetailTableList) {
        HashMap<String, NodeList> ret = new HashMap<String, NodeList>();
        int i = 0;
        while (i < oldDetailTableList.getLength()) {
            Element symbolDetails = (Element)oldDetailTableList.item(i);
            String id = symbolDetails.getAttribute(ID);
            NodeList detailDataList = symbolDetails.getElementsByTagName(DETAIL_DATA);
            ret.put(id, detailDataList);
            ++i;
        }
        return ret;
    }

    private HashMap<String, HashMap<String, String>> parseDataList(NodeList oldSymbolDataList) {
        HashMap<String, HashMap<String, String>> ret = new HashMap<String, HashMap<String, String>>();
        int j = 0;
        while (j < oldSymbolDataList.getLength()) {
            String line;
            HashMap<String, String> tmp = new HashMap<String, String>();
            Element symbolData = (Element)oldSymbolDataList.item(j);
            String id = symbolData.getAttribute(ID);
            String name = symbolData.getAttribute(NAME);
            String file = symbolData.getAttribute(FILE);
            if (file.equals("")) {
                file = "??";
            }
            if ((line = symbolData.getAttribute(LINE)).equals("")) {
                line = "0";
            }
            tmp.put(NAME, name);
            tmp.put(FILE, file);
            tmp.put(LINE, line);
            ret.put(id, tmp);
            ++j;
        }
        return ret;
    }

    @Override
    public Document getDocument() {
        return this.newDoc;
    }

    public boolean isParseable() {
        return this.isParseable;
    }
}

