/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapView;
import org.eclipse.linuxtools.internal.callgraph.launch.CallgraphLaunchPlugin;
import org.eclipse.linuxtools.internal.callgraph.launch.ConfigurationOptionsSetter;
import org.eclipse.linuxtools.internal.callgraph.launch.LaunchStapGraph;
import org.eclipse.linuxtools.internal.callgraph.launch.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class SystemTapOptionsTab
extends CLaunchConfigurationTab {
    protected Composite top;
    protected ScrolledComposite scrollTop;
    protected Combo toolsCombo;
    protected TabFolder fileFolder;
    protected TabFolder commandFolder;
    protected TabFolder argumentsFolder;
    protected TabFolder binaryArgumentsFolder;
    protected TabFolder parserFolder;
    protected TabFolder generatedScriptFolder;
    protected Text scriptFile;
    protected Text binaryFile;
    protected Text arguments;
    protected Text generatedScript;
    protected Text outputFile;
    protected Text button_D_text;
    protected Text binaryArguments;
    protected Text parser;
    protected Text viewer;
    protected Button fileBrowseButton;
    protected Button workspaceBrowseButton;
    protected Button parserButton;
    protected Button viewerButton;
    protected Button button_k;
    protected Button button_u;
    protected Button button_w;
    protected Button button_b;
    protected Button button_g;
    protected Button button_P;
    protected Button button_t;
    protected Button button_build;
    protected Button button_F;
    protected Button button_skip_badvars;
    protected Button button_ignore_dwarf;
    protected Button button_q;
    protected Button needsBinaryButton;
    protected Button needToGenerateScriptButton;
    protected Button button_graphicsMode;
    protected Spinner button_p_Spinner;
    protected Spinner button_s_Spinner;
    protected Spinner button_x_Spinner;
    protected Spinner button_v_Spinner;
    private Button useColourButton;
    protected String workspacePath;
    protected String[] tools;
    protected boolean output_file_has_changed = false;
    protected boolean needsOverwritePermission = false;
    protected boolean overwritePermission = false;
    private boolean changeOverwrite = false;
    protected SelectionListener graphicsModeListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (SystemTapOptionsTab.this.scriptFile.isEnabled()) {
                SystemTapOptionsTab.this.scriptFile.setEnabled(false);
                SystemTapOptionsTab.this.workspaceBrowseButton.setEnabled(false);
                SystemTapOptionsTab.this.fileBrowseButton.setEnabled(false);
                SystemTapOptionsTab.this.scriptFile.setText(String.valueOf(PluginConstants.getPluginLocation()) + "parse_function.stp");
            } else {
                SystemTapOptionsTab.this.scriptFile.setEnabled(true);
                SystemTapOptionsTab.this.workspaceBrowseButton.setEnabled(true);
                SystemTapOptionsTab.this.fileBrowseButton.setEnabled(true);
            }
            SystemTapOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };
    protected SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            SystemTapOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SystemTapOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };
    protected ModifyListener modifyListenerOutput = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SystemTapOptionsTab.this.updateLaunchConfigurationDialog();
            SystemTapOptionsTab.this.output_file_has_changed = true;
        }
    };
    protected FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            if (SystemTapOptionsTab.this.output_file_has_changed) {
                SystemTapOptionsTab.this.checkOverwrite();
            }
            SystemTapOptionsTab.this.output_file_has_changed = false;
            SystemTapOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void checkOverwrite() {
        File f = new File(this.outputFile.getText());
        this.changeOverwrite = true;
        if (f.exists()) {
            this.needsOverwritePermission = true;
            Shell sh = new Shell();
            this.overwritePermission = MessageDialog.openConfirm((Shell)sh, (String)Messages.getString("SystemTapOptionsTab.ConfirmOverwriteFileTitle"), (String)Messages.getString("SystemTapOptionsTab.ConfirmOverwriteFileMessage"));
        } else {
            this.needsOverwritePermission = false;
        }
    }

    public void createControl(Composite parent) {
        this.scrollTop = new ScrolledComposite(parent, 768);
        this.scrollTop.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrollTop.setExpandVertical(true);
        this.scrollTop.setExpandHorizontal(true);
        this.setControl((Control)this.scrollTop);
        this.top = new Composite((Composite)this.scrollTop, 0);
        this.top.setLayout((Layout)new GridLayout());
        this.scrollTop.setContent((Control)this.top);
        this.fileFolder = new TabFolder(this.top, 2048);
        this.fileFolder.setLayoutData((Object)new GridData(1808));
        TabItem fileTab = new TabItem(this.fileFolder, 0);
        fileTab.setText(Messages.getString("SystemTapOptionsTab.FilesTab"));
        Composite fileTop = new Composite((Composite)this.fileFolder, 0);
        fileTop.setLayout((Layout)new GridLayout());
        fileTop.setLayoutData((Object)new GridData(1808));
        this.createFileOption(fileTop);
        fileTab.setControl((Control)fileTop);
        this.commandFolder = new TabFolder(this.top, 2048);
        this.commandFolder.setLayoutData((Object)new GridData(1808));
        TabItem commandTab = new TabItem(this.fileFolder, 0);
        commandTab.setText(Messages.getString("SystemTapOptionsTab.CommandsTab"));
        Composite commandTop = new Composite((Composite)this.fileFolder, 0);
        commandTop.setLayout((Layout)new GridLayout());
        commandTop.setLayoutData((Object)new GridData(1808));
        this.createCommandOption(commandTop);
        commandTab.setControl((Control)commandTop);
        this.argumentsFolder = new TabFolder(this.top, 2048);
        this.argumentsFolder.setLayoutData((Object)new GridData(1808));
        TabItem argumentsTab = new TabItem(this.fileFolder, 0);
        argumentsTab.setText(Messages.getString("SystemTapOptionsTab.Arguments"));
        Composite argumentsTop = new Composite((Composite)this.fileFolder, 0);
        argumentsTop.setLayout((Layout)new GridLayout());
        argumentsTop.setLayoutData((Object)new GridData(1808));
        this.createArgumentsOption(argumentsTop);
        argumentsTab.setControl((Control)argumentsTop);
        this.binaryArgumentsFolder = new TabFolder(this.top, 2048);
        this.binaryArgumentsFolder.setLayoutData((Object)new GridData(1808));
        TabItem binaryArgumentsTab = new TabItem(this.fileFolder, 0);
        binaryArgumentsTab.setText(Messages.getString("SystemTapOptionsTab.44"));
        Composite binaryArgumentsTop = new Composite((Composite)this.fileFolder, 0);
        binaryArgumentsTop.setLayout((Layout)new GridLayout());
        binaryArgumentsTop.setLayoutData((Object)new GridData(1808));
        this.createBinaryArgumentsOption(binaryArgumentsTop);
        binaryArgumentsTab.setControl((Control)binaryArgumentsTop);
        this.parserFolder = new TabFolder(this.top, 2048);
        this.parserFolder.setLayoutData((Object)new GridData(1808));
        TabItem parserTab = new TabItem(this.fileFolder, 0);
        parserTab.setText("Parser");
        Composite parserTop = new Composite((Composite)this.fileFolder, 0);
        parserTop.setLayout((Layout)new GridLayout());
        parserTop.setLayoutData((Object)new GridData(1808));
        this.createParserOption(parserTop);
        parserTab.setControl((Control)parserTop);
    }

    private void createBinaryArgumentsOption(Composite binaryArgumentsTop) {
        Composite browseTop = new Composite(binaryArgumentsTop, 0);
        browseTop.setLayout((Layout)new GridLayout(1, false));
        GridData browseData = new GridData(768);
        browseTop.setLayoutData((Object)browseData);
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText(Messages.getString("SystemTapOptionsTab.45"));
        this.binaryArguments = new Text(browseTop, 2626);
        GridData gd = new GridData(768);
        gd.heightHint = 200;
        this.binaryArguments.setLayoutData((Object)gd);
        this.binaryArguments.addModifyListener(this.modifyListener);
    }

    private void createParserOption(Composite parserTop) {
        Composite browseTop = new Composite(parserTop, 0);
        browseTop.setLayout((Layout)new GridLayout(1, false));
        GridData browseData = new GridData(768);
        browseTop.setLayoutData((Object)browseData);
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText("Parser");
        this.parser = new Text(browseTop, 2048);
        this.parser.setLayoutData((Object)new GridData(768));
        this.parser.addModifyListener(this.modifyListener);
        this.parserButton = this.createPushButton(browseTop, "Find parsers", null);
        this.parserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(SystemTapOptionsTab.this.getShell(), (ILabelProvider)new ListLabelProvider());
                dialog.setTitle("Select parser");
                dialog.setMessage("Select parser to use.");
                IExtensionRegistry reg = Platform.getExtensionRegistry();
                Object[] extensions = reg.getConfigurationElementsFor("org.eclipse.linuxtools.callgraph.core", "parser");
                dialog.setElements(extensions);
                if (dialog.open() == 0) {
                    String arg = SystemTapOptionsTab.this.getUsefulLabel(dialog.getFirstResult());
                    SystemTapOptionsTab.this.parser.setText(arg);
                }
            }
        });
        this.viewer = new Text(browseTop, 2048);
        this.viewer.setLayoutData((Object)new GridData(768));
        this.viewer.addModifyListener(this.modifyListener);
        this.viewerButton = this.createPushButton(browseTop, "Find viewers", null);
        this.viewerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(SystemTapOptionsTab.this.getShell(), (ILabelProvider)new ListLabelProvider());
                dialog.setTitle("Select viewer");
                dialog.setMessage("Select viewer to use.");
                IExtensionRegistry reg = Platform.getExtensionRegistry();
                IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.ui", "views");
                ArrayList<IConfigurationElement> ext = new ArrayList<IConfigurationElement>();
                IConfigurationElement[] iConfigurationElementArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement el = iConfigurationElementArray[n2];
                    if (el.getNamespaceIdentifier().contains("org.eclipse.linuxtools")) {
                        try {
                            if (el.createExecutableExtension("class") instanceof SystemTapView) {
                                ext.add(el);
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
                dialog.setElements(ext.toArray());
                if (dialog.open() == 0) {
                    String arg = SystemTapOptionsTab.this.getUsefulLabel(dialog.getFirstResult());
                    SystemTapOptionsTab.this.viewer.setText(arg);
                }
            }
        });
    }

    protected void createGeneratedScriptOption(Composite generatedScriptTop) {
        Composite browseTop = new Composite(generatedScriptTop, 0);
        browseTop.setLayout((Layout)new GridLayout(1, false));
        GridData browseData = new GridData(768);
        browseTop.setLayoutData((Object)browseData);
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText(Messages.getString("SystemTapOptionsTab.GeneratedScriptsTitle"));
        this.generatedScript = new Text(browseTop, 2626);
        GridData gd = new GridData(768);
        gd.heightHint = 200;
        this.generatedScript.setLayoutData((Object)gd);
        this.generatedScript.addModifyListener(this.modifyListener);
        this.needToGenerateScriptButton = new Button(browseTop, 32);
        this.needToGenerateScriptButton.setText(Messages.getString("SystemTapOptionsTab.GenerateScriptButton"));
        this.needToGenerateScriptButton.addSelectionListener(this.selectListener);
        this.needToGenerateScriptButton.setLayoutData((Object)new GridData(768));
    }

    protected void createArgumentsOption(Composite argumentsTop) {
        Composite browseTop = new Composite(argumentsTop, 0);
        browseTop.setLayout((Layout)new GridLayout(1, false));
        GridData browseData = new GridData(768);
        browseTop.setLayoutData((Object)browseData);
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText(Messages.getString("SystemTapOptionsTab.SelectArguments"));
        this.arguments = new Text(browseTop, 2626);
        GridData gd = new GridData(768);
        gd.heightHint = 200;
        this.arguments.setLayoutData((Object)gd);
        this.arguments.addModifyListener(this.modifyListener);
        Button probeFunctionButton = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.ProbeFunction"), null);
        probeFunctionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemTapOptionsTab.this.arguments.setText(String.valueOf(SystemTapOptionsTab.this.arguments.getText()) + " process(\"" + SystemTapOptionsTab.this.binaryFile.getText() + "\").function(\"\")");
            }
        });
    }

    protected void createFileOption(Composite top) {
        Composite browseTop = new Composite(top, 0);
        browseTop.setLayout((Layout)new GridLayout(4, false));
        browseTop.setLayoutData((Object)new GridData(768));
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText(Messages.getString("SystemTapOptionsTab.ScriptSelector"));
        this.scriptFile = new Text(browseTop, 2048);
        this.scriptFile.setLayoutData((Object)new GridData(768));
        this.scriptFile.addModifyListener(this.modifyListener);
        this.workspaceBrowseButton = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.WorkspaceButton"), null);
        this.workspaceBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(SystemTapOptionsTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(Messages.getString("SystemTapOptionsTab.ResourceButton"));
                dialog.setMessage(Messages.getString("SystemTapOptionsTab.SuppresionsFile"));
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                if (dialog.open() == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    String arg = resource.getFullPath().toString();
                    SystemTapOptionsTab.this.scriptFile.setText(String.valueOf(SystemTapOptionsTab.this.workspacePath) + arg);
                }
            }
        });
        this.fileBrowseButton = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.FileSystem"), null);
        this.fileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = SystemTapOptionsTab.this.scriptFile.getText();
                FileDialog dialog = new FileDialog(SystemTapOptionsTab.this.getShell(), 8192);
                filePath = dialog.open();
                if (filePath != null) {
                    SystemTapOptionsTab.this.scriptFile.setText(filePath);
                }
            }
        });
        Label binaryFileLabel = new Label(browseTop, 0);
        binaryFileLabel.setText(Messages.getString("SystemTapOptionsTab.SelectBinary"));
        this.binaryFile = new Text(browseTop, 2048);
        this.binaryFile.setLayoutData((Object)new GridData(768));
        this.binaryFile.addModifyListener(this.modifyListener);
        Button workspaceBrowseButton2 = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.WorkspaceButton2"), null);
        workspaceBrowseButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(SystemTapOptionsTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(Messages.getString("SystemTapOptionsTab.SelectResource"));
                dialog.setMessage(Messages.getString("SystemTapOptionsTab.SelectSuppressions"));
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                if (dialog.open() == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    String arg = resource.getFullPath().toString();
                    SystemTapOptionsTab.this.binaryFile.setText(String.valueOf(SystemTapOptionsTab.this.workspacePath) + arg);
                }
            }
        });
        Button fileBrowseButton2 = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.BrowseFiles"), null);
        fileBrowseButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file;
                String filePath = SystemTapOptionsTab.this.binaryFile.getText();
                FileDialog dialog = new FileDialog(SystemTapOptionsTab.this.getShell(), 8192);
                filePath = dialog.open();
                if (filePath != null && (file = new File(filePath)).exists()) {
                    SystemTapOptionsTab.this.binaryFile.setText(filePath);
                }
            }
        });
        Label outputFileLabel = new Label(browseTop, 0);
        outputFileLabel.setText(Messages.getString("SystemTapOptionsTab.SelectOutput"));
        this.outputFile = new Text(browseTop, 2048);
        this.outputFile.setLayoutData((Object)new GridData(768));
        this.outputFile.addModifyListener(this.modifyListenerOutput);
        this.outputFile.addFocusListener(this.focusListener);
        Button workspaceBrowseButton3 = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.WorkspaceButton2"), null);
        workspaceBrowseButton3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(SystemTapOptionsTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(Messages.getString("SystemTapOptionsTab.SelectResource"));
                dialog.setMessage(Messages.getString("SystemTapOptionsTab.SelectSuppressions"));
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                if (dialog.open() == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    String arg = resource.getFullPath().toString();
                    SystemTapOptionsTab.this.outputFile.setText(String.valueOf(SystemTapOptionsTab.this.workspacePath) + arg);
                    SystemTapOptionsTab.this.checkOverwrite();
                    SystemTapOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button fileBrowseButton3 = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.BrowseFiles"), null);
        fileBrowseButton3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = SystemTapOptionsTab.this.outputFile.getText();
                FileDialog dialog = new FileDialog(SystemTapOptionsTab.this.getShell(), 8192);
                filePath = dialog.open();
                if (filePath != null) {
                    SystemTapOptionsTab.this.outputFile.setText(filePath);
                    SystemTapOptionsTab.this.checkOverwrite();
                    SystemTapOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.useColourButton = new Button(browseTop, 32);
        this.useColourButton.setText(Messages.getString("SystemTapOptionsTab.ColourCodes"));
        this.useColourButton.addSelectionListener(this.selectListener);
        this.useColourButton.setLayoutData((Object)new GridData(768));
    }

    protected void createCommandOption(Composite top) {
        Composite browseTop = new Composite(top, 0);
        browseTop.setLayout((Layout)new GridLayout(3, false));
        GridData browseData = new GridData(768);
        browseTop.setLayoutData((Object)browseData);
        Composite buttonsTop = new Composite(top, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = PluginConstants.SYSTEMTAP_OPTIONS_TAB_HORIZONTAL_SPACING;
        buttonsTop.setLayout((Layout)gl);
        GridData buttonsData = new GridData(0x1000000, 1, true, true);
        buttonsData.heightHint = 400;
        buttonsTop.setLayoutData((Object)buttonsData);
        this.button_k = new Button(buttonsTop, 32);
        this.button_k.setText(Messages.getString("SystemTapOptionsTab.20"));
        this.button_k.addSelectionListener(this.selectListener);
        this.button_k.setLayoutData((Object)new GridData(768));
        this.button_k.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.5")) + Messages.getString("SystemTapOptionsTab.6") + Messages.getString("SystemTapOptionsTab.7"));
        this.button_g = new Button(buttonsTop, 32);
        this.button_g.setText(Messages.getString("SystemTapOptionsTab.21"));
        this.button_g.addSelectionListener(this.selectListener);
        this.button_g.setLayoutData((Object)new GridData(768));
        this.button_g.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.8")) + Messages.getString("SystemTapOptionsTab.9"));
        this.button_P = new Button(buttonsTop, 32);
        this.button_P.setText(Messages.getString("SystemTapOptionsTab.22"));
        this.button_P.addSelectionListener(this.selectListener);
        this.button_P.setLayoutData((Object)new GridData(768));
        this.button_P.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.10")) + Messages.getString("SystemTapOptionsTab.11"));
        this.button_u = new Button(buttonsTop, 32);
        this.button_u.setText(Messages.getString("SystemTapOptionsTab.23"));
        this.button_u.addSelectionListener(this.selectListener);
        this.button_u.setLayoutData((Object)new GridData(768));
        this.button_u.setToolTipText(Messages.getString("SystemTapOptionsTab.12"));
        this.button_w = new Button(buttonsTop, 32);
        this.button_w.setText(Messages.getString("SystemTapOptionsTab.24"));
        this.button_w.addSelectionListener(this.selectListener);
        this.button_w.setLayoutData((Object)new GridData(768));
        this.button_w.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.13")) + Messages.getString("SystemTapOptionsTab.14"));
        this.button_b = new Button(buttonsTop, 32);
        this.button_b.setText(Messages.getString("SystemTapOptionsTab.25"));
        this.button_b.addSelectionListener(this.selectListener);
        this.button_b.setLayoutData((Object)new GridData(768));
        this.button_b.setToolTipText(Messages.getString("SystemTapOptionsTab.15"));
        this.button_t = new Button(buttonsTop, 32);
        this.button_t.setText(Messages.getString("SystemTapOptionsTab.26"));
        this.button_t.addSelectionListener(this.selectListener);
        this.button_t.setLayoutData((Object)new GridData(768));
        this.button_t.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.16")) + Messages.getString("SystemTapOptionsTab.17"));
        this.button_F = new Button(buttonsTop, 32);
        this.button_F.setText(Messages.getString("SystemTapOptionsTab.LeaveProbesRunning"));
        this.button_F.addSelectionListener(this.selectListener);
        this.button_F.setLayoutData((Object)new GridData(768));
        this.button_F.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.27")) + Messages.getString("SystemTapOptionsTab.28") + Messages.getString("SystemTapOptionsTab.29"));
        this.button_skip_badvars = new Button(buttonsTop, 32);
        this.button_skip_badvars.setText(Messages.getString("SystemTapOptionsTab.IgnoreBadVars"));
        this.button_skip_badvars.addSelectionListener(this.selectListener);
        this.button_skip_badvars.setLayoutData((Object)new GridData(768));
        this.button_skip_badvars.setToolTipText(Messages.getString("SystemTapOptionsTab.30"));
        this.button_ignore_dwarf = new Button(buttonsTop, 32);
        this.button_ignore_dwarf.setText(Messages.getString("SystemTapOptionsTab.ForTesting"));
        this.button_ignore_dwarf.addSelectionListener(this.selectListener);
        this.button_ignore_dwarf.setLayoutData((Object)new GridData(768));
        this.button_ignore_dwarf.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.31")) + Messages.getString("SystemTapOptionsTab.32"));
        this.button_q = new Button(buttonsTop, 32);
        this.button_q.setText(Messages.getString("SystemTapOptionsTab.Button_qInfo"));
        this.button_q.addSelectionListener(this.selectListener);
        this.button_q.setLayoutData((Object)new GridData(768));
        this.button_q.setToolTipText(Messages.getString("SystemTapOptionsTab.33"));
        Composite button_p_Spinner_Top = new Composite(buttonsTop, 0);
        button_p_Spinner_Top.setLayout((Layout)new GridLayout(3, false));
        Label button_p_Spinner_Label = new Label(button_p_Spinner_Top, 0);
        button_p_Spinner_Label.setText(Messages.getString("SystemTapOptionsTab.19"));
        this.button_p_Spinner = new Spinner(button_p_Spinner_Top, 2048);
        this.button_p_Spinner.setMaximum(Integer.MAX_VALUE);
        this.button_p_Spinner.addModifyListener(this.modifyListener);
        this.button_p_Spinner.setLayoutData((Object)new GridData(768));
        button_p_Spinner_Label.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.34")) + Messages.getString("SystemTapOptionsTab.35") + Messages.getString("SystemTapOptionsTab.36"));
        Composite button_s_Spinner_Top = new Composite(buttonsTop, 0);
        button_s_Spinner_Top.setLayout((Layout)new GridLayout(2, false));
        Label button_s_Spinner_Label = new Label(button_s_Spinner_Top, 0);
        button_s_Spinner_Label.setText(Messages.getString("SystemTapOptionsTab.BufferWith"));
        this.button_s_Spinner = new Spinner(button_s_Spinner_Top, 2048);
        this.button_s_Spinner.setMaximum(Integer.MAX_VALUE);
        this.button_s_Spinner.addModifyListener(this.modifyListener);
        this.button_s_Spinner.setLayoutData((Object)new GridData(768));
        button_s_Spinner_Label.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.37")) + Messages.getString("SystemTapOptionsTab.38"));
        Composite button_x_Spinner_Top = new Composite(buttonsTop, 0);
        button_x_Spinner_Top.setLayout((Layout)new GridLayout(2, false));
        Label button_x_Spinner_Label = new Label(button_x_Spinner_Top, 0);
        button_x_Spinner_Label.setText(Messages.getString("SystemTapOptionsTab.TargetPID"));
        this.button_x_Spinner = new Spinner(button_x_Spinner_Top, 2048);
        this.button_x_Spinner.setMaximum(Integer.MAX_VALUE);
        this.button_x_Spinner.addModifyListener(this.modifyListener);
        this.button_x_Spinner.setLayoutData((Object)new GridData(768));
        button_x_Spinner_Label.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.39")) + Messages.getString("SystemTapOptionsTab.40"));
        Composite button_v_Spinner_Top = new Composite(buttonsTop, 0);
        button_v_Spinner_Top.setLayout((Layout)new GridLayout(2, false));
        Label button_v_Spinner_Label = new Label(button_v_Spinner_Top, 0);
        button_v_Spinner_Label.setText(Messages.getString("SystemTapOptionsTab.18"));
        this.button_v_Spinner = new Spinner(button_v_Spinner_Top, 2048);
        this.button_v_Spinner.setMaximum(3);
        this.button_v_Spinner.addModifyListener(this.modifyListener);
        this.button_v_Spinner.setLayoutData((Object)new GridData(768));
        button_v_Spinner_Label.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.2")) + Messages.getString("SystemTapOptionsTab.4"));
        this.button_graphicsMode = new Button(buttonsTop, 32);
        this.button_graphicsMode.setText(Messages.getString("SystemTapOptionsTab.3"));
        this.button_graphicsMode.addSelectionListener(this.graphicsModeListener);
        this.button_graphicsMode.setLayoutData((Object)new GridData(768));
        this.button_graphicsMode.setToolTipText(Messages.getString("SystemTapOptionsTab.41"));
        Label button_D_label = new Label(buttonsTop, 0);
        button_D_label.setText(Messages.getString("SystemTapOptionsTab.PreprocessorDirective"));
        this.button_D_text = new Text(buttonsTop, 2048);
        this.button_D_text.setLayoutData((Object)new GridData(200, 15));
        this.button_D_text.addModifyListener(this.modifyListener);
        button_D_label.setToolTipText(String.valueOf(Messages.getString("SystemTapOptionsTab.42")) + Messages.getString("SystemTapOptionsTab.43"));
    }

    public String getName() {
        return Messages.getString("SystemTapOptionsTab.MainTabName");
    }

    protected Shell getActiveWorkbenchShell() {
        return CallgraphLaunchPlugin.getActiveWorkbenchShell();
    }

    private IBinary chooseBinary(IBinary[] binaries) {
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getActiveWorkbenchShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements((Object[])binaries);
        dialog.setTitle(Messages.getString("SystemtTapOptionsTab.Callgraph"));
        dialog.setMessage(Messages.getString("SystemtTapOptionsTab.Choose_a_local_application"));
        dialog.setUpperListLabel(Messages.getString("SystemtTapOptionsTab.Binaries"));
        dialog.setLowerListLabel(Messages.getString("SystemtTapOptionsTab.Qualifier"));
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IBinary)dialog.getFirstResult();
        }
        return null;
    }

    private IBinary getBinary(ILaunchConfiguration config) {
        try {
            ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
            IBinary[] binaries = project.getBinaryContainer().getBinaries();
            if (binaries != null && binaries.length > 0) {
                if (binaries.length == 1 && binaries[0] != null) {
                    return binaries[0];
                }
                return this.chooseBinary(binaries);
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath location = root.getLocation();
        this.workspacePath = location.toString();
        try {
            this.button_k.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.KEEP_TEMPORARY", false));
            this.button_u.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.NO_CODE_ELISION", false));
            this.button_w.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.DISABLE_WARNINGS", false));
            this.button_b.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.BULK_MODE", false));
            this.button_g.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.GURU", false));
            this.button_P.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.PROLOGUE_SEARCH", false));
            this.button_t.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.TIMING_INFO", false));
            this.button_skip_badvars.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.SKIP_BADVARS", false));
            this.button_ignore_dwarf.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.IGNORE_DWARF", false));
            this.button_q.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.TAPSET_COVERAGE", false));
            this.button_F.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.LEAVE_RUNNING", false));
            this.button_s_Spinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.BUFFER_BYTES", 0));
            this.button_x_Spinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.TARGET_PID", 0));
            this.button_v_Spinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.COMMAND_VERBOSE", 0));
            this.button_p_Spinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.PASS", 0));
            this.button_D_text.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.C_DIRECTIVES", ""));
            this.binaryFile.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", ""));
            this.scriptFile.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", ""));
            this.outputFile.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.OUTPUT_PATH", ""));
            this.arguments.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", ""));
            this.binaryArguments.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_ARGUMENTS", ""));
            this.parser.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.PARSER_CLASS", ""));
            this.viewer.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS", ""));
            if (this.generatedScript != null) {
                this.generatedScript.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.GENERATED_SCRIPT", ""));
                this.needToGenerateScriptButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.NEED_TO_GENERATE", false));
            }
            this.useColourButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.USE_COLOUR", false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.getControl().setRedraw(false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.KEEP_TEMPORARY", this.button_k.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.GURU", this.button_g.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PROLOGUE_SEARCH", this.button_P.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.NO_CODE_ELISION", this.button_u.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.DISABLE_WARNINGS", this.button_w.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BULK_MODE", this.button_b.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TIMING_INFO", this.button_t.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.SKIP_BADVARS", this.button_skip_badvars.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.IGNORE_DWARF", this.button_ignore_dwarf.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TAPSET_COVERAGE", this.button_q.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.LEAVE_RUNNING", this.button_F.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PASS", this.button_p_Spinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BUFFER_BYTES", this.button_s_Spinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TARGET_PID", this.button_x_Spinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.COMMAND_VERBOSE", this.button_v_Spinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PARSER_CLASS", this.parser.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS", this.viewer.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.C_DIRECTIVES", this.button_D_text.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", this.binaryFile.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", this.scriptFile.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", this.arguments.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_ARGUMENTS", this.binaryArguments.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.OUTPUT_PATH", this.outputFile.getText());
        if (this.generatedScript != null) {
            configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.GENERATED_SCRIPT", this.generatedScript.getText());
            configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.NEED_TO_GENERATE", this.needToGenerateScriptButton.getSelection());
        }
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.USE_COLOUR", this.useColourButton.getSelection());
        if (this.button_graphicsMode.getSelection()) {
            this.scriptFile.setEnabled(false);
            this.workspaceBrowseButton.setEnabled(false);
            this.fileBrowseButton.setEnabled(false);
        } else {
            this.scriptFile.setEnabled(true);
            this.workspaceBrowseButton.setEnabled(true);
            this.fileBrowseButton.setEnabled(true);
        }
        if (this.changeOverwrite) {
            if (this.needsOverwritePermission && this.overwritePermission || !this.needsOverwritePermission) {
                configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.OVERWRITE", true);
            } else {
                configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.OVERWRITE", false);
            }
            this.changeOverwrite = false;
        }
        this.getControl().setRedraw(true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.COMMAND_VERBOSE", 0);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.KEEP_TEMPORARY", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.GURU", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PROLOGUE_SEARCH", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.NO_CODE_ELISION", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.DISABLE_WARNINGS", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BULK_MODE", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TIMING_INFO", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.SKIP_BADVARS", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.IGNORE_DWARF", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TAPSET_COVERAGE", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.LEAVE_RUNNING", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PASS", 0);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BUFFER_BYTES", 0);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TARGET_PID", 0);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.C_DIRECTIVES", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.OUTPUT_PATH", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_ARGUMENTS", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.GENERATED_SCRIPT", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.NEED_TO_GENERATE", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PARSER_CLASS", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.USE_COLOUR", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.COMMAND_LIST", ConfigurationOptionsSetter.setOptions((ILaunchConfiguration)configuration));
        ICElement cElement = null;
        cElement = this.getContext((ILaunchConfiguration)configuration, this.getPlatform((ILaunchConfiguration)configuration));
        if (cElement != null) {
            this.initializeCProject(cElement, configuration);
        } else {
            configuration.setMappedResources(null);
        }
        IBinary bin = null;
        bin = this.getBinary((ILaunchConfiguration)configuration);
        if (bin != null) {
            String programName = bin.getResource().getProjectRelativePath().toString();
            configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programName);
            configuration.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            LaunchStapGraph launch = new LaunchStapGraph();
            launch.setTestMode(true);
            launch.launch(bin, "", configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid = true;
        try {
            String sPath = launchConfig.getAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", "");
            File script = new File(sPath);
            if (sPath.equals("") || !script.exists()) {
                valid = false;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return valid;
    }

    private String getUsefulLabel(Object element) {
        Object o;
        if (element instanceof IConfigurationElement && (o = ((IConfigurationElement)element).getParent()) instanceof IExtension) {
            IExtension e = (IExtension)((IConfigurationElement)element).getParent();
            return e.getUniqueIdentifier();
        }
        return Messages.getString("SystemTapOptionsTab.1");
    }

    private static class ListLabelProvider
    implements ILabelProvider {
        private ListLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IConfigurationElement) {
                Object o = ((IConfigurationElement)element).getParent();
                if (o instanceof IExtension) {
                    IExtension e = (IExtension)((IConfigurationElement)element).getParent();
                    return e.getLabel();
                }
                if (o instanceof IConfigurationElement) {
                    IConfigurationElement e = (IConfigurationElement)((IConfigurationElement)element).getParent();
                    return e.getName();
                }
            }
            return Messages.getString("SystemTapOptionsTab.46");
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

