/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPConfiguration;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPDocumentProvider;
import org.eclipse.linuxtools.systemtap.ui.editor.ColorManager;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.linuxtools.systemtap.ui.editor.SimpleEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class STPEditor
extends SimpleEditor {
    private ColorManager colorManager = new ColorManager();
    private ProjectionSupport stpProjectionSupport;
    private Annotation[] stpOldAnnotations;
    private ProjectionAnnotationModel stpAnnotationModel;
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor";

    public STPEditor() {
        this.setSourceViewerConfiguration(new STPConfiguration(this.colorManager, this));
        this.setDocumentProvider((IDocumentProvider)new STPDocumentProvider());
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input instanceof FileStoreEditorInput) {
            input = new PathEditorInput((IPath)new Path(((FileStoreEditorInput)input).getURI().getPath()));
        }
        super.doSetInput(input);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.stpProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.stpProjectionSupport.install();
        viewer.doOperation(19);
        this.stpAnnotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateFoldingStructure(ArrayList<Position> updatedPositions) {
        Annotation[] updatedAnnotations = new Annotation[updatedPositions.size()];
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < updatedPositions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, updatedPositions.get(i));
            updatedAnnotations[i] = annotation;
            ++i;
        }
        this.stpAnnotationModel.modifyAnnotations(this.stpOldAnnotations, newAnnotations, null);
        this.stpOldAnnotations = updatedAnnotations;
    }

    public ISourceViewer getMySourceViewer() {
        return this.getSourceViewer();
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "ShiftRight");
        this.addAction(menu, "group.edit", "ShiftLeft");
    }
}

