/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.FunctionParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.ProbeParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TreeSettings;
import org.eclipse.linuxtools.man.parser.ManPage;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.preferences.PreferenceConstants;
import org.eclipse.ui.PlatformUI;

public final class TapsetLibrary {
    private static TreeNode functionTree = null;
    private static TreeNode probeTree = null;
    private static FunctionParser functionParser = null;
    private static ProbeParser probeParser = null;
    private static HashMap<String, String> pages = new HashMap();
    private static Job cacheFunctionManpages = new Job(Localization.getString("TapsetLibrary.0")){
        private boolean cancelled;

        protected IStatus run(IProgressMonitor monitor) {
            TreeNode node = functionParser.getFunctions();
            int n = node.getChildCount();
            int i = 0;
            while (i < n && !this.cancelled) {
                TapsetLibrary.getAndCacheDocumentation("function::" + node.getChildAt(i).toString());
                ++i;
            }
            return new Status(0, "org.eclipse.linuxtools.systemtap.ui.ide", "");
        }

        protected void canceling() {
            this.cancelled = true;
        }
    };
    private static Job cacheProbeManpages = new Job(Localization.getString("TapsetLibrary.1")){

        protected IStatus run(IProgressMonitor monitor) {
            TreeNode node = probeParser.getProbes();
            int n = node.getChildCount();
            int i = 0;
            while (i < n) {
                TapsetLibrary.getAndCacheDocumentation("tapset::" + node.getChildAt(i).toString());
                ++i;
            }
            return new Status(0, "org.eclipse.linuxtools.systemtap.ui.ide", "");
        }
    };
    private static final IUpdateListener functionCompletionListener = new IUpdateListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleUpdateEvent() {
            functionTree = functionParser.getFunctions();
            cacheFunctionManpages.schedule();
            TreeSettings.setTrees(functionTree, probeTree);
            FunctionParser functionParser = functionParser;
            synchronized (functionParser) {
                ((Object)((Object)functionParser)).notifyAll();
            }
        }
    };
    private static final IUpdateListener probeCompletionListener = new IUpdateListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleUpdateEvent() {
            probeTree = probeParser.getProbes();
            cacheProbeManpages.schedule();
            ProbeParser probeParser = probeParser;
            synchronized (probeParser) {
                ((Object)((Object)probeParser)).notifyAll();
            }
        }
    };

    public static TreeNode getProbes() {
        return probeTree;
    }

    public static TreeNode getFunctions() {
        return functionTree;
    }

    public static synchronized String getDocumentation(String element) {
        String documentation = pages.get(element);
        if (documentation == null) {
            String[] sections;
            if (element.matches("probe::.*::.*")) {
                String probe = element.split("::")[1];
                TapsetLibrary.getDocumentation("probe::" + probe);
                return pages.get(element);
            }
            documentation = new ManPage(element).getStrippedTextPage().toString();
            if (!documentation.startsWith("No manual entry for") && element.startsWith("probe::") && (sections = documentation.split("VALUES")).length > 1) {
                String variablesString = sections[1].split("CONTEXT|DESCRIPTION|SystemTap Tapset Reference")[0].trim();
                String[] variables = variablesString.split("\n");
                int i = 0;
                if (!variables[0].equals("None")) {
                    while (i < variables.length) {
                        String variableName = variables[i].trim();
                        StringBuilder variableDocumentation = new StringBuilder();
                        ++i;
                        while (i < variables.length && !variables[i].isEmpty()) {
                            variableDocumentation.append(variables[i].trim());
                            variableDocumentation.append("\n");
                            ++i;
                        }
                        pages.put(String.valueOf(element) + "::" + variableName, variableDocumentation.toString().trim());
                        ++i;
                    }
                }
            }
        }
        return documentation;
    }

    public static synchronized String getAndCacheDocumentation(String element) {
        String doc = pages.get(element);
        if (doc == null) {
            doc = TapsetLibrary.getDocumentation(element);
            pages.put(element, doc);
        }
        return doc;
    }

    public static void init() {
        if (functionParser != null && probeParser != null) {
            return;
        }
        IPreferenceStore preferenceStore = IDEPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.contains("UseStoredTreePreference") && preferenceStore.getBoolean("UseStoredTreePreference") && TapsetLibrary.isTreeFileCurrent()) {
            TapsetLibrary.readTreeFile();
        } else {
            TapsetLibrary.runStapParser();
        }
    }

    private static void runStapParser() {
        functionParser = FunctionParser.getInstance();
        functionParser.addListener(functionCompletionListener);
        functionParser.schedule();
        probeParser = ProbeParser.getInstance();
        probeParser.addListener(probeCompletionListener);
        probeParser.schedule();
    }

    private static void readTreeFile() {
        functionTree = TreeSettings.getFunctionTree();
        probeTree = TreeSettings.getProbeTree();
    }

    private static boolean isTreeFileCurrent() {
        long treesDate = TreeSettings.getTreeFileDate();
        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        String[] tapsets = p.getString("TapsetPreference").split(File.pathSeparator);
        File f = TapsetLibrary.getTapsetLocation(p);
        if (!TapsetLibrary.checkIsCurrentFolder(treesDate, f)) {
            return false;
        }
        if (tapsets != null) {
            int i = 0;
            while (i < tapsets.length) {
                f = new File(tapsets[i]);
                if (f.lastModified() > treesDate) {
                    return false;
                }
                if (f.canRead() && !TapsetLibrary.checkIsCurrentFolder(treesDate, f)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static File getTapsetLocation(IPreferenceStore p) {
        File f;
        String path = p.getString(PreferenceConstants.P_ENV[2][0]);
        if (path.trim().equals("")) {
            f = new File("/usr/share/systemtap/tapset");
            if (!f.exists() && !(f = new File("/usr/local/share/systemtap/tapset")).exists()) {
                InputDialog i = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Localization.getString("TapsetBrowserView.TapsetLocation"), Localization.getString("TapsetBrowserView.WhereDefaultTapset"), "", null);
                i.open();
                p.setValue(PreferenceConstants.P_ENV[2][0], i.getValue());
                f = new File(i.getValue());
            }
        } else {
            f = new File(p.getString(path));
        }
        IDESessionSettings.tapsetLocation = f.getAbsolutePath();
        return f;
    }

    private static boolean checkIsCurrentFolder(long time, File folder) {
        File[] fs = folder.listFiles();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].lastModified() > time) {
                return false;
            }
            if (fs[i].isDirectory() && fs[i].canRead() && !TapsetLibrary.checkIsCurrentFolder(time, fs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean addFunctionListener(IUpdateListener listener) {
        if (functionParser == null) {
            return false;
        }
        functionParser.addListener(listener);
        return true;
    }

    public static boolean addProbeListener(IUpdateListener listener) {
        if (probeParser == null) {
            return false;
        }
        probeParser.addListener(listener);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForInitialization() {
        TapsetParser tapsetParser;
        while (functionParser.getResult() == null) {
            try {
                tapsetParser = functionParser;
                synchronized (tapsetParser) {
                    ((Object)((Object)functionParser)).wait(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        while (probeParser.getResult() == null) {
            try {
                tapsetParser = probeParser;
                synchronized (tapsetParser) {
                    ((Object)((Object)probeParser)).wait(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public static void stop() {
        if (functionParser != null) {
            functionParser.cancel();
            cacheFunctionManpages.cancel();
            try {
                functionParser.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (probeParser != null) {
            probeParser.cancel();
            cacheProbeManpages.cancel();
            try {
                probeParser.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

