/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui.extensions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.ui.LazyEnvManagerDetector;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.launch.IJAXBParentLaunchConfigurationTab;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.ui.extensions.AbstractJAXBLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.ExtensibleJAXBControllerTab;
import org.eclipse.ptp.launch.ui.extensions.JAXBDynamicLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.JAXBImportedScriptLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.RemoteServicesUtils;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModelEnabled;
import org.eclipse.ptp.rm.jaxb.core.data.LaunchTabType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.ScriptType;
import org.eclipse.ptp.rm.jaxb.core.data.TabControllerType;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JAXBControllerLaunchConfigurationTab
extends ExtensibleJAXBControllerTab
implements IJAXBParentLaunchConfigurationTab,
IUpdateModelEnabled,
SelectionListener {
    protected final ILaunchController fControl;
    protected final LaunchTabType launchTabData;
    protected final IUpdateHandler updateHandler;
    protected final LCVariableMap lcMap;
    protected IRemoteConnection fRemoteConnection;
    protected ScriptType script;

    public JAXBControllerLaunchConfigurationTab(ILaunchController control, ILaunchConfigurationDialog dialog, IProgressMonitor monitor) throws Throwable {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.fControl = control;
        LCVariableMap varMap = null;
        this.setLaunchConfigurationDialog(dialog);
        try {
            ResourceManagerData data = control.getConfiguration();
            if (data == null) {
                throw new Throwable(Messages.JAXBControllerLaunchConfigurationTab_unableToObtainConfigurationInfo);
            }
            this.script = data.getControlData().getScript();
            this.fRemoteConnection = RemoteServicesUtils.getConnectionWithProgress((String)this.fControl.getRemoteServicesId(), (String)this.fControl.getConnectionName(), (IProgressMonitor)progress.newChild(30));
            if (this.fRemoteConnection == null) {
                throw new Throwable(Messages.JAXBControllerLaunchConfigurationTab_unableToObtainConnectionInfo);
            }
            if (!this.fRemoteConnection.isOpen()) {
                this.fRemoteConnection.open((IProgressMonitor)progress.newChild(50));
            }
            varMap = new LCVariableMap();
            varMap.setEnvManager(this.getEnvManager((IProgressMonitor)progress.newChild(10)));
            this.voidRMConfig = false;
        }
        catch (Throwable t) {
            this.script = null;
            this.voidRMConfig = true;
            WidgetActionUtils.errorMessage((Shell)Display.getDefault().getActiveShell(), (Throwable)t, (String)Messages.VoidLaunchTabMessage, (String)Messages.VoidLaunchTabTitle, (boolean)false);
        }
        if (!this.voidRMConfig) {
            this.launchTabData = control.getConfiguration().getControlData().getLaunchTab();
            this.updateHandler = new ValueUpdateHandler((IUpdateModelEnabled)this);
            if (this.launchTabData != null) {
                List dynamic = this.launchTabData.getDynamic();
                for (TabControllerType controller : dynamic) {
                    this.addDynamicTab(new JAXBDynamicLaunchConfigurationTab(control, controller, this));
                }
                LaunchTabType.Import importTab = this.launchTabData.getImport();
                if (importTab != null) {
                    this.addDynamicTab(new JAXBImportedScriptLaunchConfigurationTab(control, importTab, this));
                }
            }
            varMap = new LCVariableMap();
            varMap.setEnvManager(this.getEnvManager((IProgressMonitor)progress.newChild(10)));
        } else {
            this.getControllers().clear();
            this.launchTabData = null;
            this.updateHandler = null;
        }
        this.lcMap = varMap;
    }

    public void createControl(Composite parent, String id) throws CoreException {
        if (!this.voidRMConfig) {
            this.updateHandler.clear();
        }
        super.createControl(parent, id);
        if (this.tabFolder != null) {
            this.tabFolder.addSelectionListener((SelectionListener)this);
        }
    }

    public void fireContentsChanged() {
        super.fireContentsChanged();
    }

    public IRemoteConnection getConnection() {
        return this.fRemoteConnection;
    }

    private IEnvManager getEnvManager(IProgressMonitor monitor) {
        LazyEnvManagerDetector envMgr = new LazyEnvManagerDetector(this.fRemoteConnection);
        envMgr.setProgressMonitor(monitor);
        return envMgr;
    }

    public ILaunchController getJobControl() {
        return this.fControl;
    }

    public LaunchTabType getLaunchTabData() {
        return this.launchTabData;
    }

    public ScriptType getScript() {
        return this.script;
    }

    public IUpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public LCVariableMap getVariableMap() {
        return this.lcMap;
    }

    public boolean hasScript() {
        return this.script != null;
    }

    public RMLaunchValidation initializeFrom(ILaunchConfiguration configuration) {
        if (!this.voidRMConfig) {
            try {
                this.lcMap.initialize(this.fControl.getEnvironment(), this.fControl.getControlId());
                this.updateHandler.clear();
                this.lcMap.updateFromConfiguration(configuration);
            }
            catch (CoreException e) {
                return new RMLaunchValidation(false, e.getLocalizedMessage());
            }
            catch (Throwable e) {
                return new RMLaunchValidation(false, e.getLocalizedMessage());
            }
        }
        RMLaunchValidation validation = super.initializeFrom(configuration);
        if (!this.getControllers().isEmpty()) {
            this.tabFolder.setSelection(this.lastIndex);
            this.setVisibleOnSelected();
        }
        return validation;
    }

    public void relink() {
        AbstractJAXBLaunchConfigurationTab t = this.getControllers().get(this.tabFolder.getSelectionIndex());
        this.lcMap.relinkHidden(t.getControllerTag());
    }

    private void setVisibleOnSelected() {
        this.lastIndex = this.tabFolder.getSelectionIndex();
        AbstractJAXBLaunchConfigurationTab t = this.getControllers().get(this.lastIndex);
        t.getControl().setVisible(true);
        t.setVisible();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.setVisibleOnSelected();
    }

    public void widgetSelected(SelectionEvent e) {
        this.setVisibleOnSelected();
    }
}

