/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.ptp.debug.core.IPBreakpointManager;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.model.IPAddressBreakpoint;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPFunctionBreakpoint;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.core.model.IPWatchpoint;
import org.eclipse.ptp.debug.core.pdi.IPDIAddressLocation;
import org.eclipse.ptp.debug.core.pdi.IPDICondition;
import org.eclipse.ptp.debug.core.pdi.IPDIFileLocation;
import org.eclipse.ptp.debug.core.pdi.IPDIFunctionLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILineLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIBreakpointInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDICreatedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDestroyedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIBreakpointManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIAddressBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILineBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocationBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIWatchpoint;
import org.eclipse.ptp.internal.debug.core.PDebugModel;
import org.eclipse.ptp.internal.debug.core.PSession;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.event.PDebugBreakpointInfo;
import org.eclipse.ptp.internal.debug.core.messages.Messages;
import org.eclipse.ptp.internal.debug.core.sourcelookup.IPSourceLocator;
import org.eclipse.ptp.internal.debug.core.sourcelookup.PSourceLookupDirector;

public class PBreakpointManager
implements IBreakpointsListener,
IBreakpointManagerListener,
IPDIEventListener,
IAdaptable,
IPBreakpointManager {
    private final IPSession session;
    private final BreakpointMap fBreakpointMap = new BreakpointMap();
    private boolean fSkipBreakpoint = false;

    public PBreakpointManager(IPSession session) {
        this.session = session;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.getPDISession().getEventManager().addEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSetBreakpoints(TaskSet tasks, IPBreakpoint[] breakpoints) {
        if (breakpoints.length == 0) {
            return;
        }
        IPBreakpoint[] iPBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPBreakpoint bpt = iPBreakpointArray[n2];
            IPDIBreakpoint pdiBreakpoint = null;
            BreakpointMap breakpointMap = this.fBreakpointMap;
            synchronized (breakpointMap) {
                pdiBreakpoint = this.fBreakpointMap.getPDIBreakpoint(bpt);
            }
            if (pdiBreakpoint != null) {
                try {
                    this.getPDISession().getBreakpointManager().addSetBreakpoint(tasks, pdiBreakpoint);
                }
                catch (PDIException ex) {
                    PTPDebugCorePlugin.log(ex);
                }
            }
            ++n2;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        this.doSkipBreakpoints(!enabled);
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        ArrayList<IPBreakpoint> list = new ArrayList<IPBreakpoint>(breakpoints.length);
        int i = 0;
        while (i < breakpoints.length) {
            if (this.isTargetBreakpoint(breakpoints[i])) {
                list.add((IPBreakpoint)breakpoints[i]);
            }
            ++i;
        }
        if (list.isEmpty()) {
            return;
        }
        final IPBreakpoint[] pBreakpoints = list.toArray(new IPBreakpoint[list.size()]);
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                PBreakpointManager.this.setBreakpointsOnSession0(pBreakpoints);
            }
        });
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        int i = 0;
        while (i < breakpoints.length) {
            if (this.isTargetBreakpoint(breakpoints[i])) {
                this.changeBreakpointProperties((IPBreakpoint)breakpoints[i], deltas[i]);
            }
            ++i;
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        ArrayList<IPBreakpoint> pBreakpoints = new ArrayList<IPBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (this.isTargetBreakpoint(breakpoint)) {
                pBreakpoints.add((IPBreakpoint)breakpoint);
            }
            ++n2;
        }
        final IPBreakpoint[] bpToRemove = pBreakpoints.toArray(new IPBreakpoint[0]);
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                PBreakpointManager.this.deleteBreakpointsOnSession0(bpToRemove);
            }
        });
    }

    public void deleteBreakpoint(IPBreakpoint breakpoint) {
        if (this.isTargetBreakpoint(breakpoint)) {
            final IPBreakpoint[] pBreakpoints = new IPBreakpoint[]{breakpoint};
            DebugPlugin.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints((IBreakpoint[])pBreakpoints, true);
                    }
                    catch (CoreException e) {
                        PTPDebugCorePlugin.log(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSetBreakpoints(TaskSet tasks, IPBreakpoint[] breakpoints) {
        if (breakpoints.length == 0) {
            return;
        }
        IPBreakpoint[] iPBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPBreakpoint bpt = iPBreakpointArray[n2];
            IPDIBreakpoint pdiBreakpoint = null;
            BreakpointMap breakpointMap = this.fBreakpointMap;
            synchronized (breakpointMap) {
                pdiBreakpoint = this.fBreakpointMap.getPDIBreakpoint(bpt);
            }
            if (pdiBreakpoint != null) {
                try {
                    this.getPDISession().getBreakpointManager().deleteSetBreakpoint(tasks, pdiBreakpoint);
                }
                catch (PDIException ex) {
                    PTPDebugCorePlugin.log(ex);
                }
            }
            ++n2;
        }
    }

    public void dispose(IProgressMonitor monitor) {
        this.getPDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.fBreakpointMap.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(PBreakpointManager.class)) {
            return this;
        }
        if (adapter.equals(PSession.class)) {
            return this.getSession();
        }
        if (adapter.equals(IPSession.class)) {
            return this.getSession();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBreakpoint getBreakpoint(IPDIBreakpoint pdiBpt) {
        IPBreakpoint b = null;
        BreakpointMap breakpointMap = this.fBreakpointMap;
        synchronized (breakpointMap) {
            b = this.fBreakpointMap.getPBreakpoint(pdiBpt);
        }
        return b instanceof IBreakpoint ? (IBreakpoint)b : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getBreakpointAddress(IPLineBreakpoint breakpoint) {
        BigInteger address = null;
        BreakpointMap breakpointMap = this.fBreakpointMap;
        synchronized (breakpointMap) {
            IPDILocator locator;
            IPDIBreakpoint pdiBreakpoint = this.fBreakpointMap.getPDIBreakpoint(breakpoint);
            if (pdiBreakpoint instanceof IPDILocationBreakpoint && (locator = ((IPDILocationBreakpoint)pdiBreakpoint).getLocator()) != null) {
                address = locator.getAddress();
            }
        }
        return address;
    }

    public IPSession getSession() {
        return this.session;
    }

    public void handleDebugEvents(IPDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IPDIEvent event = events[i];
            if (event instanceof IPDICreatedEvent) {
                this.handleCreatedEvent((IPDICreatedEvent)event);
            } else if (event instanceof IPDIDestroyedEvent) {
                this.handleDestroyedEvent((IPDIDestroyedEvent)event);
            } else if (event instanceof IPDIChangedEvent) {
                this.handleChangedEvent((IPDIChangedEvent)event);
            }
            ++i;
        }
    }

    public void setInitialBreakpoints() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(PDebugModel.getPluginIdentifier());
        ArrayList<IPBreakpoint> list = new ArrayList<IPBreakpoint>(breakpoints.length);
        int i = 0;
        while (i < breakpoints.length) {
            if (this.isTargetBreakpoint(breakpoints[i])) {
                list.add((IPBreakpoint)breakpoints[i]);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            IPBreakpoint[] pBreakpoints = list.toArray(new IPBreakpoint[list.size()]);
            this.setBreakpointsOnSession0(pBreakpoints);
        }
    }

    public void setStopInMain(TaskSet tasks) throws PDIException {
        IPDIBreakpointManager pdiBptMgr = this.getPDISession().getBreakpointManager();
        IPDIFunctionLocation location = pdiBptMgr.createFunctionLocation("", "main");
        pdiBptMgr.setFunctionBreakpoint(tasks, 1, location, null, true, true);
    }

    public void skipBreakpoints(boolean enabled) {
        if (this.fSkipBreakpoint != enabled && (DebugPlugin.getDefault().getBreakpointManager().isEnabled() || !enabled)) {
            this.fSkipBreakpoint = enabled;
            this.doSkipBreakpoints(enabled);
        }
    }

    public boolean supportsAddressBreakpoint(IPAddressBreakpoint breakpoint) {
        return false;
    }

    public void updatePendingBreakpoints() throws PDIException {
        this.getPDISession().getBreakpointManager().updatePendingBreakpoints();
    }

    public void watchpointOutOfScope(TaskSet tasks, IPDIWatchpoint pdiWatchpoint) {
        this.doHandleDestroyedEvent(tasks, pdiWatchpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeBreakpointProperties(IPBreakpoint breakpoint, IMarkerDelta delta) {
        IPDIBreakpoint pdiBreakpoint = null;
        BreakpointMap breakpointMap = this.fBreakpointMap;
        synchronized (breakpointMap) {
            pdiBreakpoint = this.fBreakpointMap.getPDIBreakpoint(breakpoint);
        }
        if (pdiBreakpoint == null) {
            return;
        }
        try {
            IPDICondition pdiCondition;
            boolean enabled = breakpoint.isEnabled();
            boolean oldEnabled = delta != null ? delta.getAttribute("org.eclipse.debug.core.enabled", true) : enabled;
            int ignoreCount = breakpoint.getIgnoreCount();
            int oldIgnoreCount = delta != null ? delta.getAttribute("org.eclipse.ptp.debug.core.ignoreCount", 0) : ignoreCount;
            String condition = breakpoint.getCondition();
            String oldCondition = delta != null ? delta.getAttribute("org.eclipse.ptp.debug.core.condition", "") : condition;
            Boolean enabled0 = null;
            IPDICondition condition0 = null;
            if (enabled != oldEnabled && enabled != pdiBreakpoint.isEnabled()) {
                enabled0 = enabled;
            }
            if (!(ignoreCount == oldIgnoreCount && condition.compareTo(oldCondition) == 0 || (pdiCondition = this.getPDISession().getBreakpointManager().createCondition(ignoreCount, condition, null)).equals(pdiBreakpoint.getCondition()))) {
                condition0 = pdiCondition;
            }
            if (enabled0 != null || condition0 != null) {
                this.changeBreakpointPropertiesOnSession(this.getBreakpointTasks(breakpoint), pdiBreakpoint, enabled0, condition0);
            }
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
        }
        catch (PDIException e) {
            PTPDebugCorePlugin.log(e);
        }
    }

    private void changeBreakpointProperties(IPBreakpoint breakpoint, IPDIBreakpoint pdiBreakpoint) throws CoreException {
        try {
            Boolean enabled = null;
            if (pdiBreakpoint.isEnabled() != breakpoint.isEnabled()) {
                enabled = breakpoint.isEnabled();
            }
            IPDICondition condition = null;
            IPDICondition c = this.createCondition(breakpoint);
            if (!pdiBreakpoint.getCondition().equals(c)) {
                condition = c;
            }
            if (enabled != null || condition != null) {
                this.changeBreakpointPropertiesOnSession(this.getBreakpointTasks(breakpoint), pdiBreakpoint, enabled, condition);
            }
        }
        catch (PDIException pe) {
            PTPDebugCorePlugin.log(pe);
        }
    }

    private void changeBreakpointPropertiesOnSession(final TaskSet tasks, final IPDIBreakpoint breakpoint, final Boolean enabled, final IPDICondition condition) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (enabled != null) {
                    try {
                        if (enabled.booleanValue()) {
                            PBreakpointManager.this.getPDISession().getBreakpointManager().enableBreakpoint(tasks, breakpoint);
                        } else {
                            PBreakpointManager.this.getPDISession().getBreakpointManager().disableBreakpoint(tasks, breakpoint);
                        }
                    }
                    catch (PDIException e) {
                        PTPDebugCorePlugin.log(e);
                    }
                }
                if (condition != null) {
                    try {
                        PBreakpointManager.this.getPDISession().getBreakpointManager().setCondition(tasks, breakpoint, condition);
                    }
                    catch (PDIException e) {
                        PTPDebugCorePlugin.log(e);
                    }
                }
            }
        });
    }

    private IPath convertPath(String sourceHandle) {
        IPath path = null;
        if (Path.EMPTY.isValidPath(sourceHandle)) {
            ISourceLocator sl = this.getSourceLocator();
            if (sl instanceof PSourceLookupDirector) {
                path = ((PSourceLookupDirector)sl).getCompilationPath(sourceHandle);
            }
            if (path == null) {
                path = new Path(sourceHandle);
            }
        }
        return path;
    }

    private IPDICondition createCondition(IPBreakpoint pBpt) throws CoreException, PDIException {
        return this.getPDISession().getBreakpointManager().createCondition(pBpt.getIgnoreCount(), pBpt.getCondition(), null);
    }

    private void doHandleChangedEvent(TaskSet tasks, IPDIBreakpoint pdiBreakpoint) {
        IPBreakpoint breakpoint = this.fBreakpointMap.getPBreakpoint(pdiBreakpoint);
        if (breakpoint != null) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            try {
                if (!this.fSkipBreakpoint && DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
                    map.put("org.eclipse.debug.core.enabled", pdiBreakpoint.isEnabled());
                } else {
                    map.put("org.eclipse.debug.core.enabled", breakpoint.isEnabled());
                }
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.log(e);
            }
            catch (PDIException pe) {
                PTPDebugCorePlugin.log(pe);
            }
            try {
                map.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(pdiBreakpoint.getCondition().getIgnoreCount()));
            }
            catch (PDIException e) {
                PTPDebugCorePlugin.log(e);
            }
            try {
                map.put("org.eclipse.ptp.debug.core.condition", pdiBreakpoint.getCondition().getExpression());
            }
            catch (PDIException e) {
                PTPDebugCorePlugin.log(e);
            }
            PDebugBreakpointInfo info = new PDebugBreakpointInfo(this.getSession().getDebugInfo(tasks), pdiBreakpoint.getBreakpointID(), map);
            this.getSession().fireDebugEvent(16, 16, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleDestroyedEvent(TaskSet tasks, IPDIBreakpoint pdiBreakpoint) {
        IPBreakpoint breakpoint = null;
        BreakpointMap breakpointMap = this.fBreakpointMap;
        synchronized (breakpointMap) {
            breakpoint = this.fBreakpointMap.getPBreakpoint(pdiBreakpoint);
            this.fBreakpointMap.removePDIBreakpoint(pdiBreakpoint);
        }
        if (breakpoint != null) {
            PDebugBreakpointInfo info = new PDebugBreakpointInfo(this.getSession().getDebugInfo(tasks), pdiBreakpoint.getBreakpointID());
            this.getSession().fireDebugEvent(8, 16, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleLocationBreakpointCreatedEvent(TaskSet tasks, IPDILocationBreakpoint pdiBreakpoint) {
        if (pdiBreakpoint.isTemporary()) {
            return;
        }
        IPBreakpoint breakpoint = null;
        BreakpointMap breakpointMap = this.fBreakpointMap;
        synchronized (breakpointMap) {
            breakpoint = this.fBreakpointMap.getPBreakpoint(pdiBreakpoint);
            if (breakpoint != null) {
                this.fBreakpointMap.put(breakpoint, pdiBreakpoint);
            }
        }
        if (breakpoint != null) {
            try {
                PDebugBreakpointInfo info = new PDebugBreakpointInfo(this.getSession().getDebugInfo(tasks), pdiBreakpoint.getBreakpointID());
                this.getSession().fireDebugEvent(4, 16, info);
                this.changeBreakpointProperties(breakpoint, pdiBreakpoint);
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleWatchpointCreatedEvent(TaskSet tasks, IPDIWatchpoint pdiWatchpoint) {
        IPBreakpoint breakpoint = null;
        BreakpointMap breakpointMap = this.fBreakpointMap;
        synchronized (breakpointMap) {
            breakpoint = this.fBreakpointMap.getPBreakpoint(pdiWatchpoint);
            if (breakpoint != null) {
                this.fBreakpointMap.put(breakpoint, pdiWatchpoint);
            }
        }
        if (breakpoint != null) {
            try {
                PDebugBreakpointInfo info = new PDebugBreakpointInfo(this.getSession().getDebugInfo(tasks), pdiWatchpoint.getBreakpointID());
                this.getSession().fireDebugEvent(4, 16, info);
                this.changeBreakpointProperties(breakpoint, pdiWatchpoint);
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.log(e);
            }
        }
    }

    private void doSkipBreakpoints(boolean enabled) {
        IPBreakpoint[] pBreakpoints;
        IPBreakpoint[] iPBreakpointArray = pBreakpoints = this.fBreakpointMap.getAllPBreakpoints();
        int n = pBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPBreakpoint bpt = iPBreakpointArray[n2];
            try {
                IPDIBreakpoint pdiBreakpoint;
                if (bpt.isEnabled() && (pdiBreakpoint = this.fBreakpointMap.getPDIBreakpoint(bpt)) != null) {
                    pdiBreakpoint.setEnabled(!enabled);
                }
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.log(e);
            }
            catch (PDIException e) {
                PTPDebugCorePlugin.log(e);
            }
            ++n2;
        }
    }

    private TaskSet getBreakpointTasks(IPBreakpoint pBpt) throws CoreException {
        String sid = pBpt.getSetId();
        if (sid.equals("Root")) {
            return this.session.getTasks();
        }
        TaskSet setTasks = this.session.getSetManager().getTasks(sid);
        if (setTasks != null) {
            return setTasks.copy();
        }
        IPDIBreakpoint pdiBpt = this.fBreakpointMap.getPDIBreakpoint(pBpt);
        if (pdiBpt == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, Messages.PBreakpointManager_0, null));
        }
        return pdiBpt.getTasks().copy();
    }

    private ISourceLocator getSourceLocator() {
        return this.getSession().getLaunch().getSourceLocator();
    }

    private void handleChangedEvent(IPDIChangedEvent event) {
        IPDISessionObject reason = event.getReason();
        if (reason instanceof IPDIBreakpointInfo) {
            this.doHandleChangedEvent(event.getTasks(), ((IPDIBreakpointInfo)reason).getBreakpoint());
        }
    }

    private void handleCreatedEvent(IPDICreatedEvent event) {
        IPDISessionObject reason = event.getReason();
        if (reason instanceof IPDIBreakpointInfo) {
            IPDIBreakpoint pdiBreakpoint = ((IPDIBreakpointInfo)reason).getBreakpoint();
            if (pdiBreakpoint instanceof IPDIWatchpoint) {
                this.doHandleWatchpointCreatedEvent(event.getTasks(), (IPDIWatchpoint)pdiBreakpoint);
            } else if (pdiBreakpoint instanceof IPDILocationBreakpoint) {
                this.doHandleLocationBreakpointCreatedEvent(event.getTasks(), (IPDILocationBreakpoint)pdiBreakpoint);
            }
            if (!pdiBreakpoint.isTemporary() && !DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
                this.changeBreakpointPropertiesOnSession(event.getTasks(), pdiBreakpoint, new Boolean(false), null);
            }
        }
    }

    private void handleDestroyedEvent(IPDIDestroyedEvent event) {
        IPDISessionObject reason = event.getReason();
        if (reason instanceof IPDIBreakpointInfo) {
            this.doHandleDestroyedEvent(event.getTasks(), ((IPDIBreakpointInfo)reason).getBreakpoint());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTargetBreakpoint(IBreakpoint breakpoint) {
        if (!(breakpoint instanceof IPBreakpoint)) return false;
        String bp_job_id = ((IPBreakpoint)breakpoint).getJobId();
        if (!bp_job_id.equals(this.getPDISession().getJobID()) && !bp_job_id.equals(IPBreakpoint.GLOBAL)) return false;
        if (breakpoint instanceof IPAddressBreakpoint) {
            return this.supportsAddressBreakpoint((IPAddressBreakpoint)breakpoint);
        }
        if (!(breakpoint instanceof IPLineBreakpoint)) return true;
        try {
            String handle = ((IPBreakpoint)breakpoint).getSourceHandle();
            ISourceLocator sl = this.getSourceLocator();
            if (sl instanceof IPSourceLocator) {
                return ((IPSourceLocator)sl).findSourceElement(handle) != null;
            }
            if (!(sl instanceof PSourceLookupDirector)) return true;
            return ((PSourceLookupDirector)sl).contains((IPBreakpoint)breakpoint);
        }
        catch (CoreException coreException) {
            try {
                return false;
            }
            catch (CoreException coreException2) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteBreakpointsOnSession0(IPBreakpoint[] breakpoints) {
        IPDIBreakpointManager pdiBptMgr = this.getPDISession().getBreakpointManager();
        IPBreakpoint[] iPBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPBreakpoint breakpoint = iPBreakpointArray[n2];
            IPDIBreakpoint pdiBreakpoint = null;
            BreakpointMap breakpointMap = this.fBreakpointMap;
            synchronized (breakpointMap) {
                pdiBreakpoint = this.fBreakpointMap.getPDIBreakpoint(breakpoint);
            }
            if (pdiBreakpoint != null) {
                try {
                    pdiBreakpoint.getPendingTasks().or(this.getBreakpointTasks(breakpoint));
                    pdiBptMgr.deleteBreakpoint(pdiBreakpoint.getPendingTasks(), pdiBreakpoint);
                }
                catch (PDIException e) {
                    PTPDebugCorePlugin.log(e);
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.log(e);
                }
            }
            ++n2;
        }
    }

    protected IPDISession getPDISession() {
        return this.getSession().getPDISession();
    }

    protected Object getSourceElement(String file) {
        Object sourceElement = null;
        ISourceLocator locator = this.getSourceLocator();
        if (locator instanceof IPSourceLocator || locator instanceof PSourceLookupDirector) {
            sourceElement = locator instanceof IPSourceLocator ? ((IPSourceLocator)locator).findSourceElement(file) : ((PSourceLookupDirector)locator).getSourceElement(file);
        }
        return sourceElement;
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }

    protected void setBreakpointsOnSession0(IPBreakpoint[] breakpoints) {
        IPDIBreakpointManager pdiBptMgr = this.getPDISession().getBreakpointManager();
        IPBreakpoint[] iPBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPBreakpoint bpt = iPBreakpointArray[n2];
            try {
                IPDICondition condition;
                IPDICondition condition2;
                IPDIFileLocation location;
                IPLineBreakpoint breakpoint;
                IPDIBreakpoint b = null;
                if (bpt instanceof IPFunctionBreakpoint) {
                    breakpoint = (IPFunctionBreakpoint)bpt;
                    String function = breakpoint.getFunction();
                    String fileName = breakpoint.getFileName();
                    location = pdiBptMgr.createFunctionLocation(fileName, function);
                    condition2 = this.createCondition(breakpoint);
                    b = pdiBptMgr.setFunctionBreakpoint(this.getBreakpointTasks(bpt), 0, (IPDIFunctionLocation)location, condition2, true, bpt.isEnabled());
                } else if (bpt instanceof IPAddressBreakpoint) {
                    breakpoint = (IPAddressBreakpoint)bpt;
                    String address = breakpoint.getAddress();
                    IPDIAddressLocation location2 = pdiBptMgr.createAddressLocation(new BigInteger(address.startsWith("0x") ? address.substring(2) : address, 16));
                    condition = this.createCondition(breakpoint);
                    b = pdiBptMgr.setAddressBreakpoint(this.getBreakpointTasks(bpt), 0, location2, condition, true, bpt.isEnabled());
                } else if (bpt instanceof IPLineBreakpoint) {
                    breakpoint = (IPLineBreakpoint)bpt;
                    String handle = breakpoint.getSourceHandle();
                    IPath path = this.convertPath(handle);
                    location = pdiBptMgr.createLineLocation(path.toPortableString(), breakpoint.getLineNumber());
                    condition2 = this.createCondition(breakpoint);
                    b = pdiBptMgr.setLineBreakpoint(this.getBreakpointTasks(bpt), 0, (IPDILineLocation)location, condition2, true, bpt.isEnabled());
                } else if (bpt instanceof IPWatchpoint) {
                    IPWatchpoint watchpoint = (IPWatchpoint)bpt;
                    int accessType = 0;
                    accessType |= watchpoint.isWriteType() ? 1 : 0;
                    int n3 = watchpoint.isReadType() ? 2 : 0;
                    String expression = watchpoint.getExpression();
                    condition = this.createCondition(watchpoint);
                    b = pdiBptMgr.setWatchpoint(this.getBreakpointTasks(bpt), 0, accessType |= n3, expression, condition, bpt.isEnabled());
                }
                if (b != null) {
                    this.fBreakpointMap.put(bpt, b);
                }
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.log(e);
            }
            catch (PDIException e) {
                PTPDebugCorePlugin.log(e);
            }
            ++n2;
        }
    }

    private class BreakpointMap {
        private final Map<String, IPBreakpoint> fPBreakpoints = new HashMap<String, IPBreakpoint>(10);
        private final Map<String, IPDIBreakpoint> fPDIBreakpoints = new HashMap<String, IPDIBreakpoint>(10);

        protected BreakpointMap() {
        }

        public void dispose() {
            this.fPBreakpoints.clear();
            this.fPDIBreakpoints.clear();
        }

        public IPBreakpoint[] getAllPBreakpoints() {
            Collection<IPBreakpoint> collection = this.fPBreakpoints.values();
            return collection.toArray(new IPBreakpoint[collection.size()]);
        }

        public IPBreakpoint getPBreakpoint(IPDIBreakpoint pdiBpt) {
            IPBreakpoint breakpoint = this.fPBreakpoints.get(String.valueOf(pdiBpt.getInternalID()));
            if (breakpoint == null) {
                IPBreakpoint[] bpts;
                IPBreakpoint[] iPBreakpointArray = bpts = this.getAllPBreakpoints();
                int n = bpts.length;
                int n2 = 0;
                while (n2 < n) {
                    IPBreakpoint bpt = iPBreakpointArray[n2];
                    if (this.isSameBreakpoint(bpt, pdiBpt)) {
                        this.fPBreakpoints.put(String.valueOf(pdiBpt.getInternalID()), bpt);
                        breakpoint = bpt;
                        break;
                    }
                    ++n2;
                }
            }
            return breakpoint;
        }

        public IPDIBreakpoint getPDIBreakpoint(IPBreakpoint pBpt) {
            return this.fPDIBreakpoints.get(String.valueOf(pBpt.getMarker().getId()));
        }

        public void put(IPBreakpoint pBpt, IPDIBreakpoint pdiBpt) {
            this.fPBreakpoints.put(String.valueOf(pdiBpt.getInternalID()), pBpt);
            this.fPDIBreakpoints.put(String.valueOf(pBpt.getMarker().getId()), pdiBpt);
        }

        public void removePDIBreakpoint(IPDIBreakpoint pdiBpt) {
            IPBreakpoint pBpt;
            if (pdiBpt != null && (pBpt = this.fPBreakpoints.remove(String.valueOf(pdiBpt.getInternalID()))) != null) {
                this.fPDIBreakpoints.remove(String.valueOf(pBpt.getMarker().getId()));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isSameBreakpoint(IPBreakpoint breakpoint, IPDIBreakpoint pdiBreakpoint) {
            try {
                if (breakpoint instanceof IPFunctionBreakpoint && pdiBreakpoint instanceof IPDIFunctionBreakpoint) {
                    if (((IPFunctionBreakpoint)breakpoint).getFunction().compareTo(((IPDIFunctionBreakpoint)pdiBreakpoint).getLocator().getFunction()) != 0) return false;
                    return true;
                }
                if (breakpoint instanceof IPAddressBreakpoint && pdiBreakpoint instanceof IPDIAddressBreakpoint) {
                    return ((IPAddressBreakpoint)breakpoint).getAddress().equals(((IPDIAddressBreakpoint)pdiBreakpoint).getLocator().getAddress());
                }
                if (breakpoint instanceof IPLineBreakpoint && pdiBreakpoint instanceof IPDILineBreakpoint) {
                    String file;
                    IPDILocator location = ((IPDILineBreakpoint)pdiBreakpoint).getLocator();
                    String sourceHandle = file = location.getFile();
                    if (!PBreakpointManager.this.isEmpty(file)) {
                        Object sourceElement = PBreakpointManager.this.getSourceElement(file);
                        if (sourceElement instanceof IFile) {
                            sourceHandle = ((IFile)sourceElement).getLocationURI().getPath();
                        } else if (sourceElement instanceof IStorage) {
                            sourceHandle = ((IStorage)sourceElement).getFullPath().toOSString();
                        }
                        String bpSourceHandle = ((IPLineBreakpoint)breakpoint).getSourceHandle();
                        if (sourceElement instanceof LocalFileStorage) {
                            try {
                                bpSourceHandle = new File(bpSourceHandle).getCanonicalPath();
                            }
                            catch (IOException iOException) {
                                return false;
                            }
                        }
                        if (!sourceHandle.equals(bpSourceHandle)) return false;
                        if (location.getLineNumber() != ((IPLineBreakpoint)breakpoint).getLineNumber()) return false;
                        return true;
                    }
                }
                if (!(breakpoint instanceof IPWatchpoint)) return false;
                if (!(pdiBreakpoint instanceof IPDIWatchpoint)) return false;
                try {
                    IPWatchpoint watchpoint = (IPWatchpoint)breakpoint;
                    IPDIWatchpoint pdiWatchpoint = (IPDIWatchpoint)pdiBreakpoint;
                    if (watchpoint.getExpression().compareTo(pdiWatchpoint.getWatchExpression()) != 0) return false;
                    if (watchpoint.isReadType() != pdiWatchpoint.isReadType()) return false;
                    if (watchpoint.isWriteType() != pdiWatchpoint.isWriteType()) return false;
                    return true;
                }
                catch (PDIException pDIException) {
                    return false;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
    }
}

