/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class SemanticQueries {
    public static boolean isCopyOrMoveConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveConstructorKind.COPY_OR_MOVE);
    }

    public static boolean isMoveConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveConstructorKind.MOVE);
    }

    public static boolean isCopyConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveConstructorKind.COPY);
    }

    private static boolean isCopyOrMoveConstructor(ICPPConstructor constructor, CopyOrMoveConstructorKind kind) {
        if (constructor instanceof ICPPFunctionTemplate) {
            return false;
        }
        if (!SemanticQueries.isCallableWithNumberOfArguments(constructor, 1)) {
            return false;
        }
        IType firstArgumentType = constructor.getType().getParameterTypes()[0];
        if (!((firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 1)) instanceof ICPPReferenceType)) {
            return false;
        }
        ICPPReferenceType firstArgReferenceType = (ICPPReferenceType)firstArgumentType;
        boolean isRvalue = firstArgReferenceType.isRValueReference();
        if (isRvalue && kind == CopyOrMoveConstructorKind.COPY) {
            return false;
        }
        if (!isRvalue && kind == CopyOrMoveConstructorKind.MOVE) {
            return false;
        }
        firstArgumentType = firstArgReferenceType.getType();
        firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 8);
        return firstArgumentType.isSameType(constructor.getClassOwner());
    }

    private static boolean isCallableWithNumberOfArguments(ICPPFunction function, int numArguments) {
        return function.getParameters().length >= numArguments && function.getRequiredArgumentCount() <= numArguments;
    }

    private static enum CopyOrMoveConstructorKind {
        COPY,
        MOVE,
        COPY_OR_MOVE;

    }
}

