/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ssh.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHCommandLauncher;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHFileProxy;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.IRemoteProxyManager;

public class SSHProxyManager
implements IRemoteProxyManager {
    public IRemoteFileProxy getFileProxy(URI uri) {
        return new SSHFileProxy(uri);
    }

    public IRemoteFileProxy getFileProxy(IProject project) {
        return new SSHFileProxy(project.getLocationURI());
    }

    public IRemoteCommandLauncher getLauncher(URI uri) {
        return new SSHCommandLauncher(uri);
    }

    public IRemoteCommandLauncher getLauncher(IProject project) {
        return new SSHCommandLauncher(project.getLocationURI());
    }

    public String getOS(URI uri) throws CoreException {
        SSHCommandLauncher cmdLauncher = new SSHCommandLauncher(uri);
        Process p = cmdLauncher.execute((IPath)new Path("/bin/uname"), new String[]{"-s"}, new String[0], null, null);
        String os = "";
        try {
            InputStream in = p.getInputStream();
            int exit = p.waitFor();
            if (exit == 0) {
                int len;
                byte[] bytes = new byte[15];
                while ((len = in.read(bytes)) != -1) {
                    os = String.valueOf(os) + new String(bytes, 0, len);
                }
                os = os.substring(0, os.indexOf("\n"));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {}
        return os;
    }

    public String getOS(IProject project) throws CoreException {
        URI uri = project.getLocationURI();
        return this.getOS(uri);
    }
}

