/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.ui.editor.actions.file.NewFileAction;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class AddStapProbe
extends AbstractRulerActionDelegate {
    protected IAction createAction(final ITextEditor editor, final IVerticalRulerInfo rulerInfo) {
        return new Action(){

            public void runWithEvent(Event event) {
                Shell shell = editor.getSite().getShell();
                shell.setCursor(shell.getDisplay().getSystemCursor(1));
                int lineno = rulerInfo.getLineOfLastMouseButtonActivity();
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                String s = document.get();
                String[] lines = s.split("\n");
                String line = lines[lineno].trim();
                boolean die = false;
                if (line.isEmpty()) {
                    die = true;
                }
                if (line.startsWith("#")) {
                    die = true;
                }
                if (line.startsWith("//")) {
                    die = true;
                }
                if (line.startsWith("/*") && !line.contains("*/") && !line.endsWith("*/")) {
                    die = true;
                }
                try {
                    ArrayList<Integer> commentChunks = new ArrayList<Integer>();
                    char[] chars = s.toCharArray();
                    int needle = 1;
                    int offset = document.getLineOffset(lineno);
                    while (needle < chars.length) {
                        if (chars[needle - 1] == '/' && chars[needle] == '*') {
                            commentChunks.add(needle);
                            while (needle < chars.length) {
                                if (chars[needle - 1] == '*' && chars[needle] == '/') {
                                    commentChunks.add(needle);
                                    ++needle;
                                    break;
                                }
                                ++needle;
                            }
                        }
                        ++needle;
                    }
                    int i = 0;
                    while (i < commentChunks.size()) {
                        if ((Integer)commentChunks.get(i) >= offset) {
                            int pair = i - i % 2;
                            int start = (Integer)commentChunks.get(pair);
                            int end = (Integer)commentChunks.get(pair + 1);
                            if (offset >= start && offset <= end) {
                                die = true;
                            }
                        }
                        ++i;
                    }
                }
                catch (BadLocationException excp) {
                    ExceptionErrorDialog.openError((String)Localization.getString("AddStapProbe.UnableToInsertProbe"), (Exception)((Object)excp));
                }
                if (die) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("CEditor.ProbeInsertFailed"), (String)Localization.getString("CEditor.CanNotProbeLine"));
                } else {
                    IEditorInput in = editor.getEditorInput();
                    if (in instanceof FileStoreEditorInput) {
                        FileStoreEditorInput input = (FileStoreEditorInput)in;
                        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
                        String kernroot = p.getString("KernelSourcePreference");
                        String filepath = input.getURI().getPath();
                        String kernrelative = filepath.substring(kernroot.length() + 1, filepath.length());
                        StringBuffer sb = new StringBuffer();
                        sb.append("probe kernel.statement(\"*@" + kernrelative + ":" + (lineno + 1) + "\")");
                        sb.append("\n{\n\t\n}\n");
                        STPEditor activeSTPEditor = IDESessionSettings.getActiveSTPEditor();
                        if (activeSTPEditor == null) {
                            NewFileAction action = new NewFileAction();
                            action.run();
                            IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                            if (ed instanceof STPEditor) {
                                IDESessionSettings.setActiveSTPEditor((STPEditor)ed);
                            }
                        }
                        if (activeSTPEditor != null) {
                            activeSTPEditor.insertText(sb.toString());
                        }
                    }
                }
                shell.setCursor(null);
            }
        };
    }
}

