/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions;

import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.StapErrorParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpClient;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.preferences.EnvironmentVariablesPreferencePage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public class RunScriptHandler
extends AbstractHandler {
    protected boolean continueRun = true;
    private boolean runLocal = true;
    private String fileName = null;
    private String tmpfileName = null;
    private String serverfileName = null;
    private IPath path;
    private List<String> cmdList = new ArrayList<String>();

    public void setPath(IPath path) {
        this.path = path;
    }

    public Object execute(ExecutionEvent event) {
        if (this.isValid()) {
            if (!this.getRunLocal()) {
                try {
                    ScpClient scpclient = new ScpClient();
                    this.serverfileName = this.fileName.substring(this.fileName.lastIndexOf(47) + 1);
                    this.tmpfileName = "/tmp/" + this.serverfileName;
                    scpclient.transfer(this.fileName, this.tmpfileName);
                }
                catch (JSchException jSchException) {
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("RunScriptHandler.serverError"), (String)Localization.getString("RunScriptHandler.serverError"), (IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", Localization.getString("RunScriptHandler.checkCredentials")));
                    return null;
                }
                catch (IOException e) {
                    ExceptionErrorDialog.openError((String)Localization.getString("RunScriptHandler.ioError"), (Exception)e);
                    return null;
                }
            }
            final String[] script = this.buildStandardScript();
            final String[] envVars = this.getEnvironmentVariables();
            if (this.continueRun) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScriptConsole console;
                        if (!RunScriptHandler.this.getRunLocal()) {
                            console = ScriptConsole.getInstance((String)RunScriptHandler.this.serverfileName);
                            console.run(script, envVars, (IErrorParser)new StapErrorParser());
                        } else {
                            console = ScriptConsole.getInstance((String)RunScriptHandler.this.fileName);
                            console.runLocally(script, envVars, (IErrorParser)new StapErrorParser());
                        }
                        RunScriptHandler.this.scriptConsoleInitialized(console);
                    }
                });
            }
        }
        return null;
    }

    protected void scriptConsoleInitialized(ScriptConsole console) {
    }

    protected String getFilePath() {
        if (this.path != null) {
            return this.path.toOSString();
        }
        IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (ed.getEditorInput() instanceof PathEditorInput) {
            return ((PathEditorInput)ed.getEditorInput()).getPath().toString();
        }
        return ResourceUtil.getFile((IEditorInput)ed.getEditorInput()).getLocation().toString();
    }

    private boolean isValid() {
        IEditorPart ed;
        if (this.path == null && !this.isValidEditor(ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor())) {
            return false;
        }
        return this.getFilePath().endsWith(".stp") && this.isValidDirectory(this.getFilePath());
    }

    private boolean isValidEditor(IEditorPart ed) {
        if (ed == null) {
            String msg = MessageFormat.format(Localization.getString("RunScriptAction.NoScriptFile"), null);
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("RunScriptAction.Problem"), (String)msg);
            return false;
        }
        if (ed.isDirty()) {
            ed.doSave((IProgressMonitor)new ProgressMonitorPart((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Layout)new FillLayout()));
        }
        return true;
    }

    private boolean isValidDirectory(String fileName) {
        this.fileName = fileName;
        if (IDESessionSettings.tapsetLocation.trim().length() == 0) {
            TapsetLibrary.getTapsetLocation(IDEPlugin.getDefault().getPreferenceStore());
        }
        if (fileName.contains(IDESessionSettings.tapsetLocation)) {
            String msg = MessageFormat.format(Localization.getString("RunScriptAction.TapsetDirectoryRun"), null);
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("RunScriptAction.Error"), (String)msg);
            return false;
        }
        return true;
    }

    public void addComandLineOptions(String option) {
        this.cmdList.add(option);
    }

    protected String[] buildStandardScript() {
        this.getImportedTapsets(this.cmdList);
        if (this.isGuru()) {
            this.cmdList.add("-g");
        }
        return this.finalizeScript(this.cmdList);
    }

    protected void getImportedTapsets(List<String> cmdList) {
        IPreferenceStore preferenceStore = IDEPlugin.getDefault().getPreferenceStore();
        String[] tapsets = preferenceStore.getString("TapsetPreference").split(File.pathSeparator);
        if (tapsets != null && tapsets.length > 0 && tapsets[0].trim().length() > 0) {
            int i = 0;
            while (i < tapsets.length) {
                cmdList.add("-I");
                cmdList.add(tapsets[i]);
                ++i;
            }
        }
    }

    private boolean isGuru() {
        try {
            File f = new File(this.fileName);
            FileReader fr = new FileReader(f);
            int curr = 0;
            int prev = 0;
            boolean front = false;
            boolean imbedded = false;
            boolean inLineComment = false;
            boolean inBlockComment = false;
            while (-1 != (curr = fr.read())) {
                if (!inLineComment && !inBlockComment && 37 == prev && 123 == curr) {
                    front = true;
                } else {
                    if (!inLineComment && !inBlockComment && 37 == prev && 125 == curr && front) {
                        imbedded = true;
                        break;
                    }
                    if (!inBlockComment && (47 == prev && 47 == curr || 35 == curr)) {
                        inLineComment = true;
                    } else if (!inLineComment && 47 == prev && 42 == curr) {
                        inBlockComment = true;
                    } else if (10 == curr) {
                        inLineComment = false;
                    } else if (42 == prev && 47 == curr) {
                        inBlockComment = false;
                    }
                }
                prev = curr;
            }
            fr.close();
            if (imbedded) {
                return true;
            }
        }
        catch (FileNotFoundException fnfe) {
            ExceptionErrorDialog.openError((String)Localization.getString("RunScriptHandler.couldNotOpenScriptFile"), (Exception)fnfe);
        }
        catch (IOException ie) {
            ExceptionErrorDialog.openError((String)Localization.getString("RunScriptHandler.fileIOError"), (Exception)ie);
        }
        return false;
    }

    protected String[] finalizeScript(List<String> cmdList) {
        String modname;
        String[] script = new String[cmdList.size() + 4];
        script[0] = "stap";
        script[script.length - 1] = !this.getRunLocal() ? this.tmpfileName : this.fileName;
        int i = 0;
        while (i < cmdList.size()) {
            script[i + 1] = cmdList.get(i).toString();
            ++i;
        }
        script[script.length - 3] = "-m";
        if (!this.getRunLocal()) {
            modname = this.serverfileName.substring(0, this.serverfileName.lastIndexOf(".stp"));
        } else {
            modname = this.fileName.substring(this.fileName.lastIndexOf(47) + 1);
            modname = modname.substring(0, modname.lastIndexOf(".stp"));
        }
        Pattern validModName = Pattern.compile("^[a-z0-9_A-Z]+$");
        Matcher modNameMatch = validModName.matcher(modname);
        if (!modNameMatch.matches()) {
            this.continueRun = false;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    MessageDialog.openError((Shell)parent, (String)Messages.ScriptRunAction_InvalidScriptTitle, (String)Messages.ScriptRunAction_InvalidScriptTMessage);
                }
            });
            return new String[0];
        }
        script[script.length - 2] = modname;
        return script;
    }

    private String[] getEnvironmentVariables() {
        return EnvironmentVariablesPreferencePage.getEnvironmentVariables();
    }

    public boolean isEnabled() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof STPEditor;
    }

    public void setLocalScript(boolean enabled) {
        this.runLocal = enabled;
    }

    private boolean getRunLocal() {
        return this.runLocal;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

