/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.KernelSourceAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.KernelSourceTree;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;

public class KernelBrowserView
extends BrowserView {
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.views.KernelBrowserView";
    private KernelSourceAction doubleClickAction;
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("KernelSourcePreference") || event.getProperty().equals("RemoteLocalKernelSource") || event.getProperty().equals("ExcludedKernelSource")) {
                KernelBrowserView.this.refresh();
            }
        }
    };

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.refresh();
        this.makeActions();
    }

    public void makeActions() {
        this.doubleClickAction = new KernelSourceAction(this.getSite().getWorkbenchWindow(), this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
        IDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void refresh() {
        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        String kernelSource = p.getString("KernelSourcePreference");
        if (kernelSource == null || kernelSource.length() < 1) {
            this.showBrowserErrorMessage(Localization.getString("KernelBrowserView.NoKernelSourceFound"));
            return;
        }
        String localOrRemote = p.getString("RemoteLocalKernelSource");
        URI kernelLocationURI = null;
        IRemoteFileProxy proxy = null;
        boolean remote = localOrRemote.equals("remote");
        if (remote) {
            boolean error = false;
            try {
                kernelLocationURI = IDEPlugin.getDefault().createRemoteUri(kernelSource);
                if (kernelLocationURI == null) {
                    error = true;
                } else {
                    proxy = RemoteProxyManager.getInstance().getFileProxy(kernelLocationURI);
                    if (!this.validateProxy(proxy, kernelSource)) {
                        error = true;
                    }
                }
            }
            catch (CoreException coreException) {
                error = true;
            }
            if (error) {
                this.showBrowserErrorMessage(Localization.getString("KernelBrowserView.KernelSourceDirNotFound"));
                return;
            }
        }
        KernelRefreshJob refreshJob = new KernelRefreshJob(remote, kernelLocationURI, proxy, kernelSource);
        refreshJob.setUser(true);
        refreshJob.setPriority(20);
        refreshJob.schedule();
    }

    private boolean validateProxy(IRemoteFileProxy proxy, String kernelSource) {
        if (proxy == null) {
            return false;
        }
        IFileStore fs = proxy.getResource(kernelSource);
        if (fs == null) {
            return false;
        }
        IFileInfo info = fs.fetchInfo();
        if (info == null) {
            return false;
        }
        return info.exists();
    }

    private void showBrowserErrorMessage(String message) {
        TreeNode t = new TreeNode((Object)"", "", false);
        t.add(new TreeNode((Object)"", message, false));
        this.viewer.setInput((Object)t);
    }

    @Override
    public void dispose() {
        super.dispose();
        IDEPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        if (this.viewer != null) {
            this.viewer.removeDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
        }
        if (this.doubleClickAction != null) {
            this.doubleClickAction.dispose();
        }
        this.doubleClickAction = null;
    }

    private class KernelRefreshJob
    extends Job {
        private boolean remote;
        private URI kernelLocationURI;
        private IRemoteFileProxy proxy;
        private String kernelSource;

        public KernelRefreshJob(boolean remote, URI kernelLocationURI, IRemoteFileProxy proxy, String kernelSource) {
            super(Localization.getString("KernelBrowserView.RefreshingKernelSource"));
            this.remote = remote;
            this.kernelLocationURI = kernelLocationURI;
            this.proxy = proxy;
            this.kernelSource = kernelSource;
        }

        public IStatus run(IProgressMonitor monitor) {
            IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
            KernelSourceTree kst = new KernelSourceTree();
            String[] excluded = p.getString("ExcludedKernelSource").split(File.pathSeparator);
            if (this.remote) {
                try {
                    kst.buildKernelTree(this.kernelLocationURI, excluded, this.proxy, monitor);
                }
                catch (CoreException e) {
                    ExceptionErrorDialog.openError((String)Localization.getString("KernelBrowserView.CouldNotInitializeTree"), (Exception)((Object)e));
                }
            } else {
                kst.buildKernelTree(this.kernelSource, excluded);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            UpdateKernelBrowserJob job = new UpdateKernelBrowserJob(kst);
            job.schedule();
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    private class UpdateKernelBrowserJob
    extends UIJob {
        KernelSourceTree kst;

        public UpdateKernelBrowserJob(KernelSourceTree kst) {
            super(Localization.getString("KernelBrowserView.UpdateKernelBrowser"));
            this.kst = kst;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            monitor.beginTask(Localization.getString("KernelBrowserView.UpdateKernelBrowser"), 100);
            if (this.kst == null) {
                return Status.OK_STATUS;
            }
            KernelBrowserView.this.viewer.setInput((Object)this.kst.getTree());
            this.kst.dispose();
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

