/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventField;

final class CTFIntegerArrayField
extends CtfTmfEventField {
    private final int base;
    private final boolean signed;
    private String formattedValue = null;

    CTFIntegerArrayField(String name, List<Long> longValues, int base, boolean signed) {
        super(name, longValues, null);
        this.base = base;
        this.signed = signed;
    }

    @Override
    public List<Long> getValue() {
        return (List)super.getValue();
    }

    @Override
    public String getFormattedValue() {
        if (this.formattedValue == null) {
            ArrayList<String> strings = new ArrayList<String>();
            Iterator iterator = this.getValue().iterator();
            while (iterator.hasNext()) {
                Long value = (Long)iterator.next();
                strings.add(CTFIntegerArrayField.formatNumber(value, this.base, this.signed));
            }
            this.formattedValue = ((Object)strings).toString();
        }
        return this.formattedValue;
    }
}

