/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.actions.MoveXSDBaseAction;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.w3c.dom.Node;

public class MoveXSDElementAction
extends MoveXSDBaseAction {
    private static int INSERT_BEFORE = 0;
    private static int INSERT_AFTER = 1;
    private static int INSERT_DIRECT = 2;
    protected List selectedNodes;
    protected Node parentNode;
    protected Node previousRefChild;
    protected Node nextRefChild;
    int insertType;
    XSDModelGroup parentModelGroup;
    XSDConcreteComponent selected;
    XSDConcreteComponent previousRefComponent;
    XSDConcreteComponent nextRefComponent;
    boolean insertAtEnd = true;

    public MoveXSDElementAction(XSDModelGroup parentComponent, XSDConcreteComponent selected, XSDConcreteComponent previousRefChildComponent, XSDConcreteComponent nextRefChildComponent) {
        this.parentModelGroup = parentComponent;
        this.selected = selected;
        this.previousRefComponent = previousRefChildComponent;
        this.nextRefComponent = nextRefChildComponent;
        if (parentComponent == null) {
            return;
        }
        this.parentNode = parentComponent.getElement();
        this.nextRefChild = nextRefChildComponent != null ? nextRefChildComponent.getElement() : null;
        Node node = this.previousRefChild = previousRefChildComponent != null ? previousRefChildComponent.getElement() : null;
        if (this.nextRefComponent != null && this.nextRefComponent.getContainer().getContainer() == this.parentModelGroup) {
            this.insertType = INSERT_BEFORE;
        }
        if (this.previousRefComponent != null && this.previousRefComponent.getContainer().getContainer() == this.parentModelGroup) {
            this.insertType = INSERT_AFTER;
        }
        if (nextRefChildComponent == null && previousRefChildComponent == null) {
            this.insertType = INSERT_DIRECT;
        }
    }

    public MoveXSDElementAction(XSDModelGroup parentComponent, XSDConcreteComponent selected, XSDConcreteComponent previousRefChildComponent, XSDConcreteComponent nextRefChildComponent, boolean insertAtEnd) {
        this(parentComponent, selected, previousRefChildComponent, nextRefChildComponent);
        this.insertAtEnd = insertAtEnd;
    }

    public boolean canMove() {
        boolean result = true;
        if (this.nextRefComponent instanceof XSDAttributeDeclaration || this.previousRefComponent instanceof XSDAttributeDeclaration || this.parentModelGroup == null) {
            return false;
        }
        return result;
    }

    public void run() {
        int originalIndex = 0;
        Iterator particles = this.parentModelGroup.getContents().iterator();
        while (particles.hasNext()) {
            XSDParticle particle = (XSDParticle)particles.next();
            XSDParticleContent particleContent = particle.getContent();
            if (particleContent == this.selected) {
                this.parentModelGroup.getContents().remove((Object)particle);
                break;
            }
            ++originalIndex;
        }
        int index = 0;
        boolean addedBack = false;
        if (this.insertType == INSERT_DIRECT) {
            XSDConcreteComponent container = this.selected.getContainer();
            if (container != null) {
                XSDConcreteComponent container2 = container.getContainer();
                if (container2 instanceof XSDModelGroup) {
                    ((XSDModelGroup)container2).getContents().remove((Object)container);
                }
                if (this.insertAtEnd) {
                    this.parentModelGroup.getContents().add((Object)container);
                } else {
                    this.parentModelGroup.getContents().add(0, (Object)container);
                }
                addedBack = true;
            }
            return;
        }
        EList particles2 = this.parentModelGroup.getContents();
        Iterator iterator = particles2.iterator();
        while (iterator.hasNext()) {
            XSDParticle particle = (XSDParticle)iterator.next();
            XSDParticleContent particleContent = particle.getContent();
            if (this.insertType == INSERT_BEFORE) {
                if (particleContent == this.nextRefComponent) {
                    this.parentModelGroup.getContents().add(index, (Object)this.selected.getContainer());
                    addedBack = true;
                    break;
                }
                if (this.selected == this.nextRefComponent && originalIndex == index) {
                    this.parentModelGroup.getContents().add(index, (Object)this.selected.getContainer());
                    addedBack = true;
                    break;
                }
            } else if (this.insertType == INSERT_AFTER) {
                if (particleContent == this.previousRefComponent) {
                    this.parentModelGroup.getContents().add(index + 1, (Object)this.selected.getContainer());
                    addedBack = true;
                    break;
                }
                if (this.selected == this.previousRefComponent && originalIndex == index) {
                    this.parentModelGroup.getContents().add(index, (Object)this.selected.getContainer());
                    addedBack = true;
                    break;
                }
            }
            ++index;
        }
        if (particles2.size() == 0) {
            this.parentModelGroup.getContents().add((Object)this.selected.getContainer());
            addedBack = true;
        }
        if (!addedBack) {
            this.parentModelGroup.getContents().add(originalIndex, (Object)this.selected.getContainer());
        }
    }
}

