/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.datadisplay;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.GraphingAPIUIPlugin;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.filters.IDataSetFilter;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter.AvailableFilterTypes;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter.SelectFilterWizard;
import org.eclipse.linuxtools.systemtap.structures.IFormattingStyles;
import org.eclipse.linuxtools.systemtap.structures.StringFormatter;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DataGrid
implements IUpdateListener {
    protected IDataSet dataSet;
    protected IFilteredDataSet filteredDataSet;
    protected IFormattingStyles[] columnFormat;
    protected int removedItems;
    protected Table table;
    protected Point clickLocation;
    protected IPreferenceStore prefs = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
    protected boolean manualResize = !this.prefs.getBoolean("AutoResizeColumns");
    protected Menu filterMenu;
    protected int style;
    public static final int NONE = 0;
    public static final int FULL_UPDATE = 1;

    public DataGrid(Composite composite, IDataSet set, int style) {
        this.dataSet = set;
        this.filteredDataSet = this.dataSet instanceof IFilteredDataSet ? (IFilteredDataSet)this.dataSet : DataSetFactory.createFilteredDataSet(this.dataSet);
        this.style = style;
        this.clickLocation = new Point(-1, -1);
        this.removedItems = 0;
        this.createPartControl(composite);
    }

    public void setLayoutData(Object data) {
        this.table.setLayoutData(data);
    }

    public IDataSet getDataSet() {
        return this.dataSet;
    }

    public Control getControl() {
        return this.table;
    }

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 65540);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.getVerticalBar().setVisible(true);
        String[] names = this.dataSet.getTitles();
        TableColumn column = new TableColumn(this.table, 16384);
        column.setText(Localization.getString("DataGrid.Row"));
        column.pack();
        column.setMoveable(false);
        column.setResizable(false);
        this.columnFormat = new IFormattingStyles[names.length];
        int i = 0;
        while (i < names.length) {
            column = new TableColumn(this.table, 16384);
            column.setText(names[i]);
            column.pack();
            column.setMoveable(true);
            this.columnFormat[i] = new StringFormatter();
            ++i;
        }
        this.table.setMenu(this.initMenus());
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                DataGrid.this.clickLocation.x = event.x;
                DataGrid.this.clickLocation.y = event.y;
            }
        });
        this.handleUpdateEvent();
    }

    public Menu initMenus() {
        int i;
        Menu menu = new Menu((Decorations)this.table.getShell(), 8);
        menu.addMenuListener((MenuListener)new MainMenuListener());
        Menu formatMenu = new Menu(menu);
        MenuItem item = new MenuItem(menu, 64);
        item.setText(Localization.getString("DataGrid.FormatAs"));
        item.setMenu(formatMenu);
        this.filterMenu = new Menu(menu);
        item = new MenuItem(menu, 64);
        item.setText(Localization.getString("DataGrid.AddFilter"));
        item.addSelectionListener((SelectionListener)new AddFilterSelection());
        item = new MenuItem(menu, 64);
        item.setText(Localization.getString("DataGrid.RemoveFilter"));
        item.setMenu(this.filterMenu);
        IDataSetFilter[] filters = this.filteredDataSet.getFilters();
        if (filters != null) {
            i = 0;
            while (i < filters.length) {
                item = new MenuItem(this.filterMenu, 64);
                item.setText(AvailableFilterTypes.getFilterName(filters[i].getID()));
                item.setData((Object)filters[i]);
                item.addSelectionListener((SelectionListener)new RemoveFilterSelection());
                ++i;
            }
        }
        item = new MenuItem(menu, 32);
        item.setText(Localization.getString("DataGrid.ManualyResize"));
        item.addSelectionListener((SelectionListener)new MenuManualyResizedSelection());
        i = 0;
        while (i < IFormattingStyles.FORMAT_TITLES.length) {
            item = new MenuItem(formatMenu, 16);
            item.setText(IFormattingStyles.FORMAT_TITLES[i]);
            item.addSelectionListener((SelectionListener)new MenuFormatSelection());
            ++i;
        }
        formatMenu.addMenuListener((MenuListener)new FormatMenuListener());
        return menu;
    }

    private int getSelectedColumn() {
        TableColumn[] cols = this.table.getColumns();
        int location = 0;
        int i = 0;
        while (i < cols.length) {
            if (this.clickLocation.x > location && this.clickLocation.x < (location += cols[i].getWidth())) {
                return i;
            }
            ++i;
        }
        return cols.length - 1;
    }

    public void handleUpdateEvent() {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int startLocation;
                int endLocation = DataGrid.this.filteredDataSet.getRowCount();
                if (1 == (DataGrid.this.style & 1)) {
                    DataGrid.this.removedItems += DataGrid.this.table.getItemCount();
                    DataGrid.this.table.removeAll();
                    startLocation = 0;
                } else {
                    startLocation = DataGrid.this.table.getItemCount() + DataGrid.this.removedItems;
                }
                int i = startLocation;
                while (i < endLocation) {
                    TableItem item = new TableItem(DataGrid.this.table, 0);
                    Object[] os = DataGrid.this.filteredDataSet.getRow(i);
                    item.setText(0, "" + i);
                    int j = 0;
                    while (j < os.length) {
                        item.setText(j + 1, DataGrid.this.columnFormat[j].format(os[j].toString()));
                        ++j;
                    }
                    ++i;
                }
                if (1 != (DataGrid.this.style & 1) && DataGrid.this.table.getItemCount() > DataGrid.this.prefs.getInt("MaxDataItems")) {
                    int items = DataGrid.this.table.getItemCount() - DataGrid.this.prefs.getInt("MaxDataItems");
                    DataGrid.this.table.remove(0, items - 1);
                    DataGrid.this.removedItems += items;
                }
                TableColumn col = DataGrid.this.table.getColumn(0);
                col.pack();
                if (!DataGrid.this.manualResize) {
                    TableColumn[] cols = DataGrid.this.table.getColumns();
                    int i2 = 1;
                    while (i2 < cols.length) {
                        cols[i2].pack();
                        ++i2;
                    }
                }
                if (DataGrid.this.prefs.getBoolean("JumpNewTableEntry")) {
                    DataGrid.this.table.showItem(DataGrid.this.table.getItem(DataGrid.this.table.getItemCount() - 1));
                }
            }
        });
    }

    public void dispose() {
        this.dataSet = null;
        this.table.dispose();
        this.table = null;
        this.clickLocation = null;
        this.columnFormat = null;
    }

    public class AddFilterSelection
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            SelectFilterWizard wizard = new SelectFilterWizard(DataGrid.this.dataSet.getTitles());
            IWorkbench workbench = PlatformUI.getWorkbench();
            wizard.init(workbench, null);
            WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            IDataSetFilter filter = wizard.getFilter();
            wizard.dispose();
            if (filter != null) {
                DataGrid.this.filteredDataSet.addFilter(filter);
                DataGrid.this.table.removeAll();
                DataGrid.this.handleUpdateEvent();
                MenuItem item = new MenuItem(DataGrid.this.filterMenu, 64);
                item.setText(AvailableFilterTypes.getFilterName(filter.getID()));
                item.setData((Object)filter);
                item.addSelectionListener((SelectionListener)new RemoveFilterSelection());
            }
        }
    }

    public class FormatMenuListener
    extends MenuAdapter {
        public void menuShown(MenuEvent e) {
            MenuItem[] items = ((Menu)e.widget).getItems();
            boolean doubleValid = false;
            boolean longValid = false;
            int selectedCol = Math.max(1, DataGrid.this.getSelectedColumn());
            int i = 0;
            while (i < items.length) {
                items[i].setSelection(false);
                ++i;
            }
            items[DataGrid.this.columnFormat[selectedCol - 1].getFormat()].setSelection(true);
            String itemText = DataGrid.this.dataSet.getRow(0)[selectedCol - 1].toString();
            items[0].setEnabled(true);
            items[1].setEnabled(true);
            try {
                Double.parseDouble(itemText);
                doubleValid = true;
                try {
                    Long.parseLong(itemText);
                    longValid = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (NumberFormatException numberFormatException) {}
            items[3].setEnabled(doubleValid);
            items[4].setEnabled(longValid);
            items[5].setEnabled(longValid);
            items[6].setEnabled(longValid);
            items[2].setEnabled(longValid);
        }
    }

    public class MainMenuListener
    extends MenuAdapter {
        public void menuShown(MenuEvent e) {
            MenuItem item = ((Menu)e.widget).getItem(1);
            item.setSelection(DataGrid.this.manualResize);
        }
    }

    public class MenuFormatSelection
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            int format = 0;
            int column = Math.max(1, DataGrid.this.getSelectedColumn());
            int i = 0;
            while (i < IFormattingStyles.FORMAT_TITLES.length) {
                if (IFormattingStyles.FORMAT_TITLES[i].equals(((MenuItem)e.getSource()).getText())) {
                    format = i;
                }
                ++i;
            }
            Object[] data = DataGrid.this.dataSet.getColumn(column - 1);
            DataGrid.this.columnFormat[column - 1].setFormat(format);
            i = 0;
            while (i < DataGrid.this.table.getItemCount()) {
                DataGrid.this.table.getItem(i).setText(column, DataGrid.this.columnFormat[column - 1].format(data[i].toString()));
                ++i;
            }
            DataGrid.this.table.redraw();
        }
    }

    public class MenuManualyResizedSelection
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            DataGrid.this.manualResize = !DataGrid.this.manualResize;
        }
    }

    public class RemoveFilterSelection
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            IDataSetFilter idsf = (IDataSetFilter)((MenuItem)e.widget).getData();
            e.widget.dispose();
            if (DataGrid.this.filteredDataSet.removeFilter(idsf)) {
                DataGrid.this.table.removeAll();
                DataGrid.this.handleUpdateEvent();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

