/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs;

import org.eclipse.linuxtools.systemtap.graphingapi.core.IGraphColorConstants;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.BlockAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.DataPoint;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.NumberType;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.AGraph;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.IBlockGraph;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.IScrollGraph;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class BarGraph
extends AGraph
implements IBlockGraph,
IScrollGraph {
    private IAdapter adapter;
    private boolean fullUpdate;
    public static final String ID = "org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.bargraph";
    private static final double WIDTH_PERCENT = 0.8;

    public BarGraph(GraphComposite parent, int style, String title, IAdapter adapter) {
        super(parent, style, title, adapter);
        this.adapter = adapter;
        this.fullUpdate = adapter instanceof BlockAdapter;
        this.handleUpdateEvent();
    }

    @Override
    public void paintElementList(GC gc) {
        DataPoint[] points = new DataPoint[]{};
        Color temp = gc.getForeground();
        Color temp1 = gc.getBackground();
        double xSize = super.getSize().x - (super.getXPadding() << 1);
        xSize /= (double)(super.getLocalWidth() + 1);
        xSize /= (double)this.elementList.length;
        double ySize = super.getSize().y - (super.getYPadding() << 1);
        ySize /= (double)super.getLocalHeight();
        double pw = 0.0;
        int j = 0;
        while (j < this.elementList.length) {
            points = this.elementList[j].toArray(points);
            Color c = new Color((Device)this.getDisplay(), IGraphColorConstants.COLORS[j]);
            Color c1 = new Color((Device)this.getDisplay(), c.getRed() >> 1, c.getGreen() >> 1, c.getBlue() >> 1);
            gc.setForeground(c);
            gc.setBackground(c1);
            double width = 0.8;
            DataPoint[] dataPointArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                DataPoint point = dataPointArray[n2];
                double px = (double)super.getLocation().x + (point.x * (double)this.elementList.length - (double)super.getLocalXMin()) * xSize + (double)super.getXPadding();
                pw = xSize * width;
                double py = super.getSize().y - super.getYPadding();
                double ph = ((double)super.getLocalYMax() - point.y) * ySize + (double)super.getYPadding() - py;
                gc.fillGradientRectangle((int)(px += (double)(j - this.elementList.length / 2) * (xSize * width)), (int)py, (int)pw, (int)ph, true);
                ++n2;
            }
            ++j;
        }
        gc.setForeground(temp);
        gc.setBackground(temp1);
    }

    @Override
    public boolean isMultiGraph() {
        return this.adapter.getSeriesCount() > 0;
    }

    @Override
    public void handleUpdateEvent() {
        if (this.adapter == null) {
            return;
        }
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Object[][] data;
                if (BarGraph.this.fullUpdate) {
                    int i = 0;
                    while (i < BarGraph.this.elementList.length) {
                        BarGraph.this.elementList[i].clear();
                        ++i;
                    }
                    data = BarGraph.this.adapter.getData();
                } else {
                    data = BarGraph.this.adapter.getData(BarGraph.this.removedItems, BarGraph.this.adapter.getRecordCount());
                }
                if (BarGraph.this.normalize) {
                    int i = 0;
                    while (i < BarGraph.this.adapter.getSeriesCount()) {
                        BarGraph.this.elementList[i].clear();
                        double max = BarGraph.this.adapter.getYSeriesMax(i, BarGraph.this.removedItems, BarGraph.this.adapter.getRecordCount()).doubleValue() / 100.0;
                        int j = 0;
                        while (j < data.length) {
                            BarGraph.this.elementList[i].add(new DataPoint(BarGraph.this.adapter instanceof BlockAdapter ? (double)j : NumberType.obj2num((Object)data[j][0]).doubleValue(), NumberType.obj2num((Object)data[j][i + 1]).doubleValue() / max));
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < BarGraph.this.adapter.getSeriesCount()) {
                        BarGraph.this.elementList[i].clear();
                        int j = 0;
                        while (j < data.length) {
                            BarGraph.this.elementList[i].add(new DataPoint(BarGraph.this.adapter instanceof BlockAdapter ? (double)j : NumberType.obj2num((Object)data[j][0]).doubleValue(), NumberType.obj2num((Object)data[j][i + 1]).doubleValue()));
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        });
        this.repaint();
    }
}

