/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.callstack;

import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.ui.views.callstack.CallStackEntry;
import org.eclipse.linuxtools.tmf.ui.views.callstack.CallStackEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class CallStackPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 360;

    @Override
    public String getStateTypeName() {
        return "";
    }

    @Override
    public String getStateTypeName(ITimeGraphEntry entry) {
        return "";
    }

    @Override
    public StateItem[] getStateTable() {
        StateItem[] stateTable = new StateItem[361];
        stateTable[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
        int i = 0;
        while (i < 360) {
            RGB rgb = new RGB((float)i, 0.6f, 0.6f);
            stateTable[i + 1] = new StateItem(rgb, State.EXEC.toString());
            ++i;
        }
        return stateTable;
    }

    @Override
    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof CallStackEvent) {
            CallStackEvent callStackEvent = (CallStackEvent)event;
            return callStackEvent.getValue() + 1;
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return State.MULTIPLE.ordinal();
    }

    @Override
    public String getEventName(ITimeEvent event) {
        if (event instanceof CallStackEvent) {
            CallStackEntry entry = (CallStackEntry)event.getEntry();
            ITmfStateSystem ss = (ITmfStateSystem)entry.getTrace().getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
            try {
                ITmfStateInterval value = ss.querySingleState(event.getTime(), entry.getQuark());
                if (!value.getStateValue().isNull()) {
                    ITmfStateValue state = value.getStateValue();
                    return state.toString();
                }
            }
            catch (AttributeNotFoundException e) {
                Activator.getDefault().logError("Error querying state system", e);
            }
            catch (TimeRangeException e) {
                Activator.getDefault().logError("Error querying state system", e);
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {}
            return null;
        }
        return State.MULTIPLE.toString();
    }

    @Override
    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (bounds.width <= gc.getFontMetrics().getAverageCharWidth()) {
            return;
        }
        if (!(event instanceof CallStackEvent)) {
            return;
        }
        CallStackEntry entry = (CallStackEntry)event.getEntry();
        ITmfStateSystem ss = (ITmfStateSystem)entry.getTrace().getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
        try {
            ITmfStateInterval value = ss.querySingleState(event.getTime(), entry.getQuark());
            if (!value.getStateValue().isNull()) {
                ITmfStateValue state = value.getStateValue();
                gc.setForeground(gc.getDevice().getSystemColor(1));
                Utils.drawText(gc, state.toString(), bounds.x, bounds.y - 2, bounds.width, true, true);
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getDefault().logError("Error querying state system", e);
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error querying state system", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {}
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

