/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import java.text.ParseException;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramTextControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramView;
import org.eclipse.swt.widgets.Composite;

public class HistogramTimeRangeControl
extends HistogramTextControl {
    public HistogramTimeRangeControl(HistogramView parentView, Composite parent, String groupLabel, long value) {
        super(parentView, parent, groupLabel, value);
        TmfSignalManager.register((Object)this);
    }

    @Override
    public void dispose() {
        TmfSignalManager.deregister((Object)this);
    }

    @Override
    protected void updateValue() {
        if (this.getValue() == Long.MIN_VALUE) {
            this.fTextValue.setText("");
            return;
        }
        String string = this.fTextValue.getText();
        long value = this.getValue();
        try {
            value = TmfTimestampFormat.getDefaulIntervalFormat().parseValue(string);
        }
        catch (ParseException parseException) {}
        if (this.getValue() != value) {
            this.fParentView.updateTimeRange(value);
        } else {
            this.setValue(value);
        }
    }

    @Override
    public void setValue(long time) {
        if (time != Long.MIN_VALUE) {
            TmfTimestamp ts = new TmfTimestamp(time, -9);
            super.setValue(time, ts.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        } else {
            super.setValue(time, "");
        }
    }

    @TmfSignalHandler
    public void intervalFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.setValue(this.getValue());
    }
}

