/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.ems.core.EnvManagerConfigString;
import org.eclipse.ptp.ems.core.EnvManagerRegistry;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJob;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStatus;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStatusMap;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBRMPreferenceConstants;
import org.eclipse.ptp.internal.rm.jaxb.control.core.RemoteServicesDelegate;
import org.eclipse.ptp.internal.rm.jaxb.control.core.messages.Messages;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.JobStatusMap;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.ManagedFilesJob;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.ScriptHandler;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command.CommandJob;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command.CommandJobStatus;
import org.eclipse.ptp.internal.rm.jaxb.control.core.utils.JobIdPinTable;
import org.eclipse.ptp.internal.rm.jaxb.control.core.variables.RMVariableMap;
import org.eclipse.ptp.internal.rm.jaxb.core.JAXBInitializationUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.server.core.RemoteServerManager;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.CommandType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFileType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFilesType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.ScriptType;
import org.eclipse.ptp.rm.jaxb.core.data.SiteType;
import org.eclipse.ptp.rm.lml.da.server.core.LMLDAServer;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchController
implements ILaunchController {
    private final ConnectionChangeListener connectionListener = new ConnectionChangeListener();
    private final Map<String, String> launchEnv = new TreeMap<String, String>();
    private final JobIdPinTable pinTable = new JobIdPinTable();
    private String fControlId;
    private ICommandJobStatusMap jobStatusMap;
    private RMVariableMap rmVarMap;
    private String servicesId;
    private String connectionName;
    private boolean appendLaunchEnv;
    private boolean isActive = false;
    private boolean isInitialized = false;
    private String configURL;
    private RemoteServicesDelegate fRemoteServicesDelegate;
    private ResourceManagerData configData;

    public static void checkConnection(IRemoteConnection connection, SubMonitor progress) throws CoreException {
        try {
            if (connection != null && !connection.isOpen()) {
                connection.open((IProgressMonitor)progress.newChild(25));
                if (!connection.isOpen()) {
                    throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.RemoteConnectionError) + connection.getAddress()));
                }
            }
        }
        catch (RemoteConnectionException e) {
            throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.RemoteConnectionError) + connection.getAddress()), (Throwable)e);
        }
    }

    private void addAttribute(String name, String value) {
        AttributeType attr = this.getEnvironment().get(name);
        if (attr == null) {
            attr = new AttributeType();
            attr.setName(name);
            attr.setVisible(Boolean.valueOf(true));
            attr.setReadOnly(Boolean.valueOf(true));
            this.getEnvironment().put(name, attr);
        }
        attr.setValue((Object)value);
    }

    private void checkJobForError(ICommandJob job) throws CoreException {
        IStatus status = job.getRunStatus();
        if (status != null && status.getSeverity() == 4) {
            throw CoreExceptionUtils.newException((String)status.getMessage(), (Throwable)status.getException());
        }
    }

    public void control(String jobId, String operation, IProgressMonitor monitor) throws CoreException {
        if (!this.isActive()) {
            throw CoreExceptionUtils.newException((String)Messages.LaunchController_notStarted, null);
        }
        if ("RERUN".equals(operation)) {
            ICommandJobStatus status = this.jobStatusMap.getStatus(jobId);
            if (status != null) {
                status.rerun();
            }
        } else {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                this.pinTable.pin(jobId);
                AttributeType a = this.getRMVariableMap().get(jobId);
                AttributeType tmp = null;
                if (a == null) {
                    tmp = new AttributeType();
                    tmp.setVisible(Boolean.valueOf(false));
                    tmp.setName(jobId);
                    this.getRMVariableMap().put(jobId, tmp);
                }
                this.worked((IProgressMonitor)progress, 30);
                this.doControlCommand(jobId, operation);
                if (tmp != null) {
                    this.getRMVariableMap().remove(jobId);
                }
                this.worked((IProgressMonitor)progress, 40);
                if ("TERMINATE".equals(operation)) {
                    this.jobStatusMap.cancel(jobId);
                }
                this.worked((IProgressMonitor)progress, 30);
            }
            finally {
                this.pinTable.release(jobId);
            }
        }
    }

    @Override
    public void dispose() {
    }

    private void doControlCommand(String jobId, String operation) throws CoreException {
        CoreException ce = CoreExceptionUtils.newException((String)(String.valueOf(Messages.RMNoSuchCommandError) + operation), null);
        CommandType job = null;
        if ("TERMINATE".equals(operation)) {
            this.maybeKillInteractive(jobId);
            job = this.getConfiguration().getControlData().getTerminateJob();
            if (job == null) {
                return;
            }
        } else if ("SUSPEND".equals(operation) ? (job = this.getConfiguration().getControlData().getSuspendJob()) == null : ("RESUME".equals(operation) ? (job = this.getConfiguration().getControlData().getResumeJob()) == null : ("RELEASE".equals(operation) ? (job = this.getConfiguration().getControlData().getReleaseJob()) == null : "HOLD".equals(operation) && (job = this.getConfiguration().getControlData().getHoldJob()) == null))) {
            throw ce;
        }
        this.runCommand(jobId, job, CommandJob.JobMode.INTERACTIVE, this.getEnvironment(), null, "run");
    }

    private ICommandJob doJobSubmitCommand(String uuid, ILaunchConfiguration launchConfig, String launchMode) throws CoreException {
        CommandType command = null;
        CommandJob.JobMode jobMode = CommandJob.JobMode.INTERACTIVE;
        if ("run".equals(launchMode)) {
            command = this.getConfiguration().getControlData().getSubmitBatch();
            if (command != null) {
                jobMode = CommandJob.JobMode.BATCH;
            } else {
                command = this.getConfiguration().getControlData().getSubmitInteractive();
            }
        } else if ("debug".equals(launchMode)) {
            command = this.getConfiguration().getControlData().getSubmitBatchDebug();
            if (command != null) {
                jobMode = CommandJob.JobMode.BATCH;
            } else {
                command = this.getConfiguration().getControlData().getSubmitInteractiveDebug();
            }
        }
        if (command == null) {
            throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.MissingRunCommandsError) + " " + uuid + " " + launchMode), null);
        }
        return this.runCommand(uuid, command, jobMode, this.getEnvironment(), launchConfig, launchMode);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean getAppendEnv() {
        return this.appendLaunchEnv;
    }

    @Override
    public ResourceManagerData getConfiguration() {
        return this.configData;
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }

    public String getControlId() {
        return this.fControlId;
    }

    @Override
    public IVariableMap getEnvironment() {
        return this.getRMVariableMap();
    }

    private IEnvManagerConfig getEnvManagerConfig(ILaunchConfiguration configuration) {
        try {
            EnvManagerConfigString config;
            String emsConfigAttr = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_EMS_CONFIG", null);
            if (emsConfigAttr != null && (config = new EnvManagerConfigString(emsConfigAttr)).isEnvMgmtEnabled()) {
                return config;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public IJobStatus getJobStatus(String jobId, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!this.isActive()) {
            throw CoreExceptionUtils.newException((String)Messages.LaunchController_notStarted, null);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ICommandJobStatus status = this.jobStatusMap.getStatus(jobId);
        if (status != null) {
            if ("COMPLETED".equals(status.getState())) {
                return this.jobStatusMap.terminated(jobId, (IProgressMonitor)progress.newChild(50));
            }
            if (!force) {
                long now = System.currentTimeMillis();
                long lapse = now - status.getLastUpdateRequest();
                if (lapse < 30000L) {
                    return status;
                }
                status.setUpdateRequestTime(now);
            }
        }
        String state = status == null ? "UNDETERMINED" : status.getStateDetail();
        ICommandJob job = null;
        try {
            this.pinTable.pin(jobId);
            AttributeType a = this.getRMVariableMap().get(jobId);
            CommandType cmd = this.getConfiguration().getControlData().getGetJobStatus();
            if (cmd != null && this.isActive() && !progress.isCanceled()) {
                AttributeType tmp = null;
                if (a == null) {
                    tmp = new AttributeType();
                    tmp.setVisible(Boolean.valueOf(false));
                    tmp.setName(jobId);
                    this.getRMVariableMap().put(jobId, tmp);
                }
                job = this.runCommand(jobId, cmd, CommandJob.JobMode.STATUS, this.getEnvironment(), null, "run");
                if (tmp != null) {
                    a = this.getRMVariableMap().remove(jobId);
                }
            }
            if (a != null) {
                state = String.valueOf(a.getValue());
            }
        }
        finally {
            this.pinTable.release(jobId);
        }
        if (status == null) {
            status = new CommandJobStatus(jobId, state, null, this, this.getEnvironment(), "run");
            status.setOwner(this.getRMVariableMap().getString("${ptp_rm:control.user.name#value}"));
            this.jobStatusMap.addJobStatus(jobId, status);
        } else {
            status.setState(state);
        }
        if (job != null && this.isCanceled(job) || progress.isCanceled()) {
            status.setState("UNDETERMINED");
            return status;
        }
        if ("COMPLETED".equals(state)) {
            this.jobStatusMap.terminated(jobId, (IProgressMonitor)progress.newChild(50));
        }
        return status;
    }

    public IJobStatus getJobStatus(String jobId, IProgressMonitor monitor) throws CoreException {
        return this.getJobStatus(jobId, false, monitor);
    }

    public Map<String, String> getLaunchEnv() {
        return this.launchEnv;
    }

    @Override
    public String getRemoteServicesId() {
        return this.servicesId;
    }

    private RMVariableMap getRMVariableMap() {
        if (this.rmVarMap == null) {
            this.rmVarMap = new RMVariableMap();
        }
        if (!this.rmVarMap.isInitialized()) {
            JAXBInitializationUtils.initializeMap((ResourceManagerData)this.getConfiguration(), (IVariableMap)this.rmVarMap);
        }
        return this.rmVarMap;
    }

    public ICommandJobStatusMap getStatusMap() {
        return this.jobStatusMap;
    }

    @Override
    public boolean hasRunningJobs() {
        return this.jobStatusMap != null && !this.jobStatusMap.isEmpty();
    }

    @Override
    public void initialize() throws CoreException {
        SiteType site;
        this.realizeRMDataFromXML();
        if (this.servicesId == null && this.connectionName == null && (site = this.getConfiguration().getSiteData()) != null) {
            this.servicesId = site.getRemoteServices();
            if (this.servicesId == null) {
                this.servicesId = "org.eclipse.ptp.remote.RemoteTools";
            }
            this.connectionName = site.getConnectionName();
        }
        if (this.servicesId == null || this.connectionName == null) {
            throw CoreExceptionUtils.newException((String)Messages.LaunchController_missingServicesOrConnectionName);
        }
        this.fControlId = LaunchControllerManager.generateControlId(this.servicesId, this.connectionName, this.getConfiguration().getName());
        this.isInitialized = true;
    }

    private boolean isActive() {
        return this.isActive;
    }

    private boolean isCanceled(ICommandJob job) {
        IStatus status = job.getRunStatus();
        return status != null && status.getSeverity() == 8;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    private void maybeAddManagedFileForScript(List<ManagedFilesType> lists, String stagingLocation, boolean delete) {
        ManagedFilesType files = null;
        if (stagingLocation == null) {
            stagingLocation = ".eclipsesettings";
        }
        for (ManagedFilesType f : lists) {
            if (!stagingLocation.equals(f.getFileStagingLocation())) continue;
            files = f;
            break;
        }
        AttributeType scriptVar = this.getRMVariableMap().get("script");
        AttributeType scriptPathVar = this.getRMVariableMap().get("script_path");
        if (scriptVar != null || scriptPathVar != null) {
            if (files == null) {
                files = new ManagedFilesType();
                files.setFileStagingLocation(stagingLocation);
                lists.add(files);
            }
            List fileList = files.getFile();
            ManagedFileType scriptFile = null;
            if (!fileList.isEmpty()) {
                for (ManagedFileType f : fileList) {
                    if (!f.getName().equals("managed_file_for_script")) continue;
                    scriptFile = f;
                    break;
                }
            }
            if (scriptFile == null) {
                scriptFile = new ManagedFileType();
                scriptFile.setName("managed_file_for_script");
                fileList.add(scriptFile);
            }
            scriptFile.setResolveContents(Boolean.valueOf(false));
            scriptFile.setUniqueIdPrefix(Boolean.valueOf(true));
            if (scriptPathVar != null) {
                scriptFile.setPath(String.valueOf(scriptPathVar.getValue()));
                scriptFile.setDeleteSourceAfterUse(Boolean.valueOf(false));
            } else {
                scriptFile.setContents("${ptp_rm:script#value}");
                scriptFile.setDeleteSourceAfterUse(Boolean.valueOf(true));
            }
            scriptFile.setDeleteTargetAfterUse(Boolean.valueOf(delete));
        }
    }

    private void maybeCleanupManagedFiles(String uuid, List<ManagedFilesType> lists) throws CoreException {
        if (lists == null || lists.isEmpty() || Preferences.getBoolean((String)JAXBControlCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.KEEP_MANAGED_FILES)) {
            return;
        }
        for (ManagedFilesType files : lists) {
            if (files.getFile().isEmpty()) continue;
            ManagedFilesJob job = new ManagedFilesJob(uuid, files, this);
            job.setOperation(ManagedFilesJob.Operation.DELETE);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean maybeHandleScript(String uuid, ScriptType script, IProgressMonitor monitor) {
        AttributeType a = this.getRMVariableMap().get("script_path");
        if (a != null && a.getValue() != null) {
            return false;
        }
        if (script == null) {
            return false;
        }
        ScriptHandler job = new ScriptHandler(uuid, script, this.getRMVariableMap(), this.launchEnv, false);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return script.isDeleteAfterSubmit();
    }

    private boolean maybeKillInteractive(String jobId) {
        ICommandJobStatus status = this.jobStatusMap.getStatus(jobId);
        boolean killed = false;
        if (status != null) {
            killed = status.cancel();
        }
        return killed;
    }

    private boolean maybeTransferManagedFiles(String uuid, List<ManagedFilesType> lists) throws CoreException {
        if (lists == null || lists.isEmpty()) {
            return true;
        }
        for (ManagedFilesType files : lists) {
            if (files.getFile().isEmpty()) continue;
            ManagedFilesJob job = new ManagedFilesJob(uuid, files, this);
            job.setOperation(ManagedFilesJob.Operation.COPY);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
            if (job.getSuccess()) continue;
            return false;
        }
        return true;
    }

    private void maybeUpdateServer(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IRemoteConnection conn = this.fRemoteServicesDelegate.getRemoteConnection();
        LMLDAServer server = (LMLDAServer)RemoteServerManager.getServer((String)LMLDAServer.SERVER_ID, (IRemoteConnection)conn);
        server.setWorkDir(new Path(conn.getWorkingDirectory()).append(".eclipsesettings").toString());
        try {
            server.updateServer((IProgressMonitor)progress.newChild(100));
        }
        catch (IOException e) {
            throw CoreExceptionUtils.newException((String)e.getMessage(), (Throwable)e);
        }
    }

    private void realizeRMDataFromXML() throws CoreException {
        if (this.configURL != null) {
            try {
                String configXML = JAXBInitializationUtils.getRMConfigurationXML((URL)new URL(this.configURL));
                this.configData = JAXBInitializationUtils.initializeRMData((String)configXML);
            }
            catch (Exception e) {
                throw CoreExceptionUtils.newException((String)e.getLocalizedMessage(), (Throwable)e.getCause());
            }
        }
    }

    @Override
    public void runCommand(CommandType command, IVariableMap attributes) throws CoreException {
        this.runCommand(null, command, CommandJob.JobMode.INTERACTIVE, attributes, null, "run");
    }

    private ICommandJob runCommand(String uuid, CommandType command, CommandJob.JobMode jobMode, IVariableMap map, ILaunchConfiguration launchConfig, String launchMode) throws CoreException {
        if (command == null) {
            throw CoreExceptionUtils.newException((String)Messages.RMNoSuchCommandError, null);
        }
        CommandJob job = new CommandJob(uuid, command, jobMode, this, map, launchConfig, launchMode);
        ((Job)job).setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        if (!command.isIgnoreExitStatus()) {
            this.checkJobForError(job);
        }
        return job;
    }

    @Override
    public void runCommand(String name, String resetValue, ILaunchConfiguration configuration) throws CoreException {
        if (!this.isActive()) {
            throw CoreExceptionUtils.newException((String)Messages.LaunchController_notStarted, null);
        }
        if (configuration != null) {
            this.updateAttributeValues(configuration, "run", null);
        }
        AttributeType changedValue = null;
        if (resetValue != null) {
            changedValue = this.getRMVariableMap().get(resetValue);
            changedValue.setValue(null);
        }
        CommandType command = null;
        for (CommandType cmd : this.getConfiguration().getControlData().getButtonAction()) {
            if (!cmd.getName().equals(name)) continue;
            command = cmd;
            break;
        }
        if (command == null) {
            for (CommandType cmd : this.getConfiguration().getControlData().getStartUpCommand()) {
                if (!cmd.getName().equals(name)) continue;
                command = cmd;
                break;
            }
        }
        if (command == null) {
            for (CommandType cmd : this.getConfiguration().getControlData().getShutDownCommand()) {
                if (!cmd.getName().equals(name)) continue;
                command = cmd;
                break;
            }
        }
        if (command != null) {
            this.runCommand(null, command, CommandJob.JobMode.INTERACTIVE, this.getEnvironment(), configuration, "run");
        }
    }

    private void runCommands(List<CommandType> cmds) throws CoreException {
        for (CommandType cmd : cmds) {
            this.runCommand(null, cmd, CommandJob.JobMode.INTERACTIVE, this.getEnvironment(), null, "run");
        }
    }

    @Override
    public void setConnectionName(String connName) {
        this.connectionName = connName;
    }

    private void setConnectionPropertyAttributes(IRemoteConnection conn) {
        String property = conn.getProperty("os.arch");
        if (property != null) {
            this.addAttribute("os.arch", property);
        }
        if ((property = conn.getProperty("os.name")) != null) {
            this.addAttribute("os.name", property);
        }
        if ((property = conn.getProperty("os.version")) != null) {
            this.addAttribute("os.version", property);
        }
    }

    private void setFixedConfigurationProperties(IRemoteConnection rc) throws CoreException {
        if (rc != null) {
            this.getRMVariableMap().maybeAddAttribute("control.user.name", rc.getUsername(), false);
            this.getRMVariableMap().maybeAddAttribute("control.address", rc.getAddress(), false);
            this.getRMVariableMap().maybeAddAttribute("control.working.dir", rc.getWorkingDirectory(), false);
            this.getRMVariableMap().maybeAddAttribute("working.directory", rc.getWorkingDirectory(), false);
            this.getRMVariableMap().maybeAddAttribute("ptpDirectory", new Path(rc.getWorkingDirectory()).append(".eclipsesettings").toString(), false);
        }
    }

    @Override
    public void setRemoteServicesId(String id) {
        this.servicesId = id;
    }

    @Override
    public void setRMConfigurationURL(URL url) {
        if (url != null) {
            this.configURL = url.toExternalForm();
        }
    }

    @Override
    public void start(IProgressMonitor monitor) throws CoreException {
        if (!this.isActive) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)60);
            if (!this.isInitialized) {
                this.initialize();
            }
            this.fRemoteServicesDelegate = RemoteServicesDelegate.getDelegate(this.servicesId, this.connectionName, (IProgressMonitor)progress.newChild(50));
            IRemoteConnection conn = this.fRemoteServicesDelegate.getRemoteConnection();
            if (conn != null) {
                LaunchController.checkConnection(conn, progress);
                conn.addConnectionChangeListener((IRemoteConnectionChangeListener)this.connectionListener);
            }
            this.getRMVariableMap().setEnvManagerFromConnection(conn);
            this.setFixedConfigurationProperties(conn);
            this.setConnectionPropertyAttributes(conn);
            this.appendLaunchEnv = true;
            this.jobStatusMap = JobStatusMap.getInstance(this);
            this.jobStatusMap.initialize();
            List onStartUp = this.getConfiguration().getControlData().getStartUpCommand();
            this.runCommands(onStartUp);
            this.isActive = true;
        }
    }

    @Override
    public void stop() throws CoreException {
        if (this.isActive) {
            IRemoteConnection conn;
            List onShutDown = this.getConfiguration().getControlData().getShutDownCommand();
            this.runCommands(onShutDown);
            this.jobStatusMap.dispose();
            if (this.rmVarMap != null) {
                this.rmVarMap.clear();
            }
            if ((conn = this.fRemoteServicesDelegate.getRemoteConnection()) != null) {
                conn.removeConnectionChangeListener((IRemoteConnectionChangeListener)this.connectionListener);
            }
            this.isActive = false;
        }
    }

    public String submitJob(ILaunchConfiguration launchConfig, String launchMode, IProgressMonitor monitor) throws CoreException {
        String uuid = UUID.randomUUID().toString();
        if (!this.isActive()) {
            throw CoreExceptionUtils.newException((String)Messages.LaunchController_notStarted, null);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AttributeType a = new AttributeType();
        a.setVisible(Boolean.valueOf(false));
        this.getRMVariableMap().put(uuid, a);
        this.updateAttributeValues(launchConfig, launchMode, (IProgressMonitor)progress.newChild(5));
        ScriptType script = this.getConfiguration().getControlData().getScript();
        boolean delScript = this.maybeHandleScript(uuid, script, (IProgressMonitor)progress.newChild(5));
        this.worked((IProgressMonitor)progress, 20);
        List files = this.getConfiguration().getControlData().getManagedFiles();
        if (script != null) {
            this.maybeAddManagedFileForScript(files, script.getFileStagingLocation(), delScript);
        }
        this.worked((IProgressMonitor)progress, 5);
        if (!this.maybeTransferManagedFiles(uuid, files)) {
            throw CoreExceptionUtils.newException((String)Messages.CannotCompleteSubmitFailedStaging, null);
        }
        this.worked((IProgressMonitor)progress, 20);
        this.maybeUpdateServer((IProgressMonitor)progress.newChild(10));
        ICommandJob job = null;
        try {
            job = this.doJobSubmitCommand(uuid, launchConfig, launchMode);
            if (this.isCanceled(job)) {
                throw CoreExceptionUtils.newException((String)Messages.OperationWasCancelled, null);
            }
            this.worked((IProgressMonitor)progress, 40);
        }
        finally {
            this.maybeCleanupManagedFiles(uuid, files);
            this.worked((IProgressMonitor)progress, 5);
        }
        ICommandJobStatus status = job.getJobStatus();
        this.getRMVariableMap().remove(uuid);
        this.jobStatusMap.addJobStatus(status.getJobId(), status);
        this.worked((IProgressMonitor)progress, 5);
        this.getRMVariableMap().remove("script_path");
        this.getRMVariableMap().remove("script");
        return status.getJobId();
    }

    private void updateAttributeValues(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IEnvManager envManager;
        IEnvManagerConfig envMgrConfig;
        AttributeType a;
        Map<String, Object> lcattr = RMVariableMap.getValidAttributes(configuration);
        for (String key : lcattr.keySet()) {
            Object value = lcattr.get(key);
            AttributeType target = this.getRMVariableMap().get(key.toString());
            if (target == null) continue;
            target.setValue(value);
        }
        for (String key : this.getRMVariableMap().getAttributes().keySet()) {
            AttributeType target;
            if (lcattr.containsKey(key) || !(target = this.getRMVariableMap().get(key.toString())).isVisible()) continue;
            target.setValue(null);
        }
        this.getRMVariableMap().maybeAddAttribute("launchMode", mode, false);
        this.getRMVariableMap().overwrite("script_path", "script_path", lcattr);
        this.getRMVariableMap().overwrite("executablePath", "executablePath", lcattr);
        this.getRMVariableMap().overwrite("executableDirectory", "executableDirectory", lcattr);
        this.getRMVariableMap().overwrite("progArgs", "progArgs", lcattr);
        this.getRMVariableMap().overwrite("debuggerId", "debuggerId", lcattr);
        this.getRMVariableMap().overwrite("debuggerLauncher", "debuggerLauncher", lcattr);
        String attr = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null);
        if (attr != null) {
            a = this.getEnvironment().get("debuggerExecutablePath");
            if (a == null) {
                a = new AttributeType();
                a.setName("debuggerExecutablePath");
                this.getEnvironment().put("debuggerExecutablePath", a);
            }
            a.setValue((Object)attr);
        }
        if ((attr = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ARGS", null)) != null) {
            a = this.getEnvironment().get("debuggerArgs");
            if (a == null) {
                a = new AttributeType();
                a.setName("debuggerArgs");
                this.getEnvironment().put("debuggerArgs", a);
            }
            a.setValue((Object)attr);
        }
        if ((attr = configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", null)) == null) {
            a = this.getEnvironment().get("executableDirectory");
            if (a != null) {
                attr = (String)a.getValue();
            }
        } else {
            a = this.getEnvironment().get("working.directory");
            a.setValue((Object)attr);
        }
        if (attr != null) {
            a = this.getEnvironment().get("directory");
            if (a == null) {
                a = new AttributeType();
                a.setName("directory");
                this.getEnvironment().put("directory", a);
            }
            a.setValue((Object)attr);
        }
        if ((envMgrConfig = this.getEnvManagerConfig(configuration)) != null && (envManager = EnvManagerRegistry.getEnvManager((IProgressMonitor)monitor, (IRemoteConnection)this.fRemoteServicesDelegate.getRemoteConnection())) != null) {
            String emsStr = envManager.getBashConcatenation("\n", false, envMgrConfig, null);
            AttributeType a2 = this.getEnvironment().get("ems");
            if (a2 == null) {
                a2 = new AttributeType();
                a2.setName("ems");
                this.getEnvironment().put("ems", a2);
            }
            a2.setValue((Object)emsStr);
        }
    }

    private void worked(IProgressMonitor monitor, int units) {
        if (monitor != null) {
            if (units == 0) {
                monitor.done();
            } else {
                monitor.worked(units);
            }
        }
    }

    private class ConnectionChangeListener
    implements IRemoteConnectionChangeListener {
        public void connectionChanged(IRemoteConnectionChangeEvent event) {
            if (event.getType() == 4 || event.getType() == 1) {
                try {
                    LaunchController.this.stop();
                }
                catch (CoreException e) {
                    JAXBControlCorePlugin.log(e);
                }
            }
        }
    }
}

