/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.view;

import java.io.IOException;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.dataviewers.abstractview.AbstractSTDataView;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.TreeColumnViewerFilter;
import org.eclipse.linuxtools.dataviewers.actions.STExportToCSVAction;
import org.eclipse.linuxtools.dataviewers.charts.actions.ChartAction;
import org.eclipse.linuxtools.internal.gprof.Activator;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.linuxtools.internal.gprof.action.SwitchContentProviderAction;
import org.eclipse.linuxtools.internal.gprof.action.SwitchSampleTimeAction;
import org.eclipse.linuxtools.internal.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.internal.gprof.parser.HistogramDecoder;
import org.eclipse.linuxtools.internal.gprof.utils.PPC64ElfBinaryObjectWrapper;
import org.eclipse.linuxtools.internal.gprof.view.CallGraphContentProvider;
import org.eclipse.linuxtools.internal.gprof.view.FileHistogramContentProvider;
import org.eclipse.linuxtools.internal.gprof.view.FlatHistogramContentProvider;
import org.eclipse.linuxtools.internal.gprof.view.FunctionHistogramContentProvider;
import org.eclipse.linuxtools.internal.gprof.view.GmonViewer;
import org.eclipse.linuxtools.internal.gprof.view.fields.SampleProfField;
import org.eclipse.linuxtools.internal.gprof.view.histogram.CGArc;
import org.eclipse.linuxtools.internal.gprof.view.histogram.CGCategory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GmonView
extends AbstractSTDataView {
    public static final String ID = "org.eclipse.linuxtools.gprof.view";
    public static final Color WHITE = PlatformUI.getWorkbench().getDisplay().getSystemColor(1);
    public static final Color GREEN1 = new Color((Device)PlatformUI.getWorkbench().getDisplay(), 207, 255, 207);
    public static final Color GREEN2 = new Color((Device)PlatformUI.getWorkbench().getDisplay(), 175, 255, 175);
    public static final Color BLUE1 = new Color((Device)PlatformUI.getWorkbench().getDisplay(), 207, 207, 255);
    public static final Color BLUE2 = new Color((Device)PlatformUI.getWorkbench().getDisplay(), 175, 175, 255);
    public static final int CALL_GRAPH_MODE = 0;
    public static final int SAMPLE_MODE = 1;
    private Label label;
    private Text fFilterText;
    private TreeColumnViewerFilter fViewerFilter;
    private Action action1;
    private Action action2;
    private Action action3;
    private Action action4;
    private Action switchSampleTime;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridLayout l = (GridLayout)parent.getLayout();
        l.horizontalSpacing = 0;
        l.verticalSpacing = 0;
        l.marginHeight = 0;
        l.marginWidth = 0;
        this.fViewerFilter = new TreeColumnViewerFilter((TreeViewer)this.getSTViewer().getViewer(), this.getSTViewer().getAllFields()[0], true);
        this.getSTViewer().getViewer().addFilter((ViewerFilter)this.fViewerFilter);
    }

    protected void createTitle(Composite parent) {
        this.label = new Label(parent, 64);
        GridData data = new GridData(4, 1, true, false, 1, 1);
        this.label.setLayoutData((Object)data);
        this.fFilterText = new Text(parent, 2948);
        this.fFilterText.setMessage(Messages.GmonView_type_filter_text);
        this.fFilterText.setToolTipText(Messages.GmonView_filter_by_name);
        this.fFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = GmonView.this.fFilterText.getText();
                GmonView.this.fViewerFilter.setMatchingText(text);
            }
        });
    }

    protected void contributeToToolbar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
        this.action2.setChecked(true);
        manager.add((IAction)this.action3);
        manager.add((IAction)this.action4);
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.switchSampleTime);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ChartAction(this.getViewSite().getShell(), this.getSTViewer()));
    }

    protected void createActions() {
        super.createActions();
        this.action1 = new SwitchContentProviderAction("Display function call graph", "icons/ch_callees.png", this.getSTViewer().getViewer(), CallGraphContentProvider.sharedInstance);
        this.action2 = new SwitchContentProviderAction("Sort samples per file", "icons/c_file_obj.gif", this.getSTViewer().getViewer(), FileHistogramContentProvider.sharedInstance);
        this.action3 = new SwitchContentProviderAction("Sort samples per function", "icons/function_obj.gif", this.getSTViewer().getViewer(), FunctionHistogramContentProvider.sharedInstance);
        this.action4 = new SwitchContentProviderAction("Sort samples per line", "icons/line_obj.gif", this.getSTViewer().getViewer(), FlatHistogramContentProvider.sharedInstance);
        this.switchSampleTime = new SwitchSampleTimeAction(this);
    }

    public static Color getBackground(Object element) {
        if (element instanceof CGCategory) {
            CGCategory cat = (CGCategory)element;
            if ("children".equals(cat.category)) {
                return BLUE1;
            }
            return GREEN1;
        }
        if (element instanceof CGArc) {
            CGArc arc = (CGArc)element;
            CGCategory cat = (CGCategory)arc.getParent();
            if ("children".equals(cat.category)) {
                return BLUE2;
            }
            return GREEN2;
        }
        return WHITE;
    }

    public Label getLabel() {
        return this.label;
    }

    protected AbstractSTViewer createAbstractSTViewer(Composite parent) {
        return new GmonViewer(parent);
    }

    public static void setHistTitle(GmonDecoder decoder, Label titleLabel) {
        String title = " gmon file: " + decoder.getGmonFile() + "\n program file: " + decoder.getProgram().getPath();
        HistogramDecoder histo = decoder.getHistogramDecoder();
        if (histo.hasValues()) {
            double prof_rate = histo.getProf_rate();
            String period = "";
            if (prof_rate != 0.0) {
                char tUnit = histo.getTimeDimension();
                switch (tUnit) {
                    case 's': {
                        prof_rate /= 1.0E9;
                        break;
                    }
                    case 'm': {
                        prof_rate /= 1000000.0;
                        break;
                    }
                    case 'u': {
                        prof_rate /= 1000.0;
                    }
                }
                period = ", each sample counts as " + SampleProfField.getValue(1.0, prof_rate);
            }
            title = String.valueOf(title) + "\n " + histo.getBucketSize() + " bytes per bucket" + period;
        }
        titleLabel.setText(title);
        titleLabel.getParent().layout(true);
    }

    public static GmonView displayGprofView(String binaryPath, String gmonPath, IProject project) {
        Object binary = STSymbolManager.sharedInstance.getBinaryObject((IPath)new Path(binaryPath));
        if (binary == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Invalid binary file", (String)(String.valueOf(binaryPath) + " is not a valid binary file."));
            return null;
        }
        if (binary.getCPU().equals("ppc64")) {
            binary = new PPC64ElfBinaryObjectWrapper(binary.getBinaryParser(), binary.getPath(), binary.getType());
        }
        GmonDecoder decoder = new GmonDecoder((IBinaryParser.IBinaryObject)binary, project);
        try {
            decoder.read(gmonPath);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.gprof", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return GmonView.displayGprofView(decoder, gmonPath);
    }

    public static GmonView displayGprofView(GmonDecoder decoder, String secondary_id_usually_path_to_gmon_file) {
        GmonView gmonview = null;
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            if (secondary_id_usually_path_to_gmon_file != null) {
                secondary_id_usually_path_to_gmon_file = secondary_id_usually_path_to_gmon_file.replace('.', '_');
                secondary_id_usually_path_to_gmon_file = secondary_id_usually_path_to_gmon_file.replace(':', '_');
            }
            gmonview = (GmonView)page.showView(ID, secondary_id_usually_path_to_gmon_file, 1);
            if (decoder.getHistogramDecoder().getProf_rate() == 0) {
                gmonview.switchSampleTime.setToolTipText("Unable to display time, because profiling rate is null");
                gmonview.switchSampleTime.setEnabled(false);
            }
            gmonview.setInput(decoder);
            GmonView.setHistTitle(decoder, gmonview.label);
            if (!decoder.getHistogramDecoder().hasValues()) {
                gmonview.action1.setChecked(true);
                gmonview.action2.setChecked(false);
                gmonview.action1.run();
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.gprof", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return gmonview;
    }

    protected IAction createExportToCSVAction() {
        STExportToCSVAction action = new STExportToCSVAction(this.getSTViewer()){

            public void run() {
                Object o = GmonView.this.getSTViewer().getInput();
                if (o instanceof GmonDecoder) {
                    GmonDecoder gd = (GmonDecoder)o;
                    this.getExporter().setFilePath(String.valueOf(gd.getGmonFile()) + ".csv");
                }
                super.run();
            }
        };
        return action;
    }
}

