/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;

final class TmfTraceContext {
    static final TmfTraceContext NULL_CONTEXT = new TmfTraceContext(TmfTimestamp.BIG_CRUNCH, TmfTimeRange.NULL_RANGE);
    private final ITmfTimestamp fTimestamp;
    private final TmfTimeRange fTimerange;

    public TmfTraceContext(ITmfTimestamp ts, TmfTimeRange tr) {
        this.fTimestamp = ts;
        this.fTimerange = tr;
    }

    public TmfTraceContext(TmfTraceContext prevCtx, ITmfTimestamp ts) {
        this.fTimestamp = ts;
        this.fTimerange = prevCtx.fTimerange;
    }

    public ITmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    public TmfTimeRange getTimerange() {
        return this.fTimerange;
    }

    public boolean isValid() {
        return this.fTimestamp.compareTo(TmfTimestamp.ZERO) > 0 && this.fTimerange.getEndTime().compareTo(this.fTimerange.getStartTime()) > 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[fTimestamp=" + this.fTimestamp.toString() + ", fTimerange=" + this.fTimerange + ']';
    }
}

