/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.corext.codemanipulation.AddIncludesOperation;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AddIncludeOnSelectionAction
extends TextEditorAction {
    public static boolean sIsJUnitTest = false;
    private ITranslationUnit fTu;
    private IProject fProject;
    private String[] fIncludePath;
    private IRequiredInclude[] fRequiredIncludes;
    private String[] fUsingDeclarations;

    public AddIncludeOnSelectionAction(ITextEditor editor) {
        super(CEditorMessages.getBundleForConstructedKeys(), "AddIncludeOnSelection.", editor);
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.add_includes_on_selection_action_context");
    }

    private void insertInclude(IRequiredInclude[] includes, String[] usings, int beforeOffset) {
        AddIncludesOperation op = new AddIncludesOperation(this.fTu, beforeOffset, includes, usings);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(op), op.getSchedulingRule());
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.AddIncludeOnSelection_error_title, CEditorMessages.AddIncludeOnSelection_insertion_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static ITranslationUnit getTranslationUnit(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
    }

    private Shell getShell() {
        return this.getTextEditor().getSite().getShell();
    }

    public void run() {
        IScannerInfo info;
        this.fTu = AddIncludeOnSelectionAction.getTranslationUnit(this.getTextEditor());
        if (this.fTu == null) {
            return;
        }
        this.fProject = this.fTu.getCProject().getProject();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(this.fProject);
        this.fIncludePath = null;
        if (provider != null && (info = provider.getScannerInformation(this.fTu.getResource())) != null) {
            this.fIncludePath = info.getIncludePaths();
        }
        if (this.fIncludePath == null) {
            this.fIncludePath = new String[0];
        }
        try {
            IFunctionSummary fs;
            final ISelection selection = this.getTextEditor().getSelectionProvider().getSelection();
            if (selection.isEmpty() || !(selection instanceof ITextSelection)) {
                return;
            }
            if (!this.validateEditorInputState()) {
                return;
            }
            final String[] lookupName = new String[1];
            final IIndex index = CCorePlugin.getIndexManager().getIndex(this.fTu.getCProject(), 33);
            SharedASTJob job = new SharedASTJob(CEditorMessages.AddIncludeOnSelection_label, this.fTu){

                @Override
                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                    AddIncludeOnSelectionAction.this.deduceInclude((ITextSelection)selection, index, ast, lookupName);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            job.join();
            if ((this.fRequiredIncludes == null || this.fRequiredIncludes.length == 0 && lookupName[0].length() > 0) && (fs = this.findContribution(lookupName[0])) != null) {
                this.fRequiredIncludes = fs.getIncludes();
                String ns = fs.getNamespace();
                if (ns != null && ns.length() > 0) {
                    this.fUsingDeclarations = new String[]{fs.getNamespace()};
                }
            }
            if (this.fRequiredIncludes != null && this.fRequiredIncludes.length >= 0) {
                this.insertInclude(this.fRequiredIncludes, this.fUsingDeclarations, ((ITextSelection)selection).getOffset());
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (CoreException e) {
            CUIPlugin.log("Cannot perform 'Add Include'", e);
        }
    }

    private void deduceInclude(ITextSelection selection, IIndex index, IASTTranslationUnit ast, String[] lookupName) throws CoreException {
        IIndexMacro[] macros;
        IASTNodeSelector selector = ast.getNodeSelector(this.fTu.getLocation().toOSString());
        IASTName name = selector.findEnclosingName(selection.getOffset(), selection.getLength());
        if (name == null) {
            return;
        }
        char[] nameChars = name.toCharArray();
        lookupName[0] = new String(nameChars);
        IBinding binding = name.resolveBinding();
        if (binding instanceof ICPPVariable) {
            IType type = ((ICPPVariable)binding).getType();
            if ((type = SemanticUtil.getNestedType((IType)type, (int)180)) instanceof IBinding) {
                binding = (IBinding)type;
                nameChars = binding.getNameCharArray();
            }
        }
        if (nameChars.length == 0) {
            return;
        }
        HashMap<String, IncludeCandidate> candidatesMap = new HashMap<String, IncludeCandidate>();
        IndexFilter filter = IndexFilter.getDeclaredBindingFilter((int)ast.getLinkage().getLinkageID(), (boolean)false);
        ArrayList<IIndexBinding> bindings = new ArrayList<IIndexBinding>();
        IIndexBinding adaptedBinding = index.adaptBinding(binding);
        if (adaptedBinding == null) {
            bindings.addAll(Arrays.asList(index.findBindings(nameChars, false, filter, (IProgressMonitor)new NullProgressMonitor())));
        } else {
            bindings.add(adaptedBinding);
            while (adaptedBinding instanceof ICPPSpecialization) {
                if ((adaptedBinding = index.adaptBinding(((ICPPSpecialization)adaptedBinding).getSpecializedBinding())) == null) continue;
                bindings.add(adaptedBinding);
            }
        }
        for (IIndexBinding indexBinding : bindings) {
            if (indexBinding instanceof ICPPConstructor) {
                indexBinding = indexBinding.getOwner();
            }
            IIndexName[] definitions = null;
            if (indexBinding instanceof ICompositeType || indexBinding instanceof IEnumeration || indexBinding instanceof IEnumerator) {
                definitions = index.findDefinitions((IBinding)indexBinding);
            } else if (indexBinding instanceof ITypedef || indexBinding instanceof IFunction) {
                definitions = index.findDeclarations((IBinding)indexBinding);
            }
            if (definitions == null) continue;
            IIndexName[] iIndexNameArray = definitions;
            int n = definitions.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName definition = iIndexNameArray[n2];
                this.considerForInclusion(definition, indexBinding, index, candidatesMap);
                ++n2;
            }
            if (definitions.length > 0 && adaptedBinding != null) break;
        }
        IIndexMacro[] iIndexMacroArray = macros = index.findMacros(nameChars, filter, (IProgressMonitor)new NullProgressMonitor());
        int definition = macros.length;
        int definitions = 0;
        while (definitions < definition) {
            IIndexMacro macro = iIndexMacroArray[definitions];
            IIndexName definition2 = macro.getDefinition();
            this.considerForInclusion(definition2, (IIndexBinding)macro, index, candidatesMap);
            ++definitions;
        }
        final ArrayList candidates = new ArrayList(candidatesMap.values());
        if (candidates.size() > 1) {
            if (sIsJUnitTest) {
                throw new RuntimeException("ambiguous input");
            }
            this.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(AddIncludeOnSelectionAction.this.getShell(), (ILabelProvider)new LabelProvider());
                    dialog.setElements(candidates.toArray());
                    dialog.setTitle(CEditorMessages.AddIncludeOnSelection_label);
                    dialog.setMessage(CEditorMessages.AddIncludeOnSelection_description);
                    if (dialog.open() == 0) {
                        candidates.clear();
                        candidates.add((IncludeCandidate)dialog.getFirstResult());
                    }
                }
            });
        }
        this.fRequiredIncludes = null;
        this.fUsingDeclarations = null;
        if (candidates.size() == 1) {
            String usingDeclaration;
            IncludeCandidate candidate = (IncludeCandidate)candidates.get(0);
            this.fRequiredIncludes = new IRequiredInclude[]{candidate.getInclude()};
            IIndexBinding indexBinding = candidate.getBinding();
            if (indexBinding instanceof ICPPBinding && !(indexBinding instanceof IIndexMacro) && (usingDeclaration = this.deduceUsingDeclaration(binding, (IBinding)indexBinding, ast)) != null) {
                this.fUsingDeclarations = new String[]{usingDeclaration};
            }
        }
    }

    private void considerForInclusion(IIndexName definition, IIndexBinding binding, IIndex index, Map<String, IncludeCandidate> candidates) throws CoreException {
        IncludeCandidate candidate;
        IIndexFile representativeFile;
        IRequiredInclude include;
        if (definition == null) {
            return;
        }
        IIndexFile file = definition.getFile();
        if (!(this.isSource(AddIncludeOnSelectionAction.getPath(file)) && index.findIncludedBy(file, 0).length <= 0 || (include = this.getRequiredInclude(representativeFile = this.getRepresentativeFile(file, index), index)) == null || candidates.containsKey((candidate = new IncludeCandidate(binding, include)).toString()))) {
            candidates.put(candidate.toString(), candidate);
        }
    }

    private String deduceUsingDeclaration(IBinding source, IBinding target, IASTTranslationUnit ast) {
        int i;
        IASTDeclaration[] declarations;
        if (source.equals(target)) {
            return null;
        }
        ArrayList<String> targetChain = this.getUsingChain(target);
        if (targetChain.size() <= 1) {
            return null;
        }
        IASTDeclaration[] iASTDeclarationArray = declarations = ast.getDeclarations(false);
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            if (declaration.isPartOfTranslationUnitFile()) {
                IASTName name = null;
                if (declaration instanceof ICPPASTUsingDeclaration ? this.match(name = ((ICPPASTUsingDeclaration)declaration).getName(), targetChain, false) : declaration instanceof ICPPASTUsingDirective && this.match(name = ((ICPPASTUsingDirective)declaration).getQualifiedName(), targetChain, true)) {
                    return null;
                }
            }
            ++n2;
        }
        ArrayList<String> sourceChain = this.getUsingChain(source);
        if (sourceChain.size() >= targetChain.size()) {
            int j = targetChain.size();
            i = sourceChain.size();
            while (--j >= 1 && --i >= 1) {
                if (!sourceChain.get(i).equals(targetChain.get(j))) break;
            }
            if (j <= 0) {
                return null;
            }
        }
        StringBuilder buf = new StringBuilder();
        i = targetChain.size();
        while (--i >= 0) {
            if (buf.length() > 0) {
                buf.append("::");
            }
            buf.append(targetChain.get(i));
        }
        return buf.toString();
    }

    private boolean match(IASTName name, ArrayList<String> usingChain, boolean excludeLast) {
        IASTName[] names = name instanceof ICPPASTQualifiedName ? ((ICPPASTQualifiedName)name).getNames() : new IASTName[]{name};
        if (names.length != usingChain.size() - (excludeLast ? 1 : 0)) {
            return false;
        }
        int i = 0;
        while (i < names.length) {
            if (!names[i].toString().equals(usingChain.get(usingChain.size() - 1 - i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ArrayList<String> getUsingChain(IBinding binding) {
        ArrayList<String> chain = new ArrayList<String>(4);
        while (binding != null) {
            block3: {
                String name;
                block2: {
                    block1: {
                        name = binding.getName();
                        if (!(binding instanceof ICPPNamespace)) break block1;
                        if (name.length() != 0) break block2;
                        break block3;
                    }
                    chain.clear();
                }
                chain.add(name);
            }
            binding = binding.getOwner();
        }
        return chain;
    }

    private IIndexFile getRepresentativeFile(IIndexFile headerFile, IIndex index) {
        try {
            if (this.isWorkspaceFile(headerFile.getLocation().getURI())) {
                return headerFile;
            }
            ArrayDeque<IIndexFile> front = new ArrayDeque<IIndexFile>();
            front.add(headerFile);
            HashSet<IIndexFile> processed = new HashSet<IIndexFile>();
            processed.add(headerFile);
            while (!front.isEmpty()) {
                IIndexInclude[] includes;
                IIndexFile file = (IIndexFile)front.remove();
                if (this.fTu.isCXXLanguage() && !this.hasExtension(AddIncludeOnSelectionAction.getPath(file))) {
                    return file;
                }
                IIndexInclude[] iIndexIncludeArray = includes = index.findIncludedBy(file, 0);
                int n = includes.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexInclude include = iIndexIncludeArray[n2];
                    IIndexFile includer = include.getIncludedBy();
                    if (!processed.contains(includer)) {
                        URI uri = includer.getLocation().getURI();
                        if (this.isSource(uri.getPath()) || this.isWorkspaceFile(uri)) {
                            return file;
                        }
                        front.add(includer);
                        processed.add(includer);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return headerFile;
    }

    private boolean isWorkspaceFile(URI uri) {
        IFile[] iFileArray = ResourceLookup.findFilesForLocationURI((URI)uri);
        int n = iFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file.exists()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasExtension(String path) {
        return path.indexOf(46, path.lastIndexOf(47) + 1) >= 0;
    }

    private IFunctionSummary findContribution(final String name) {
        final IFunctionSummary[] fs = new IFunctionSummary[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ICHelpInvocationContext context = new ICHelpInvocationContext(){

                    @Override
                    public IProject getProject() {
                        return AddIncludeOnSelectionAction.this.fProject;
                    }

                    @Override
                    public ITranslationUnit getTranslationUnit() {
                        return AddIncludeOnSelectionAction.this.fTu;
                    }
                };
                fs[0] = CHelpProviderManager.getDefault().getFunctionInfo(context, name);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.AddIncludeOnSelection_error_title, CEditorMessages.AddIncludeOnSelection_help_provider_error);
        }
        catch (InterruptedException interruptedException) {}
        return fs[0];
    }

    private void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        this.setEnabled(editor != null && AddIncludeOnSelectionAction.getTranslationUnit(editor) != null);
    }

    private boolean isSource(String filename) {
        String id;
        IContentType ct = CCorePlugin.getContentType((IProject)this.fProject, (String)filename);
        return ct != null && ("org.eclipse.cdt.core.cSource".equals(id = ct.getId()) || "org.eclipse.cdt.core.cxxSource".equals(id));
    }

    private static String getPath(IIndexFile file) throws CoreException {
        return file.getLocation().getURI().getPath();
    }

    private IRequiredInclude getRequiredInclude(IIndexFile file, IIndex index) throws CoreException {
        IIndexInclude[] includes = index.findIncludedBy(file);
        if (includes.length > 0) {
            int systemIncludeVotes = 0;
            Object[] ballotBox = new String[includes.length];
            int k = 0;
            IIndexInclude[] iIndexIncludeArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexInclude include = iIndexIncludeArray[n2];
                if (this.isResolvable(include)) {
                    ballotBox[k++] = include.getFullName();
                    if (include.isSystemInclude()) {
                        ++systemIncludeVotes;
                    }
                }
                ++n2;
            }
            if (k != 0) {
                Arrays.sort(ballotBox, 0, k);
                Object contender = ballotBox[0];
                int votes = 1;
                Object winner = contender;
                int winnerVotes = votes;
                int i = 1;
                while (i < k) {
                    if (!((String)ballotBox[i]).equals(contender)) {
                        contender = ballotBox[i];
                        votes = 1;
                    }
                    if (++votes > winnerVotes) {
                        winner = contender;
                        winnerVotes = votes;
                    }
                    ++i;
                }
                return new RequiredInclude((String)winner, systemIncludeVotes * 2 >= k);
            }
        }
        URI targetUri = file.getLocation().getURI();
        IPath targetLocation = PathUtil.getCanonicalPath((IPath)new Path(targetUri.getPath()));
        IPath sourceLocation = PathUtil.getCanonicalPath((IPath)this.fTu.getResource().getLocation());
        boolean isSystemIncludePath = false;
        IPath path = PathUtil.makeRelativePathToIncludes((IPath)targetLocation, (String[])this.fIncludePath);
        if (path != null && ResourceLookup.findFilesForLocationURI((URI)targetUri).length == 0) {
            isSystemIncludePath = true;
        }
        if (path == null) {
            IPath sourceDirectory = sourceLocation.removeLastSegments(1);
            path = PathUtil.isPrefix((IPath)sourceDirectory, (IPath)targetLocation) ? targetLocation.removeFirstSegments(sourceDirectory.segmentCount()) : targetLocation;
            if (targetLocation.getDevice() != null && targetLocation.getDevice().equalsIgnoreCase(sourceDirectory.getDevice())) {
                path = path.setDevice(null);
            }
            if (path.isAbsolute() && path.getDevice() == null && ResourceLookup.findFilesForLocationURI((URI)targetUri).length != 0) {
                path = PathUtil.makeRelativePath((IPath)path, (IPath)sourceDirectory);
            }
        }
        return new RequiredInclude(path.toString(), isSystemIncludePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isResolvable(IIndexInclude include) {
        try {
            File target = new File(include.getIncludesLocation().getURI().getPath());
            String includeName = include.getFullName();
            String[] stringArray = this.fIncludePath;
            int n = this.fIncludePath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (!include.isSystemInclude()) break;
                    return false;
                }
                String dir = stringArray[n2];
                if (target.equals(new File(dir, includeName))) {
                    return true;
                }
                ++n2;
            }
            String directory = new File(this.fTu.getLocationURI().getPath()).getParent();
            return target.equals(new File(directory, includeName).getCanonicalFile());
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return false;
        }
        catch (IOException e) {
            CUIPlugin.log(e);
            return false;
        }
    }

    private static String getBindingQualifiedName(IIndexBinding binding) throws CoreException {
        String[] qname = CPPVisitor.getQualifiedName((IBinding)binding);
        StringBuilder result = new StringBuilder();
        boolean needSep = false;
        String[] stringArray = qname;
        int n = qname.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (needSep) {
                result.append(Keywords.cpCOLONCOLON);
            }
            result.append(element);
            needSep = true;
            ++n2;
        }
        return result.toString();
    }

    private static class IncludeCandidate {
        private final IIndexBinding binding;
        private final IRequiredInclude include;
        private final String label;

        public IncludeCandidate(IIndexBinding binding, IRequiredInclude include) throws CoreException {
            this.binding = binding;
            this.include = include;
            this.label = String.valueOf(AddIncludeOnSelectionAction.getBindingQualifiedName(binding)) + " - " + include.toString();
        }

        public IIndexBinding getBinding() {
            return this.binding;
        }

        public IRequiredInclude getInclude() {
            return this.include;
        }

        public String toString() {
            return this.label;
        }
    }

    private static class RequiredInclude
    implements IRequiredInclude {
        final String includeName;
        final boolean isSystem;

        RequiredInclude(String includeName, boolean isSystem) {
            this.includeName = includeName;
            this.isSystem = isSystem;
        }

        @Override
        public String getIncludeName() {
            return this.includeName;
        }

        @Override
        public boolean isStandard() {
            return this.isSystem;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.includeName.length() + 2);
            buf.append(this.isSystem ? (char)'<' : '\"');
            buf.append(this.includeName);
            buf.append(this.isSystem ? (char)'>' : '\"');
            return buf.toString();
        }
    }
}

