/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.parser;

import java.text.MessageFormat;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;

public class SpecfileSection
extends SpecfileElement {
    private SpecfilePackage parentPackage = null;
    private int sectionEndLine;

    public SpecfileSection(String name, Specfile specfile) {
        super(name);
        super.setSpecfile(specfile);
    }

    public SpecfilePackage getPackage() {
        return this.parentPackage;
    }

    public void setPackage(SpecfilePackage thePackage) {
        this.parentPackage = thePackage;
    }

    public String toString() {
        if (this.parentPackage == null) {
            return this.getName();
        }
        return MessageFormat.format("{0} {1}", this.getName(), this.parentPackage);
    }

    public String getPackageName() {
        return this.parentPackage.getPackageName();
    }

    public void setSectionEndLine(int sectionEnd) {
        this.sectionEndLine = sectionEnd;
    }

    public int getSectionEndLine() {
        return this.sectionEndLine;
    }

    public String getContents() {
        IDocument document = this.getSpecfile().getDocument();
        int beginning = this.getLineStartPosition();
        try {
            int end = document.getLineOffset(this.getSectionEndLine());
            return document.get(beginning, end - beginning);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setContents(String newContent) {
    }
}

