/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.refactorings.simple;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.rephraserengine.core.refactorings.IEditorRefactoring;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class SimpleEditorRefactoring
extends Refactoring
implements IEditorRefactoring {
    protected IFile file;
    protected ITextSelection selection;
    protected TextFileChange change;

    @Override
    public final void initialize(IFile file, ITextSelection selection) {
        this.file = file;
        this.selection = selection;
        this.change = new TextFileChange(this.getName(), file);
    }

    public final RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            this.beforeUserInput();
        }
        catch (PreconditionFailure e) {
            status.addFatalError(e.getMessage());
        }
        catch (Exception e) {
            status.addFatalError(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getMessage());
        }
        return status;
    }

    protected void beforeUserInput() throws Exception {
    }

    public final RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            String newFileContents = this.perform();
            this.change.initializeValidationData(pm);
            this.change.setEdit((TextEdit)new ReplaceEdit(0, this.countCharsIn(this.file), newFileContents));
        }
        catch (PreconditionFailure e) {
            status.addFatalError(e.getMessage());
        }
        catch (Exception e) {
            status.addFatalError(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getMessage());
        }
        return status;
    }

    private int countCharsIn(IFile file) throws CoreException, IOException {
        int size = 0;
        BufferedReader in = new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset()));
        while (((Reader)in).read() > -1) {
            ++size;
        }
        ((Reader)in).close();
        return size;
    }

    protected abstract String perform() throws Exception;

    protected final void fail(String message) throws PreconditionFailure {
        throw new PreconditionFailure(message);
    }

    protected <T> T findSelected(Class<T> nodeType, Object node) {
        block4: {
            try {
                Method getChildren = node.getClass().getMethod("getChildren", new Class[0]);
                for (Object child : (Iterable)getChildren.invoke(node, new Object[0])) {
                    T result = this.findSelected(nodeType, child);
                    if (result == null) continue;
                    return result;
                }
                if (!nodeType.isAssignableFrom(node.getClass())) break block4;
                Object firstToken = node.getClass().getMethod("findFirstToken", new Class[0]).invoke(node, new Object[0]);
                Object lastToken = node.getClass().getMethod("findLastToken", new Class[0]).invoke(node, new Object[0]);
                if (firstToken == null || lastToken == null) break block4;
                int firstOffset = (Integer)firstToken.getClass().getMethod("getOffset", new Class[0]).invoke(firstToken, new Object[0]);
                int lastOffset = (Integer)lastToken.getClass().getMethod("getOffset", new Class[0]).invoke(lastToken, new Object[0]);
                if (this.selection.getLength() == 0 && firstOffset <= this.selection.getOffset() && this.selection.getOffset() < (lastOffset += ((Integer)lastToken.getClass().getMethod("getLength", new Class[0]).invoke(lastToken, new Object[0])).intValue())) {
                    return (T)node;
                }
                if (this.selection.getOffset() != firstOffset || this.selection.getLength() != lastOffset - firstOffset) break block4;
                return (T)node;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        return null;
    }

    public final Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.change;
    }

    @Override
    public String getName() {
        String name = this.getClass().getSimpleName();
        if (name.toLowerCase().endsWith("refactoring")) {
            name = name.substring(0, name.length() - "refactoring".length());
        }
        StringBuilder sb = new StringBuilder(64);
        int i = 0;
        int len = name.length();
        while (i < len) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append(" " + c);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    protected static final class PreconditionFailure
    extends Exception {
        public PreconditionFailure(String message) {
            super(message);
        }
    }
}

