/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSWizardHandler;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.newui.PageLayout;
import org.eclipse.cdt.ui.wizards.CDTMainWizardPage;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.Activator;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.ui.wizards.SyncWizardDataCache;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.widgets.SyncProjectWidget;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class SyncMainWizardPage
extends CDTMainWizardPage
implements IWizardItemsListListener {
    public static final String REMOTE_SYNC_WIZARD_PAGE_ID = "org.eclipse.ptp.rdt.sync.cdt.ui.remoteSyncWizardPage";
    public static final String SERVICE_PROVIDER_PROPERTY = "org.eclipse.ptp.rdt.sync.cdt.ui.remoteSyncWizardPage.serviceProvider";
    public static final String DESC = "EntryDescriptor";
    private static final String RDT_PROJECT_TYPE = "org.eclipse.ptp.rdt";
    private static final Image IMG_CATEGORY = CDTSharedImages.getImage((String)"icons/obj16/fldr_obj.gif");
    private static final Image IMG_ITEM = CDTSharedImages.getImage((String)"icons/obj16/variable_obj.gif");
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.CDTWizard";
    private static final String ELEMENT_NAME = "wizard";
    private static final String CLASS_NAME = "class";
    private static final String EMPTY_STRING = "";
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String projectNameKey = "project-name";
    private static final String syncConfigSetKey = "sync-config-set";
    private static final String toolChainMapKey = "toolchain-map";
    private Text projectNameField;
    private Tree projectTypeTree;
    private Composite allToolChainsHiddenComposite;
    private Composite remoteToolChain;
    private Composite localToolChain;
    private Table remoteToolChainTable;
    private Table localToolChainTable;
    private Button showSupportedOnlyButton;
    private Label projectRemoteOptionsLabel;
    private Label projectLocalOptionsLabel;
    private Label categorySelectedForRemoteLabel;
    private Label categorySelectedForLocalLabel;
    private SyncProjectWidget fSyncWidget;
    private SortedMap<String, IToolChain> toolChainMap;
    private String message = null;
    private int messageType = 0;
    private String errorMessage = null;

    public SyncMainWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite);
        this.createProjectBasicInfoGroup(composite);
        this.createProjectRemoteInfoGroup(composite);
        this.createProjectDetailedInfoGroup(composite);
        this.switchTo(this.updateData(this.projectTypeTree, this.allToolChainsHiddenComposite, false, this, this.getWizard()), SyncMainWizardPage.getDescriptor(this.projectTypeTree));
        this.allToolChainsHiddenComposite.setLayout((Layout)new StackLayout());
        this.setPageComplete(false);
        this.errorMessage = null;
        this.message = null;
        this.messageType = 0;
        Dialog.applyDialogFont((Control)composite);
    }

    private void createProjectDetailedInfoGroup(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        c.setLayout((Layout)new GridLayout(2, true));
        Label left_label = new Label(c, 0);
        left_label.setText(Messages.SyncMainWizardPage_0);
        left_label.setFont(parent.getFont());
        left_label.setLayoutData((Object)new GridData(1));
        this.projectRemoteOptionsLabel = new Label(c, 0);
        this.projectRemoteOptionsLabel.setFont(parent.getFont());
        this.projectRemoteOptionsLabel.setLayoutData((Object)new GridData(1));
        this.projectRemoteOptionsLabel.setText(Messages.SyncMainWizardPage_1);
        this.projectTypeTree = new Tree(c, 2052);
        this.projectTypeTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.projectTypeTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] tis = SyncMainWizardPage.this.projectTypeTree.getSelection();
                if (tis == null || tis.length == 0) {
                    return;
                }
                SyncMainWizardPage.this.switchTo((CWizardHandler)tis[0].getData(), (EntryDescriptor)tis[0].getData(SyncMainWizardPage.DESC));
                SyncMainWizardPage.this.update();
                SyncMainWizardPage.this.getWizard().getContainer().updateMessage();
            }
        });
        this.projectTypeTree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                int i = 0;
                while (i < SyncMainWizardPage.this.projectTypeTree.getItemCount()) {
                    if (SyncMainWizardPage.this.projectTypeTree.getItem(i).getText().equals(e.result)) {
                        return;
                    }
                    ++i;
                }
                e.result = Messages.SyncMainWizardPage_2;
            }
        });
        this.allToolChainsHiddenComposite = new Composite(c.getParent(), 0);
        this.allToolChainsHiddenComposite.setVisible(false);
        this.remoteToolChain = new Composite(c, 0);
        this.remoteToolChain.setLayoutData((Object)new GridData(4, 4, true, true));
        this.remoteToolChain.setLayout((Layout)new PageLayout());
        this.remoteToolChainTable = new Table(this.remoteToolChain, 2562);
        this.remoteToolChainTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SyncMainWizardPage.this.updateHiddenToolChainList();
                SyncMainWizardPage.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SyncMainWizardPage.this.updateHiddenToolChainList();
                SyncMainWizardPage.this.update();
            }
        });
        this.remoteToolChainTable.setVisible(true);
        this.projectLocalOptionsLabel = new Label(c, 0);
        this.projectLocalOptionsLabel.setFont(parent.getFont());
        this.projectLocalOptionsLabel.setLayoutData((Object)new GridData(1));
        this.projectLocalOptionsLabel.setText(Messages.SyncMainWizardPage_3);
        this.localToolChain = new Composite(c, 0);
        this.localToolChain.setLayoutData((Object)new GridData(4, 4, true, true));
        this.localToolChain.setLayout((Layout)new PageLayout());
        this.localToolChainTable = new Table(this.localToolChain, 2562);
        this.localToolChainTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SyncMainWizardPage.this.updateHiddenToolChainList();
                SyncMainWizardPage.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SyncMainWizardPage.this.updateHiddenToolChainList();
                SyncMainWizardPage.this.update();
            }
        });
        this.localToolChainTable.setVisible(true);
        this.showSupportedOnlyButton = new Button(c, 32);
        this.showSupportedOnlyButton.setText(Messages.SyncMainWizardPage_4);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.showSupportedOnlyButton.setLayoutData((Object)gd);
        this.showSupportedOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncMainWizardPage.this.switchTo(SyncMainWizardPage.this.updateData(SyncMainWizardPage.this.projectTypeTree, SyncMainWizardPage.this.allToolChainsHiddenComposite, false, SyncMainWizardPage.this, SyncMainWizardPage.this.getWizard()), SyncMainWizardPage.getDescriptor(SyncMainWizardPage.this.projectTypeTree));
            }
        });
        this.showSupportedOnlyButton.setSelection(false);
    }

    public IWizardPage getNextPage() {
        return this.h_selected == null ? null : this.h_selected.getSpecificPage();
    }

    public IPath getLocationPath() {
        return new Path(this.fSyncWidget.getProjectLocalLocation());
    }

    public URI getLocationURI() {
        try {
            return new URI("file://" + this.getLocationPath().toString());
        }
        catch (URISyntaxException e) {
            Activator.log(e);
            return null;
        }
    }

    public URI getProjectLocation() {
        return this.useDefaults() ? null : this.getLocationURI();
    }

    protected boolean validatePage() {
        this.message = null;
        this.messageType = 0;
        this.errorMessage = null;
        if (!this.validateProjectName() || !this.validateProjectTypeSelection()) {
            return false;
        }
        if (!this.fSyncWidget.isPageComplete()) {
            this.message = this.fSyncWidget.getMessage();
            this.messageType = this.fSyncWidget.getMessageType();
            this.errorMessage = this.fSyncWidget.getErrorMessage();
            return false;
        }
        return true;
    }

    protected boolean validateProjectName() {
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals(EMPTY_STRING)) {
            this.message = Messages.SyncMainWizardPage_5;
            this.messageType = 0;
            return false;
        }
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.errorMessage = nameStatus.getMessage();
            return false;
        }
        if (this.getProjectName().indexOf(35) >= 0) {
            this.errorMessage = Messages.SyncMainWizardPage_6;
            return false;
        }
        return true;
    }

    protected boolean validateProjectTypeSelection() {
        if (this.projectTypeTree.getItemCount() == 0) {
            this.errorMessage = Messages.SyncMainWizardPage_10;
            return false;
        }
        if (this.h_selected == null) {
            this.message = Messages.SyncMainWizardPage_11;
            this.messageType = 0;
            return false;
        }
        String s = this.h_selected.getErrorMessage();
        if (s != null) {
            this.errorMessage = s;
            return false;
        }
        return true;
    }

    public String getMessage() {
        this.update();
        return this.message;
    }

    public int getMessageType() {
        this.update();
        return this.messageType;
    }

    public String getErrorMessage() {
        this.update();
        return this.errorMessage;
    }

    public CWizardHandler updateData(Tree tree, Composite right, boolean show_sup, IWizardItemsListListener ls, IWizard wizard) {
        TreeItem[] selection = tree.getSelection();
        TreeItem selectedItem = selection.length > 0 ? selection[0] : null;
        String savedLabel = selectedItem != null ? selectedItem.getText() : null;
        String savedParentLabel = SyncMainWizardPage.getParentText(selectedItem);
        tree.removeAll();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return null;
        }
        List<Object> items = new ArrayList<EntryDescriptor>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(ELEMENT_NAME)) {
                    CNewWizard w = null;
                    try {
                        w = (CNewWizard)element.createExecutableExtension(CLASS_NAME);
                    }
                    catch (CoreException e) {
                        System.out.println(String.valueOf(Messages.SyncMainWizardPage_12) + e.getLocalizedMessage());
                        return null;
                    }
                    if (w == null) {
                        return null;
                    }
                    w.setDependentControl(right, ls);
                    EntryDescriptor[] entryDescriptorArray = w.createItems(show_sup, wizard);
                    int n5 = entryDescriptorArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        EntryDescriptor ed = entryDescriptorArray[n6];
                        items.add(ed);
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        int i = 0;
        while (i < items.size()) {
            EntryDescriptor ed = (EntryDescriptor)items.get(i);
            if (ed.isDefaultForCategory()) {
                items.remove(i);
                items.add(0, ed);
                break;
            }
            ++i;
        }
        if (ls != null) {
            items = ls.filterItems(items);
        }
        SyncMainWizardPage.addItemsToTree(tree, items);
        if (tree.getItemCount() > 0) {
            TreeItem target = null;
            if (savedLabel != null) {
                target = SyncMainWizardPage.findItem(tree, savedLabel, savedParentLabel);
            }
            if (target == null) {
                target = tree.getItem(0);
            }
            tree.setSelection(target);
            return (CWizardHandler)target.getData();
        }
        return null;
    }

    private static String getParentText(TreeItem item) {
        if (item == null || item.getParentItem() == null) {
            return EMPTY_STRING;
        }
        return item.getParentItem().getText();
    }

    private static TreeItem findItem(Tree tree, String label, String parentLabel) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            TreeItem foundItem = SyncMainWizardPage.findTreeItem(item, label, parentLabel);
            if (foundItem != null) {
                return foundItem;
            }
            ++n2;
        }
        return null;
    }

    private static TreeItem findTreeItem(TreeItem item, String label, String parentLabel) {
        if (item.getText().equals(label) && SyncMainWizardPage.getParentText(item).equals(parentLabel)) {
            return item;
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            TreeItem foundItem = SyncMainWizardPage.findTreeItem(child, label, parentLabel);
            if (foundItem != null) {
                return foundItem;
            }
            ++n2;
        }
        return null;
    }

    private static void addItemsToTree(Tree tree, List<EntryDescriptor> items) {
        boolean found;
        ArrayList<TreeItem> placedTreeItemsList = new ArrayList<TreeItem>(items.size());
        ArrayList<EntryDescriptor> placedEntryDescriptorsList = new ArrayList<EntryDescriptor>(items.size());
        for (EntryDescriptor wd : items) {
            if (wd.getParentId() != null) continue;
            wd.setPath(wd.getId());
            TreeItem ti = new TreeItem(tree, 0);
            ti.setText(TextProcessor.process((String)wd.getName()));
            ti.setData((Object)wd.getHandler());
            ti.setData(DESC, (Object)wd);
            ti.setImage(SyncMainWizardPage.calcImage(wd));
            placedTreeItemsList.add(ti);
            placedEntryDescriptorsList.add(wd);
        }
        do {
            found = false;
            block2: for (EntryDescriptor wd1 : items) {
                if (wd1.getParentId() == null) continue;
                int i = 0;
                while (i < placedEntryDescriptorsList.size()) {
                    EntryDescriptor wd2 = (EntryDescriptor)placedEntryDescriptorsList.get(i);
                    if (wd2.getId().equals(wd1.getParentId())) {
                        found = true;
                        wd1.setParentId(null);
                        CWizardHandler h = wd2.getHandler();
                        if (h == null && wd1.getHandler() == null && !wd1.isCategory()) continue block2;
                        wd1.setPath(String.valueOf(wd2.getPath()) + "/" + wd1.getId());
                        wd1.setParent(wd2);
                        if (h != null) {
                            if (wd1.getHandler() == null && !wd1.isCategory()) {
                                wd1.setHandler((CWizardHandler)h.clone());
                            }
                            if (!h.isApplicable(wd1)) continue block2;
                        }
                        TreeItem p = (TreeItem)placedTreeItemsList.get(i);
                        TreeItem ti = new TreeItem(p, 0);
                        ti.setText(wd1.getName());
                        ti.setData((Object)wd1.getHandler());
                        ti.setData(DESC, (Object)wd1);
                        ti.setImage(SyncMainWizardPage.calcImage(wd1));
                        placedTreeItemsList.add(ti);
                        placedEntryDescriptorsList.add(wd1);
                        continue block2;
                    }
                    ++i;
                }
            }
        } while (found);
    }

    private static Image calcImage(EntryDescriptor ed) {
        if (ed.getImage() != null) {
            return ed.getImage();
        }
        if (ed.isCategory()) {
            return IMG_CATEGORY;
        }
        return IMG_ITEM;
    }

    private void switchTo(CWizardHandler h, EntryDescriptor ed) {
        if (h == null) {
            h = ed.getHandler();
        }
        if (ed.isCategory()) {
            h = null;
        }
        try {
            if (h != null) {
                h.initialize(ed);
            }
        }
        catch (CoreException coreException) {
            h = null;
        }
        if (this.h_selected != null) {
            this.h_selected.handleUnSelection();
        }
        this.h_selected = h;
        if (h == null) {
            if (ed.isCategory()) {
                if (this.categorySelectedForRemoteLabel == null) {
                    this.categorySelectedForRemoteLabel = new Label(this.remoteToolChain, 64);
                    this.categorySelectedForRemoteLabel.setText(Messages.SyncMainWizardPage_13);
                    this.remoteToolChain.layout();
                }
                if (this.categorySelectedForLocalLabel == null) {
                    this.categorySelectedForLocalLabel = new Label(this.localToolChain, 64);
                    this.categorySelectedForLocalLabel.setText(Messages.SyncMainWizardPage_13);
                    this.localToolChain.layout();
                }
            }
            return;
        }
        if (this.categorySelectedForRemoteLabel != null) {
            this.categorySelectedForRemoteLabel.setVisible(false);
        }
        if (this.categorySelectedForLocalLabel != null) {
            this.categorySelectedForLocalLabel.setVisible(false);
        }
        this.h_selected.handleSelection();
        this.h_selected.setSupportedOnly(false);
        this.remoteToolChainTable.removeAll();
        this.toolChainMap = ((MBSWizardHandler)this.h_selected).getToolChains();
        SyncMainWizardPage.filterIncompatibleToolChains(this.toolChainMap);
        for (String name : this.toolChainMap.keySet()) {
            TableItem ti = new TableItem(this.remoteToolChainTable, 0);
            ti.setText(name);
        }
        if (this.toolChainMap.keySet().size() > 0) {
            this.remoteToolChainTable.select(0);
        }
        this.localToolChainTable.removeAll();
        this.toolChainMap = ((MBSWizardHandler)this.h_selected).getToolChains();
        SyncMainWizardPage.filterIncompatibleToolChains(this.toolChainMap);
        boolean filterToolChains = this.showSupportedOnlyButton.getSelection();
        for (Map.Entry<String, IToolChain> entry : this.toolChainMap.entrySet()) {
            String name = entry.getKey();
            IToolChain tc = entry.getValue();
            if (filterToolChains && tc != null && (!tc.isSupported() || !ManagedBuildManager.isPlatformOk((IToolChain)tc))) continue;
            TableItem ti = new TableItem(this.localToolChainTable, 0);
            ti.setText(name);
        }
        this.updateHiddenToolChainList();
    }

    private static void filterIncompatibleToolChains(Map<String, IToolChain> toolChainMap) {
        Iterator<Map.Entry<String, IToolChain>> iter = toolChainMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, IToolChain> entry = iter.next();
            IToolChain tc = entry.getValue();
            if (tc == null || !tc.getId().startsWith(RDT_PROJECT_TYPE)) continue;
            iter.remove();
        }
    }

    public static EntryDescriptor getDescriptor(Tree _tree) {
        TreeItem[] sel = _tree.getSelection();
        if (sel == null || sel.length == 0) {
            return null;
        }
        return (EntryDescriptor)sel[0].getData(DESC);
    }

    public void toolChainListChanged(int count) {
        this.update();
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isCurrent() {
        return this.isCurrentPage();
    }

    public List filterItems(List items) {
        Iterator iterator = items.iterator();
        LinkedList<EntryDescriptor> filteredList = new LinkedList<EntryDescriptor>();
        while (iterator.hasNext()) {
            EntryDescriptor ed = (EntryDescriptor)iterator.next();
            if (ed.getId().startsWith(RDT_PROJECT_TYPE)) continue;
            filteredList.add(ed);
        }
        return filteredList;
    }

    private final void createProjectBasicInfoGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectNameLabel = new Label(projectGroup, 0);
        projectNameLabel.setText(Messages.SyncMainWizardPage_14);
        projectNameLabel.setFont(parent.getFont());
        this.projectNameField = new Text(projectGroup, 2048);
        GridData nameData = new GridData(768);
        nameData.widthHint = 250;
        this.projectNameField.setLayoutData((Object)nameData);
        this.projectNameField.setFont(parent.getFont());
        this.projectNameField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (SyncMainWizardPage.this.fSyncWidget != null && (SyncMainWizardPage.this.validateProjectName() || SyncMainWizardPage.this.getProjectName().equals(SyncMainWizardPage.EMPTY_STRING))) {
                    SyncMainWizardPage.this.fSyncWidget.setProjectName(SyncMainWizardPage.this.getProjectName());
                }
                SyncMainWizardPage.this.update();
                SyncMainWizardPage.this.getWizard().getContainer().updateMessage();
            }
        });
    }

    private final void createProjectRemoteInfoGroup(Composite parent) {
        this.fSyncWidget = SyncProjectWidget.newProjectWidget((Composite)parent, (int)0, (IRunnableContext)this.getWizard().getContainer());
        this.fSyncWidget.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fSyncWidget.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                SyncMainWizardPage.this.update();
                SyncMainWizardPage.this.getWizard().getContainer().updateMessage();
            }
        });
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return EMPTY_STRING;
        }
        return this.projectNameField.getText().trim();
    }

    public void setInitialProjectName(String name) {
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean useDefaults() {
        return this.fSyncWidget.useDefaults();
    }

    public ISynchronizeParticipant getSynchronizeParticipant() {
        return this.fSyncWidget.getSynchronizeParticipant();
    }

    public IToolChain getLocalToolChain() {
        TableItem[] selectedToolChains = this.localToolChainTable.getSelection();
        if (selectedToolChains.length < 1) {
            return null;
        }
        String toolChainName = selectedToolChains[0].getText();
        return (IToolChain)this.toolChainMap.get(toolChainName);
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return null;
    }

    private void updateHiddenToolChainList() {
        TableItem ti;
        HashSet<String> currentSelections = new HashSet<String>();
        if (this.remoteToolChainTable.getSelectionCount() == 0 && this.remoteToolChainTable.getItemCount() > 0) {
            this.remoteToolChainTable.select(0);
        }
        TableItem[] tableItemArray = this.remoteToolChainTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ti = tableItemArray[n2];
            currentSelections.add(ti.getText());
            ++n2;
        }
        tableItemArray = this.localToolChainTable.getSelection();
        n = tableItemArray.length;
        n2 = 0;
        while (n2 < n) {
            ti = tableItemArray[n2];
            currentSelections.add(ti.getText());
            ++n2;
        }
        Table hiddenTable = ((MBSWizardHandler)this.h_selected).getToolChainsTable();
        hiddenTable.deselectAll();
        int i = 0;
        while (i < hiddenTable.getItemCount()) {
            String toolChainName = hiddenTable.getItem(i).getText();
            if (currentSelections.contains(toolChainName)) {
                hiddenTable.select(i);
            }
            ++i;
        }
        this.h_selected.handleSelection();
    }

    public Set<String> getLocalToolChains() {
        HashSet<String> localToolChainsSet = new HashSet<String>();
        TableItem[] tableItemArray = this.localToolChainTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            String name = ti.getText();
            if (name.equals("-- Other Toolchain --")) {
                name = "No ToolChain";
            }
            localToolChainsSet.add(name);
            ++n2;
        }
        return localToolChainsSet;
    }

    public Set<String> getRemoteToolChains() {
        HashSet<String> remoteToolChainsSet = new HashSet<String>();
        TableItem[] tableItemArray = this.remoteToolChainTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            String name = ti.getText();
            if (name.equals("-- Other Toolchain --")) {
                name = "No ToolChain";
            }
            remoteToolChainsSet.add(name);
            ++n2;
        }
        return remoteToolChainsSet;
    }

    public AbstractSyncFileFilter getCustomFileFilter() {
        return this.fSyncWidget.getCustomFileFilter();
    }

    private void update() {
        boolean isValid = this.validatePage();
        this.setPageComplete(isValid);
        if (isValid) {
            HashSet<String> configNamesSet = new HashSet<String>();
            String[] stringArray = this.getSyncConfigNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                configNamesSet.add(name);
                ++n2;
            }
            SyncWizardDataCache.setProperty((String)projectNameKey, (String)this.getProjectName());
            SyncWizardDataCache.setMultiValueProperty((String)syncConfigSetKey, configNamesSet);
            SyncWizardDataCache.setMap((String)toolChainMapKey, this.getSyncConfigToToolChainMap());
        }
    }

    private String[] getSyncConfigNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        configNames.add("Local");
        String remoteConfigName = this.fSyncWidget.getSyncConfigName();
        if (remoteConfigName != null) {
            configNames.add(remoteConfigName);
        }
        return configNames.toArray(new String[0]);
    }

    private Map<String, String> getSyncConfigToToolChainMap() {
        HashMap<String, String> syncConfigToToolChainMap = new HashMap<String, String>();
        Set<String> localToolChains = this.getLocalToolChains();
        String defaultLocalToolChainName = null;
        if (localToolChains.size() > 0) {
            defaultLocalToolChainName = localToolChains.iterator().next();
        }
        Set<String> remoteToolChains = this.getRemoteToolChains();
        String defaultRemoteToolChainName = null;
        if (remoteToolChains.size() > 0) {
            defaultRemoteToolChainName = remoteToolChains.iterator().next();
        }
        String[] stringArray = this.getSyncConfigNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String syncConfigName = stringArray[n2];
            if (syncConfigName.equals("Local") && defaultLocalToolChainName != null) {
                syncConfigToToolChainMap.put(syncConfigName, defaultLocalToolChainName);
            } else if (defaultRemoteToolChainName != null) {
                syncConfigToToolChainMap.put(syncConfigName, defaultRemoteToolChainName);
            }
            ++n2;
        }
        return syncConfigToToolChainMap;
    }
}

