/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.jaxb.util;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.internal.etfw.jaxb.data.ToolStateRuleType;

public class ToolStateRuleUtil {
    public static boolean evaluate(ILaunchConfiguration configuration, ToolStateRuleType toolStateRuleType) {
        if (toolStateRuleType.getNot() != null) {
            boolean result = ToolStateRuleUtil.evaluate(configuration, toolStateRuleType.getNot());
            return result;
        }
        if (toolStateRuleType.getAnd() != null) {
            boolean result = ToolStateRuleUtil.evaluate(configuration, toolStateRuleType.getAnd());
            return result;
        }
        if (toolStateRuleType.getOr() != null) {
            boolean result = ToolStateRuleUtil.evaluate(configuration, toolStateRuleType.getOr());
            return result;
        }
        if (toolStateRuleType.getAttribute() != null) {
            boolean result = ToolStateRuleUtil.evaluate(configuration, toolStateRuleType.getAttribute(), toolStateRuleType.getValue());
            return result;
        }
        return true;
    }

    public static boolean evaluate(ILaunchConfiguration configuration, ToolStateRuleType.Not toolStateRuleTypeNot) {
        boolean result = !ToolStateRuleUtil.evaluate(configuration, toolStateRuleTypeNot.getRule());
        return result;
    }

    public static boolean evaluate(ILaunchConfiguration configuration, ToolStateRuleType.And toolStateRuleTypeAnd) {
        List<ToolStateRuleType> list = toolStateRuleTypeAnd.getRule();
        for (ToolStateRuleType rule : list) {
            if (ToolStateRuleUtil.evaluate(configuration, rule)) continue;
            return false;
        }
        return true;
    }

    public static boolean evaluate(ILaunchConfiguration configuration, ToolStateRuleType.Or toolStateRuleTypeOr) {
        List<ToolStateRuleType> list = toolStateRuleTypeOr.getRule();
        for (ToolStateRuleType rule : list) {
            if (!ToolStateRuleUtil.evaluate(configuration, rule)) continue;
            return true;
        }
        return false;
    }

    public static boolean evaluate(ILaunchConfiguration configuration, String ruleAttribute, String ruleValue) {
        if (ruleValue != null) {
            try {
                Map attrs = configuration.getAttributes();
                for (Object key : attrs.keySet()) {
                    if (!(key instanceof String)) continue;
                    ((String)key).endsWith("x");
                }
                String configurationValue = configuration.getAttribute(ruleAttribute, null);
                if (configurationValue != null) {
                    boolean result = ruleValue.equals(configurationValue);
                    return result;
                }
            }
            catch (CoreException coreException) {}
        } else {
            try {
                String value = configuration.getAttribute(ruleAttribute, null);
                if (value != null) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }
}

