/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.timestamp;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimestampFormatUpdateSignal;

public class TmfTimestampFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = 2835829763122454020L;
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss.SSS CCC NNN";
    public static final String DEFAULT_INTERVAL_PATTERN = "TTT.SSS CCC NNN";
    private static final String DOT_RE = "\\.";
    private static final String SEP_RE = "[ \\.,-_:;/\\\"]?";
    private static final String DGTS_3_RE = "(\\d{3})";
    private static final String DGTS_13_RE = "(\\d{1,3})";
    private static final String MILLISEC_RE = "\\.(\\d{1,3})";
    private static final String MICROSEC_RE = "\\.(\\d{3})[ \\.,-_:;/\\\"]?(\\d{1,3})";
    private static final String NANOSEC_RE = "\\.(\\d{3})[ \\.,-_:;/\\\"]?(\\d{3})[ \\.,-_:;/\\\"]?(\\d{1,3})";
    private static final Pattern MILLISEC_PAT = Pattern.compile("\\.(\\d{1,3})");
    private static final Pattern MICROSEC_PAT = Pattern.compile("\\.(\\d{3})[ \\.,-_:;/\\\"]?(\\d{1,3})");
    private static final Pattern NANOSEC_PAT = Pattern.compile("\\.(\\d{3})[ \\.,-_:;/\\\"]?(\\d{3})[ \\.,-_:;/\\\"]?(\\d{1,3})");
    private static String fDefaultTimePattern = null;
    private static TmfTimestampFormat fDefaultTimeFormat = null;
    private static String fDefaultIntervalPattern = null;
    private static TmfTimestampFormat fDefaultIntervalFormat = null;
    private String fPattern;
    private List<String> fSupplPatterns = new ArrayList<String>();
    protected String fSupplPatternLetters = "TSCN";
    protected String fOpenBracket = "[&";
    protected String fCloseBracket = "&]";

    public TmfTimestampFormat() {
        this(fDefaultTimePattern);
    }

    public TmfTimestampFormat(String pattern) {
        this.applyPattern(pattern);
    }

    public TmfTimestampFormat(TmfTimestampFormat other) {
        this(other.fPattern);
    }

    public static void setDefaultTimeFormat(String pattern) {
        fDefaultTimePattern = pattern;
        fDefaultTimeFormat = new TmfTimestampFormat(fDefaultTimePattern);
        TmfSignalManager.dispatchSignal(new TmfTimestampFormatUpdateSignal(null));
    }

    public static TmfTimestampFormat getDefaulTimeFormat() {
        if (fDefaultTimeFormat == null) {
            fDefaultTimeFormat = new TmfTimestampFormat(DEFAULT_TIME_PATTERN);
        }
        return fDefaultTimeFormat;
    }

    public static void setDefaultIntervalFormat(String pattern) {
        fDefaultIntervalPattern = pattern;
        fDefaultIntervalFormat = new TmfTimestampFormat(fDefaultIntervalPattern);
        TmfSignalManager.dispatchSignal(new TmfTimestampFormatUpdateSignal(null));
    }

    public static TmfTimestampFormat getDefaulIntervalFormat() {
        if (fDefaultIntervalFormat == null) {
            fDefaultIntervalFormat = new TmfTimestampFormat(DEFAULT_INTERVAL_PATTERN);
        }
        return fDefaultIntervalFormat;
    }

    @Override
    public void applyPattern(String pattern) {
        this.fPattern = pattern;
        String quotedPattern = this.quoteSpecificTags(pattern);
        super.applyPattern(quotedPattern);
    }

    @Override
    public String toPattern() {
        return this.fPattern;
    }

    public synchronized String format(long value) {
        long sec = value / 1000000000L;
        long ms = value % 1000000000L / 1000000L;
        long cs = value % 1000000L / 1000L;
        long ns = value % 1000L;
        StringBuffer result = new StringBuffer(super.format(sec * 1000L + ms));
        int loc = result.indexOf(String.valueOf(this.fCloseBracket) + "'" + this.fOpenBracket);
        while (loc != -1) {
            result.deleteCharAt(loc + this.fCloseBracket.length());
            loc = result.indexOf(String.valueOf(this.fCloseBracket) + "'" + this.fOpenBracket);
        }
        for (String pattern : this.fSupplPatterns) {
            int length = pattern.length();
            StringBuffer fmt = new StringBuffer(length);
            int i = 0;
            while (i < length) {
                fmt.append("0");
                ++i;
            }
            DecimalFormat dfmt = new DecimalFormat(fmt.toString());
            String fmtVal = "";
            switch (pattern.charAt(0)) {
                case 'T': {
                    fmtVal = dfmt.format(sec);
                    break;
                }
                case 'S': {
                    fmtVal = dfmt.format(ms);
                    break;
                }
                case 'C': {
                    fmtVal = dfmt.format(cs);
                    break;
                }
                case 'N': {
                    fmtVal = dfmt.format(ns);
                    break;
                }
            }
            String ph = new StringBuffer(String.valueOf(this.fOpenBracket) + pattern + this.fCloseBracket).toString();
            loc = result.indexOf(ph);
            result.replace(loc, loc + length + this.fOpenBracket.length() + this.fCloseBracket.length(), fmtVal);
        }
        return result.toString();
    }

    public synchronized long parseValue(String string, long ref) throws ParseException {
        if (string == null || string.length() == 0) {
            return 0L;
        }
        long seconds = -1L;
        long millisec = 0L;
        long microsec = 0L;
        long nanosec = 0L;
        StringBuilder sb = new StringBuilder(string);
        int dot = string.indexOf(46);
        if (dot == -1) {
            sb.append('.');
            dot = string.length();
        }
        sb = new StringBuilder(string.substring(0, dot));
        String basePattern = super.toPattern();
        int dot2 = basePattern.indexOf(46);
        if (dot2 != -1) {
            sb.append(basePattern.substring(dot2));
        }
        for (String pattern : this.fSupplPatterns) {
            String pat = String.valueOf(this.fOpenBracket) + pattern + this.fCloseBracket;
            switch (pattern.charAt(0)) {
                case 'T': {
                    if (dot < 1) {
                        return new DecimalFormat("0").parse(string).longValue() * 1000000000L;
                    }
                    seconds = new DecimalFormat("0").parse(string.substring(0, dot)).longValue();
                    sb.delete(0, dot);
                    sb.insert(0, pat);
                    break;
                }
                case 'S': {
                    int l;
                    Matcher matcher = MILLISEC_PAT.matcher(string.substring(dot));
                    if (matcher.find()) {
                        millisec = new Long(matcher.group(1));
                        l = matcher.group(1).length();
                        while (l < 3) {
                            millisec *= 10L;
                            ++l;
                        }
                    }
                    this.stripQuotes(sb, pattern);
                    break;
                }
                case 'C': {
                    int l;
                    Matcher matcher = MICROSEC_PAT.matcher(string.substring(dot));
                    if (matcher.find()) {
                        microsec = new Long(matcher.group(2));
                        l = matcher.group(2).length();
                        while (l < 3) {
                            microsec *= 10L;
                            ++l;
                        }
                    }
                    this.stripQuotes(sb, pattern);
                    break;
                }
                case 'N': {
                    int l;
                    Matcher matcher = NANOSEC_PAT.matcher(string.substring(dot));
                    if (matcher.find()) {
                        nanosec = new Long(matcher.group(3));
                        l = matcher.group(3).length();
                        while (l < 3) {
                            nanosec *= 10L;
                            ++l;
                        }
                    }
                    this.stripQuotes(sb, pattern);
                    break;
                }
            }
        }
        if (seconds == -1L) {
            int[] fields;
            Date baseDate = super.parse(sb.toString());
            Calendar refTime = Calendar.getInstance(this.getTimeZone());
            refTime.setTimeInMillis(ref / 1000000L);
            Calendar newTime = Calendar.getInstance(this.getTimeZone());
            newTime.setTimeInMillis(baseDate.getTime());
            int[] nArray = fields = new int[]{1, 2, 5, 11, 12, 13};
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                int field = nArray[n2];
                int value = newTime.get(field);
                if (field == 1) {
                    value -= 1970;
                } else if (field == 5) {
                    --value;
                }
                if (value != 0) break;
                newTime.set(field, refTime.get(field));
                ++n2;
            }
            seconds = newTime.getTimeInMillis() / 1000L;
        }
        return seconds * 1000000000L + millisec * 1000000L + microsec * 1000L + nanosec;
    }

    public long parseValue(String string) throws ParseException {
        long result = this.parseValue(string, 0L);
        return result;
    }

    private String quoteSpecificTags(String pattern) {
        StringBuffer result = new StringBuffer();
        int length = pattern.length();
        boolean inQuote = false;
        int i = 0;
        while (i < length) {
            char c = pattern.charAt(i);
            result.append(c);
            if (c == '\'') {
                if (i + 1 < length && (c = pattern.charAt(i + 1)) == '\'') {
                    ++i;
                    result.append(c);
                } else {
                    inQuote = !inQuote;
                }
            } else if (!inQuote && this.fSupplPatternLetters.indexOf(c) != -1) {
                StringBuilder pat = new StringBuilder();
                pat.append(c);
                result.insert(result.length() - 1, "'" + this.fOpenBracket);
                while (i + 1 < length && pattern.charAt(i + 1) == c) {
                    result.append(c);
                    pat.append(c);
                    ++i;
                }
                result.append(String.valueOf(this.fCloseBracket) + "'");
                this.fSupplPatterns.add(pat.toString());
            }
            ++i;
        }
        return result.toString();
    }

    private void stripQuotes(StringBuilder sb, String pattern) {
        String pt = "'" + this.fOpenBracket + pattern + this.fCloseBracket + "'";
        int l = sb.indexOf(pt);
        if (l != -1) {
            sb.delete(l + pt.length() - 1, l + pt.length());
            sb.delete(l, l + 1);
        }
    }
}

