/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.Activator;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards.WizardUtil;
import org.eclipse.ptp.internal.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.wizards.SyncWizardDataCache;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeService;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;

public class NewRemoteSyncProjectWizardOperation
implements Runnable {
    private static final String DEFAULT_BUILD_CONFIG_ID = "default-build-config-id";
    private static final String ConfigMapKey = "config-map";

    public static void run(IProject project, ISynchronizeParticipant participant, AbstractSyncFileFilter customFileFilter, Set<String> localToolChains, Set<String> remoteToolChains, IProgressMonitor monitor) {
        SyncConfig[] allSyncConfigs;
        HashMap configMap;
        IConfiguration[] allBuildConfigs;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            throw new RuntimeException("Build information for project not found. Project name: " + project.getName());
        }
        IConfiguration defaultLocalBuildConfig = null;
        IConfiguration defaultRemoteBuildConfig = null;
        IConfiguration[] iConfigurationArray = allBuildConfigs = buildInfo.getManagedProject().getConfigurations();
        int n = allBuildConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            WizardUtil.modifyBuildConfigForSync(config);
            String toolChainName = config.getToolChain().getSuperClass().getName();
            if (remoteToolChains.contains(toolChainName)) {
                WizardUtil.modifyRemoteBuildConfigForSync(config);
                defaultRemoteBuildConfig = config;
            } else if (localToolChains.contains(toolChainName)) {
                WizardUtil.modifyLocalBuildConfigForSync(config);
                defaultLocalBuildConfig = config;
            } else {
                assert (false) : Messages.NewRemoteSyncProjectWizardOperation_3;
                WizardUtil.modifyRemoteBuildConfigForSync(config);
                defaultRemoteBuildConfig = config;
            }
            config.setName(config.getName().replace(' ', '_'));
            ++n2;
        }
        assert (defaultRemoteBuildConfig != null) : Messages.NewRemoteSyncProjectWizardOperation_0;
        if (defaultLocalBuildConfig == null) {
            defaultLocalBuildConfig = defaultRemoteBuildConfig;
        }
        if (!NewRemoteSyncProjectWizardOperation.isSyncProject(project)) {
            try {
                SyncManager.makeSyncProject((IProject)project, (String)participant.getSyncConfigName(), (ISynchronizeService)participant.getProvider(project), (AbstractSyncFileFilter)customFileFilter);
            }
            catch (CoreException e) {
                Activator.log(e);
                return;
            }
        }
        if ((configMap = SyncWizardDataCache.getMap((String)ConfigMapKey)) == null) {
            configMap = new HashMap();
        }
        SyncConfig[] syncConfigArray = allSyncConfigs = SyncConfigManager.getConfigs((IProject)project);
        int n3 = allSyncConfigs.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfiguration defaultBuildConfig;
            SyncConfig config = syncConfigArray[n4];
            if (configMap.containsKey(config.getName())) {
                String buildConfigName = (String)configMap.get(config.getName());
                buildConfigName = buildConfigName.replace(' ', '_');
                defaultBuildConfig = NewRemoteSyncProjectWizardOperation.findBuildConfigByName(buildConfigName, allBuildConfigs);
                assert (defaultBuildConfig != null) : String.valueOf(Messages.NewRemoteSyncProjectWizardOperation_2) + buildConfigName;
            } else {
                defaultBuildConfig = SyncConfigManager.isLocal((SyncConfig)config) ? defaultLocalBuildConfig : defaultRemoteBuildConfig;
            }
            config.setProperty(DEFAULT_BUILD_CONFIG_ID, defaultBuildConfig.getId());
            if (SyncConfigManager.isActive((IProject)project, (SyncConfig)config)) {
                ManagedBuildManager.setDefaultConfiguration((IProject)project, (IConfiguration)defaultBuildConfig);
            }
            ++n4;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        try {
            SyncConfigManager.saveConfigs((IProject)project);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        if (customFileFilter != null) {
            try {
                SyncManager.saveFileFilter((IProject)project, (AbstractSyncFileFilter)customFileFilter);
            }
            catch (IOException e) {
                RDTSyncCorePlugin.log((Throwable)e);
            }
        }
        SyncManager.setSyncMode((IProject)project, (SyncManager.SyncMode)SyncManager.SyncMode.ACTIVE);
    }

    private static boolean isSyncProject(IProject project) {
        return RemoteSyncNature.hasNature((IProject)project);
    }

    @Override
    public void run() {
    }

    private static IConfiguration findBuildConfigByName(String name, IConfiguration[] configArray) {
        IConfiguration[] iConfigurationArray = configArray;
        int n = configArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (config.getName().equals(name)) {
                return config;
            }
            ++n2;
        }
        return null;
    }
}

