/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MinMaxDialog
extends Dialog {
    private Text fMinText;
    private Text fMaxText;
    private Text fScaleText;
    private Text fPrecisionText;
    private SDWidget fSdWidget;

    public MinMaxDialog(Shell shell, SDWidget viewer) {
        super(shell);
        this.fSdWidget = viewer;
    }

    protected GridData newGridData(int span) {
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        return data;
    }

    protected Control createDialogArea(Composite p) {
        p.getShell().setText(Messages.SequenceDiagram_TimeCompressionBarConfig);
        Composite parent = (Composite)super.createDialogArea(p);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 6;
        parent.setLayout((Layout)parentLayout);
        Group g1 = new Group(parent, 32);
        g1.setLayoutData((Object)this.newGridData(3));
        GridLayout g1layout = new GridLayout();
        g1layout.numColumns = 3;
        g1.setLayout((Layout)g1layout);
        Label minLabel = new Label((Composite)g1, 16);
        minLabel.setText(Messages.SequenceDiagram_MinTime);
        minLabel.setLayoutData((Object)this.newGridData(1));
        this.fMinText = new Text((Composite)g1, 2052);
        this.fMinText.setLayoutData((Object)this.newGridData(2));
        this.fMinText.setText(String.valueOf(this.fSdWidget.getFrame().getMinTime().getValue()));
        Label maxLabel = new Label((Composite)g1, 16);
        maxLabel.setText(Messages.SequenceDiagram_MaxTime);
        maxLabel.setLayoutData((Object)this.newGridData(1));
        this.fMaxText = new Text((Composite)g1, 2052);
        this.fMaxText.setLayoutData((Object)this.newGridData(2));
        this.fMaxText.setText(String.valueOf(this.fSdWidget.getFrame().getMaxTime().getValue()));
        Label scaleLabel = new Label((Composite)g1, 16);
        scaleLabel.setText(Messages.SequenceDiagram_Scale);
        scaleLabel.setLayoutData((Object)this.newGridData(1));
        this.fScaleText = new Text((Composite)g1, 2052);
        this.fScaleText.setLayoutData((Object)this.newGridData(2));
        this.fScaleText.setText(String.valueOf(this.fSdWidget.getFrame().getMinTime().getScale()));
        Label precisionLabel = new Label((Composite)g1, 16);
        precisionLabel.setText(Messages.SequenceDiagram_Precision);
        precisionLabel.setLayoutData((Object)this.newGridData(1));
        this.fPrecisionText = new Text((Composite)g1, 2052);
        this.fPrecisionText.setLayoutData((Object)this.newGridData(2));
        this.fPrecisionText.setText(String.valueOf(this.fSdWidget.getFrame().getMinTime().getPrecision()));
        return parent;
    }

    protected void okPressed() {
        long min = 0L;
        long max = 0L;
        int scale = 0;
        int precision = 0;
        try {
            min = Long.parseLong(this.fMinText.getText());
            max = Long.parseLong(this.fMaxText.getText());
            scale = Integer.parseInt(this.fScaleText.getText());
            precision = Integer.parseInt(this.fPrecisionText.getText());
            this.fSdWidget.getFrame().setMax((ITmfTimestamp)new TmfTimestamp(max, scale, precision));
            this.fSdWidget.getFrame().setMin((ITmfTimestamp)new TmfTimestamp(min, scale, precision));
            this.fSdWidget.redraw();
            super.okPressed();
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SequenceDiagram_Error, (String)Messages.SequenceDiagram_InvalidRange);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 1024, Messages.SequenceDiagram_Default, false);
        this.getButton(1024).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MinMaxDialog.this.fSdWidget.getFrame().resetCustomMinMax();
                MinMaxDialog.this.fMinText.setText(String.valueOf(MinMaxDialog.this.fSdWidget.getFrame().getMinTime().getValue()));
                MinMaxDialog.this.fMaxText.setText(String.valueOf(MinMaxDialog.this.fSdWidget.getFrame().getMaxTime().getValue()));
                MinMaxDialog.this.fScaleText.setText(String.valueOf(MinMaxDialog.this.fSdWidget.getFrame().getMinTime().getScale()));
                MinMaxDialog.this.fPrecisionText.setText(String.valueOf(MinMaxDialog.this.fSdWidget.getFrame().getMinTime().getPrecision()));
                MinMaxDialog.this.fMaxText.getParent().layout(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
}

