/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import com.ibm.icu.text.Collator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IncludeInfo
implements Comparable<IncludeInfo> {
    private static final Collator COLLATOR = Collator.getInstance();
    private final String name;
    private final boolean isSystem;

    public IncludeInfo(String name, boolean isSystem) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.isSystem = isSystem;
    }

    public IncludeInfo(String includeText) {
        if (includeText == null || includeText.isEmpty()) {
            throw new IllegalArgumentException();
        }
        boolean isSystem = false;
        int begin = 0;
        switch (includeText.charAt(0)) {
            case '<': {
                isSystem = true;
            }
            case '\"': {
                ++begin;
            }
        }
        int end = includeText.length();
        switch (includeText.charAt(end - 1)) {
            case '\"': 
            case '>': {
                --end;
            }
        }
        if (begin >= end) {
            throw new IllegalArgumentException();
        }
        this.name = includeText.substring(begin, end);
        this.isSystem = isSystem;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isSystem() {
        return this.isSystem;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + (this.isSystem ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeInfo other = (IncludeInfo)obj;
        return this.name.equals(other.name) && this.isSystem == other.isSystem;
    }

    public String toString() {
        return String.valueOf(this.isSystem ? (char)'<' : '\"') + this.name + (this.isSystem ? (char)'>' : '\"');
    }

    @Override
    public int compareTo(IncludeInfo other) {
        if (this.isSystem != other.isSystem) {
            return this.isSystem ? -1 : 1;
        }
        IPath path1 = Path.fromOSString((String)this.name);
        IPath path2 = Path.fromOSString((String)other.name);
        int length1 = path1.segmentCount();
        int length2 = path2.segmentCount();
        int i = 0;
        while (i < length1 && i < length2) {
            int c = COLLATOR.compare(path1.segment(i), path2.segment(i));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return length1 - length2;
    }
}

