/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpoints;

import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.internal.ui.breakpoints.CBreakpointContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchMessages;

public class CBreakpointPropertyDialogAction
extends SelectionProviderAction {
    private IShellProvider fShellProvider;
    private IDebugContextProvider fDebugContextProvider;
    private static final String PAGE_ID_COMMON = "org.eclipse.cdt.debug.ui.propertypages.breakpoint.common";

    public CBreakpointPropertyDialogAction(IShellProvider shell, ISelectionProvider selectionProvider, IDebugContextProvider debugContextProvider) {
        super(selectionProvider, WorkbenchMessages.PropertyDialog_text);
        Assert.isNotNull((Object)shell);
        this.fDebugContextProvider = debugContextProvider;
        this.fShellProvider = shell;
        this.setToolTipText(WorkbenchMessages.PropertyDialog_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.property_dialog_action_context");
    }

    protected ISelection getDebugContext() {
        return this.fDebugContextProvider.getActiveContext();
    }

    public boolean isCBreakpointSelection() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.isApplicableForSelection(this.getStructuredSelection(), this.getDebugContext());
    }

    public boolean isApplicableForSelection(IStructuredSelection selection, ISelection debugContext) {
        return this.isCBreakpointSelection(selection);
    }

    private boolean isCBreakpointSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            if (itr.next() instanceof ICBreakpoint) continue;
            return false;
        }
        return true;
    }

    public void run() {
        PreferenceDialog dialog;
        CBreakpointContext bpContext = this.getCBreakpointContext();
        if (bpContext != null && (dialog = this.createDialog(bpContext)) != null) {
            TreeViewer viewer = dialog.getTreeViewer();
            if (viewer != null) {
                viewer.setComparator(new ViewerComparator(){

                    public int category(Object element) {
                        if (element instanceof IPreferenceNode) {
                            IPreferenceNode node = (IPreferenceNode)element;
                            if (CBreakpointPropertyDialogAction.PAGE_ID_COMMON.equals(node.getId())) {
                                return 0;
                            }
                            if (node.getSubNodes() == null || node.getSubNodes().length == 0) {
                                return super.category(element) + 1;
                            }
                        }
                        return super.category(element) + 2;
                    }
                });
                viewer.expandToLevel(-1);
            }
            dialog.open();
        }
    }

    private CBreakpointContext getCBreakpointContext() {
        IStructuredSelection ss = this.getStructuredSelection();
        if (ss.size() >= 1 && ss.getFirstElement() instanceof ICBreakpoint) {
            return new CBreakpointContext((ICBreakpoint)ss.getFirstElement(), this.fDebugContextProvider.getActiveContext());
        }
        return null;
    }

    protected PreferenceDialog createDialog(CBreakpointContext bpContext) {
        IStructuredSelection ss = this.getStructuredSelection();
        if (ss.isEmpty()) {
            return null;
        }
        return PreferencesUtil.createPropertyDialogOn((Shell)this.fShellProvider.getShell(), (IAdaptable)bpContext, null, null, null);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!selection.isEmpty());
    }
}

