/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDeclaration;

public class VariantDefinition
extends Definition
implements IDefinitionScope {
    private VariantDeclaration declaration;
    private EnumDefinition tagDefinition;
    private Map<String, Definition> definitions = new HashMap<String, Definition>();
    private String currentField;

    public VariantDefinition(VariantDeclaration declaration, IDefinitionScope definitionScope, String fieldName) {
        super(definitionScope, fieldName);
        this.declaration = declaration;
        Definition tagDef = definitionScope.lookupDefinition(declaration.getTag());
        this.tagDefinition = (EnumDefinition)tagDef;
        for (Map.Entry<String, IDeclaration> field : declaration.getFields().entrySet()) {
            Definition fieldDef = field.getValue().createDefinition(this, field.getKey());
            this.definitions.put(field.getKey(), fieldDef);
        }
    }

    @Override
    public VariantDeclaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(VariantDeclaration declaration) {
        this.declaration = declaration;
    }

    public EnumDefinition getTagDefinition() {
        return this.tagDefinition;
    }

    public void setTagDefinition(EnumDefinition tagDefinition) {
        this.tagDefinition = tagDefinition;
    }

    public Map<String, Definition> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Map<String, Definition> definitions) {
        this.definitions = definitions;
    }

    public void setCurrentField(String currentField) {
        this.currentField = currentField;
    }

    public String getCurrentFieldName() {
        return this.currentField;
    }

    public Definition getCurrentField() {
        return this.definitions.get(this.currentField);
    }

    @Override
    public void read(BitBuffer input) {
        this.currentField = this.tagDefinition.getValue();
        Definition field = this.definitions.get(this.currentField);
        field.read(input);
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        return this.definitions.get(lookupPath);
    }

    public ArrayDefinition lookupArray(String name) {
        Definition def = this.lookupDefinition(name);
        return (ArrayDefinition)(def instanceof ArrayDefinition ? def : null);
    }

    public EnumDefinition lookupEnum(String name) {
        Definition def = this.lookupDefinition(name);
        return (EnumDefinition)(def instanceof EnumDefinition ? def : null);
    }

    public IntegerDefinition lookupInteger(String name) {
        Definition def = this.lookupDefinition(name);
        return (IntegerDefinition)(def instanceof IntegerDefinition ? def : null);
    }

    public SequenceDefinition lookupSequence(String name) {
        Definition def = this.lookupDefinition(name);
        return (SequenceDefinition)(def instanceof SequenceDefinition ? def : null);
    }

    public StringDefinition lookupString(String name) {
        Definition def = this.lookupDefinition(name);
        return (StringDefinition)(def instanceof StringDefinition ? def : null);
    }

    public StructDefinition lookupStruct(String name) {
        Definition def = this.lookupDefinition(name);
        return (StructDefinition)(def instanceof StructDefinition ? def : null);
    }

    public VariantDefinition lookupVariant(String name) {
        Definition def = this.lookupDefinition(name);
        return (VariantDefinition)(def instanceof VariantDefinition ? def : null);
    }

    @Override
    public String toString() {
        return "{ " + this.getCurrentFieldName() + " = " + this.getCurrentField() + " }";
    }
}

