/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BTree {
    private static final int DELMODE_NORMAL = 0;
    private static final int DELMODE_DELETE_MINIMUM = 1;
    private static final int DELMODE_DELETE_MAXIMUM = 2;
    protected final Database db;
    protected final long rootPointer;
    protected final int DEGREE;
    protected final int MAX_RECORDS;
    protected final int MAX_CHILDREN;
    protected final int MIN_RECORDS;
    protected final int OFFSET_CHILDREN;
    protected final int MEDIAN_RECORD;
    protected final IBTreeComparator cmp;

    public BTree(Database db, long rootPointer, IBTreeComparator cmp) {
        this(db, rootPointer, 8, cmp);
    }

    public BTree(Database db, long rootPointer, int degree, IBTreeComparator cmp) {
        if (degree < 2) {
            throw new IllegalArgumentException(Messages.getString("BTree.IllegalDegree"));
        }
        this.db = db;
        this.rootPointer = rootPointer;
        this.cmp = cmp;
        this.DEGREE = degree;
        this.MIN_RECORDS = this.DEGREE - 1;
        this.MAX_RECORDS = 2 * this.DEGREE - 1;
        this.MAX_CHILDREN = 2 * this.DEGREE;
        this.OFFSET_CHILDREN = this.MAX_RECORDS * 4;
        this.MEDIAN_RECORD = this.DEGREE - 1;
    }

    protected long getRoot() throws CoreException {
        return this.db.getRecPtr(this.rootPointer);
    }

    protected final void putRecord(Chunk chunk, long node, int index, long record) {
        chunk.putRecPtr(node + (long)(index * 4), record);
    }

    protected final long getRecord(Chunk chunk, long node, int index) {
        return chunk.getRecPtr(node + (long)(index * 4));
    }

    protected final void putChild(Chunk chunk, long node, int index, long child) {
        chunk.putRecPtr(node + (long)this.OFFSET_CHILDREN + (long)(index * 4), child);
    }

    protected final long getChild(Chunk chunk, long node, int index) {
        return chunk.getRecPtr(node + (long)this.OFFSET_CHILDREN + (long)(index * 4));
    }

    public long insert(long record) throws CoreException {
        long root = this.getRoot();
        if (root == 0L) {
            this.firstInsert(record);
            return record;
        }
        return this.insert(null, 0L, 0, root, record);
    }

    private long insert(Chunk pChunk, long parent, int iParent, long node, long record) throws CoreException {
        long r;
        Chunk chunk = this.db.getChunk(node);
        if (this.getRecord(chunk, node, this.MAX_RECORDS - 1) != 0L) {
            long median = this.getRecord(chunk, node, this.MEDIAN_RECORD);
            if (median == record) {
                return median;
            }
            long newnode = this.allocateNode();
            Chunk newchunk = this.db.getChunk(newnode);
            int i = 0;
            while (i < this.MEDIAN_RECORD) {
                this.putRecord(newchunk, newnode, i, this.getRecord(chunk, node, this.MEDIAN_RECORD + 1 + i));
                this.putRecord(chunk, node, this.MEDIAN_RECORD + 1 + i, 0L);
                this.putChild(newchunk, newnode, i, this.getChild(chunk, node, this.MEDIAN_RECORD + 1 + i));
                this.putChild(chunk, node, this.MEDIAN_RECORD + 1 + i, 0L);
                ++i;
            }
            this.putChild(newchunk, newnode, this.MEDIAN_RECORD, this.getChild(chunk, node, this.MAX_RECORDS));
            this.putChild(chunk, node, this.MAX_RECORDS, 0L);
            if (parent == 0L) {
                parent = this.allocateNode();
                pChunk = this.db.getChunk(parent);
                this.db.putRecPtr(this.rootPointer, parent);
                this.putChild(pChunk, parent, 0, node);
            } else {
                i = this.MAX_RECORDS - 2;
                while (i >= iParent) {
                    r = this.getRecord(pChunk, parent, i);
                    if (r != 0L) {
                        this.putRecord(pChunk, parent, i + 1, r);
                        this.putChild(pChunk, parent, i + 2, this.getChild(pChunk, parent, i + 1));
                    }
                    --i;
                }
            }
            this.putRecord(pChunk, parent, iParent, median);
            this.putChild(pChunk, parent, iParent + 1, newnode);
            this.putRecord(chunk, node, this.MEDIAN_RECORD, 0L);
            if (this.cmp.compare(record, median) > 0) {
                node = newnode;
                chunk = newchunk;
            }
        }
        int lower = 0;
        int upper = this.MAX_RECORDS - 1;
        while (lower < upper && this.getRecord(chunk, node, upper - 1) == 0L) {
            --upper;
        }
        while (lower < upper) {
            int middle = (lower + upper) / 2;
            long checkRec = this.getRecord(chunk, node, middle);
            if (checkRec == 0L) {
                upper = middle;
                continue;
            }
            int compare = this.cmp.compare(checkRec, record);
            if (compare > 0) {
                upper = middle;
                continue;
            }
            if (compare < 0) {
                lower = middle + 1;
                continue;
            }
            return checkRec;
        }
        int i = lower;
        long child = this.getChild(chunk, node, i);
        if (child != 0L) {
            return this.insert(chunk, node, i, child, record);
        }
        int j = this.MAX_RECORDS - 2;
        while (j >= i) {
            r = this.getRecord(chunk, node, j);
            if (r != 0L) {
                this.putRecord(chunk, node, j + 1, r);
            }
            --j;
        }
        this.putRecord(chunk, node, i, record);
        return record;
    }

    private void firstInsert(long record) throws CoreException {
        long root = this.allocateNode();
        this.db.putRecPtr(this.rootPointer, root);
        this.putRecord(this.db.getChunk(root), root, 0, record);
    }

    private long allocateNode() throws CoreException {
        return this.db.malloc((2 * this.MAX_RECORDS + 1) * 4);
    }

    public void delete(long record) throws CoreException {
        try {
            this.deleteImp(record, this.getRoot(), 0);
        }
        catch (BTreeKeyNotFoundException bTreeKeyNotFoundException) {}
    }

    private long deleteImp(long key, long nodeRecord, int mode) throws CoreException, BTreeKeyNotFoundException {
        int subtreeIndex;
        BTNode node = new BTNode(nodeRecord);
        int keyIndexInNode = -1;
        if (mode == 0) {
            int i = 0;
            while (i < node.keyCount) {
                if (this.getRecord(node.chunk, node.node, i) == key) {
                    keyIndexInNode = i;
                    break;
                }
                ++i;
            }
        }
        if (this.getChild(node.chunk, node.node, 0) == 0L) {
            if (keyIndexInNode != -1) {
                this.nodeContentDelete(node, keyIndexInNode, 1);
                return key;
            }
            if (mode == 1) {
                long subst = this.getRecord(node.chunk, node.node, 0);
                this.nodeContentDelete(node, 0, 1);
                return subst;
            }
            if (mode == 2) {
                long subst = this.getRecord(node.chunk, node.node, node.keyCount - 1);
                this.nodeContentDelete(node, node.keyCount - 1, 1);
                return subst;
            }
            throw new BTreeKeyNotFoundException(MessageFormat.format((String)Messages.getString("BTree.DeletionOnAbsentKey"), (Object[])new Object[]{new Long(key), new Integer(mode)}));
        }
        if (keyIndexInNode != -1) {
            BTNode succ = node.getChild(keyIndexInNode + 1);
            if (succ != null && succ.keyCount > this.MIN_RECORDS) {
                long subst = this.deleteImp(-1L, succ.node, 1);
                this.putRecord(node.chunk, node.node, keyIndexInNode, subst);
                return key;
            }
            BTNode pred = node.getChild(keyIndexInNode);
            if (pred != null && pred.keyCount > this.MIN_RECORDS) {
                long subst = this.deleteImp(-1L, pred.node, 2);
                this.putRecord(node.chunk, node.node, keyIndexInNode, subst);
                return key;
            }
            if (pred != null) {
                this.mergeNodes(succ, node, keyIndexInNode, pred);
                return this.deleteImp(key, pred.node, mode);
            }
            return key;
        }
        block0 : switch (mode) {
            case 0: {
                subtreeIndex = node.keyCount;
                int i = 0;
                while (i < node.keyCount) {
                    if (this.cmp.compare(this.getRecord(node.chunk, node.node, i), key) > 0) {
                        subtreeIndex = i;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                subtreeIndex = 0;
                break;
            }
            case 2: {
                subtreeIndex = node.keyCount;
                break;
            }
            default: {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, Messages.getString("BTree.UnknownMode"), null));
            }
        }
        BTNode child = node.getChild(subtreeIndex);
        if (child == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, Messages.getString("BTree.IntegrityError"), null));
        }
        if (child.keyCount > this.MIN_RECORDS) {
            return this.deleteImp(key, child.node, mode);
        }
        BTNode sibR = node.getChild(subtreeIndex + 1);
        if (sibR != null && sibR.keyCount > this.MIN_RECORDS) {
            long rightKey = this.getRecord(node.chunk, node.node, subtreeIndex);
            long leftmostRightSiblingKey = this.getRecord(sibR.chunk, sibR.node, 0);
            this.append(child, rightKey, this.getChild(sibR.chunk, sibR.node, 0));
            this.nodeContentDelete(sibR, 0, 1);
            this.putRecord(node.chunk, node.node, subtreeIndex, leftmostRightSiblingKey);
            return this.deleteImp(key, child.node, mode);
        }
        BTNode sibL = node.getChild(subtreeIndex - 1);
        if (sibL != null && sibL.keyCount > this.MIN_RECORDS) {
            long leftKey = this.getRecord(node.chunk, node.node, subtreeIndex - 1);
            this.prepend(child, leftKey, this.getChild(sibL.chunk, sibL.node, sibL.keyCount));
            long rightmostLeftSiblingKey = this.getRecord(sibL.chunk, sibL.node, sibL.keyCount - 1);
            this.putRecord(sibL.chunk, sibL.node, sibL.keyCount - 1, 0L);
            this.putChild(sibL.chunk, sibL.node, sibL.keyCount, 0L);
            this.putRecord(node.chunk, node.node, subtreeIndex - 1, rightmostLeftSiblingKey);
            return this.deleteImp(key, child.node, mode);
        }
        if (sibL != null) {
            this.mergeNodes(child, node, subtreeIndex - 1, sibL);
            return this.deleteImp(key, sibL.node, mode);
        }
        if (sibR != null) {
            this.mergeNodes(sibR, node, subtreeIndex, child);
            return this.deleteImp(key, child.node, mode);
        }
        throw new BTreeKeyNotFoundException(MessageFormat.format((String)Messages.getString("BTree.DeletionOnAbsentKey"), (Object[])new Object[]{new Long(key), new Integer(mode)}));
    }

    public void mergeNodes(BTNode src, BTNode keyProvider, int kIndex, BTNode dst) throws CoreException {
        long rootNode;
        this.nodeContentCopy(src, 0, dst, dst.keyCount + 1, src.keyCount + 1);
        long midKey = this.getRecord(keyProvider.chunk, keyProvider.node, kIndex);
        this.putRecord(dst.chunk, dst.node, dst.keyCount, midKey);
        long keySucc = kIndex + 1 == this.MAX_RECORDS ? 0L : this.getRecord(keyProvider.chunk, keyProvider.node, kIndex + 1);
        this.db.free(this.getChild(keyProvider.chunk, keyProvider.node, kIndex + 1));
        this.nodeContentDelete(keyProvider, kIndex + 1, 1);
        this.putRecord(keyProvider.chunk, keyProvider.node, kIndex, keySucc);
        if (kIndex == 0 && keySucc == 0L && (rootNode = this.getRoot()) == keyProvider.node) {
            this.db.putRecPtr(this.rootPointer, dst.node);
            this.db.free(rootNode);
        }
    }

    private void prepend(BTNode node, long key, long child) {
        this.nodeContentCopy(node, 0, node, 1, node.keyCount + 1);
        this.putRecord(node.chunk, node.node, 0, key);
        this.putChild(node.chunk, node.node, 0, child);
    }

    private void append(BTNode node, long key, long child) {
        this.putRecord(node.chunk, node.node, node.keyCount, key);
        this.putChild(node.chunk, node.node, node.keyCount + 1, child);
    }

    private void nodeContentCopy(BTNode src, int srcPos, BTNode dst, int dstPos, int length) {
        int i = length - 1;
        while (i >= 0) {
            int srcIndex = srcPos + i;
            int dstIndex = dstPos + i;
            if (srcIndex < src.keyCount + 1) {
                long srcChild = this.getChild(src.chunk, src.node, srcIndex);
                this.putChild(dst.chunk, dst.node, dstIndex, srcChild);
                if (srcIndex < src.keyCount) {
                    long srcKey = this.getRecord(src.chunk, src.node, srcIndex);
                    this.putRecord(dst.chunk, dst.node, dstIndex, srcKey);
                }
            }
            --i;
        }
    }

    private void nodeContentDelete(BTNode node, int i, int length) {
        int index = i;
        while (index <= this.MAX_RECORDS) {
            long newChild;
            long newKey = index + length < node.keyCount ? this.getRecord(node.chunk, node.node, index + length) : 0L;
            long l = newChild = index + length < node.keyCount + 1 ? this.getChild(node.chunk, node.node, index + length) : 0L;
            if (index < this.MAX_RECORDS) {
                this.putRecord(node.chunk, node.node, index, newKey);
            }
            if (index < this.MAX_CHILDREN) {
                this.putChild(node.chunk, node.node, index, newChild);
            }
            ++index;
        }
    }

    public void accept(IBTreeVisitor visitor) throws CoreException {
        this.accept(this.db.getRecPtr(this.rootPointer), visitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean accept(long node, IBTreeVisitor visitor) throws CoreException {
        if (node == 0L) {
            return true;
        }
        if (visitor instanceof IBTreeVisitor2) {
            ((IBTreeVisitor2)visitor).preNode(node);
        }
        try {
            int compare;
            Chunk chunk = this.db.getChunk(node);
            int lower = 0;
            int upper = this.MAX_RECORDS - 1;
            while (lower < upper && this.getRecord(chunk, node, upper - 1) == 0L) {
                --upper;
            }
            while (lower < upper) {
                int middle = (lower + upper) / 2;
                long checkRec = this.getRecord(chunk, node, middle);
                if (checkRec == 0L) {
                    upper = middle;
                    continue;
                }
                compare = visitor.compare(checkRec);
                if (compare >= 0) {
                    upper = middle;
                    continue;
                }
                lower = middle + 1;
            }
            int i = lower;
            while (i < this.MAX_RECORDS) {
                long record = this.getRecord(chunk, node, i);
                if (record == 0L) break;
                compare = visitor.compare(record);
                if (compare > 0) {
                    boolean bl = this.accept(this.getChild(chunk, node, i), visitor);
                    return bl;
                }
                if (compare == 0) {
                    if (!this.accept(this.getChild(chunk, node, i), visitor)) {
                        return false;
                    }
                    if (!visitor.visit(record)) {
                        return false;
                    }
                }
                ++i;
            }
            boolean bl = this.accept(this.getChild(chunk, node, i), visitor);
            return bl;
        }
        finally {
            if (visitor instanceof IBTreeVisitor2) {
                ((IBTreeVisitor2)visitor).postNode(node);
            }
        }
    }

    public String getInvariantsErrorReport() throws CoreException {
        InvariantsChecker checker = new InvariantsChecker();
        this.accept(checker);
        return checker.isValid() ? "" : checker.getMsg();
    }

    private class BTNode {
        final long node;
        final int keyCount;
        final Chunk chunk;

        BTNode(long node) throws CoreException {
            this.node = node;
            this.chunk = BTree.this.db.getChunk(node);
            int i = 0;
            while (i < BTree.this.MAX_RECORDS && BTree.this.getRecord(this.chunk, node, i) != 0L) {
                ++i;
            }
            this.keyCount = i;
        }

        private BTNode getChild(int index) throws CoreException {
            long child;
            if (index >= 0 && index < BTree.this.MAX_CHILDREN && (child = BTree.this.getChild(this.chunk, this.node, index)) != 0L) {
                return new BTNode(child);
            }
            return null;
        }
    }

    private class BTreeKeyNotFoundException
    extends Exception {
        private static final long serialVersionUID = 9065438266175091670L;

        public BTreeKeyNotFoundException(String msg) {
            super(msg);
        }
    }

    private static interface IBTreeVisitor2
    extends IBTreeVisitor {
        public void preNode(long var1) throws CoreException;

        public void postNode(long var1) throws CoreException;
    }

    private class InvariantsChecker
    implements IBTreeVisitor2 {
        boolean valid = true;
        String msg = "";
        Integer leafDepth;
        int depth;

        private InvariantsChecker() {
        }

        public String getMsg() {
            return this.msg;
        }

        public boolean isValid() {
            return this.valid;
        }

        @Override
        public void postNode(long node) throws CoreException {
            --this.depth;
        }

        @Override
        public int compare(long record) throws CoreException {
            return 0;
        }

        @Override
        public boolean visit(long record) throws CoreException {
            return true;
        }

        @Override
        public void preNode(long node) throws CoreException {
            ++this.depth;
            int keyCount = 0;
            int indexFirstBlankKey = BTree.this.MAX_RECORDS;
            int indexLastNonBlankKey = 0;
            int i = 0;
            while (i < BTree.this.MAX_RECORDS) {
                if (BTree.this.getRecord(BTree.this.db.getChunk(node), node, i) != 0L) {
                    ++keyCount;
                    indexLastNonBlankKey = i;
                } else if (indexFirstBlankKey == BTree.this.MAX_RECORDS) {
                    indexFirstBlankKey = i;
                }
                ++i;
            }
            int childCount = 0;
            int i2 = 0;
            while (i2 < BTree.this.MAX_CHILDREN) {
                if (BTree.this.getChild(BTree.this.db.getChunk(node), node, i2) != 0L) {
                    ++childCount;
                }
                ++i2;
            }
            if (indexFirstBlankKey != indexLastNonBlankKey + 1) {
                boolean empty;
                boolean full = indexFirstBlankKey == BTree.this.MAX_RECORDS && indexLastNonBlankKey == BTree.this.MAX_RECORDS - 1;
                boolean bl = empty = indexFirstBlankKey == 0 && indexLastNonBlankKey == 0;
                if (!full && !empty) {
                    this.valid = false;
                    this.msg = String.valueOf(this.msg) + MessageFormat.format((String)Messages.getString("BTree.IntegrityErrorA"), (Object[])new Object[]{new Long(node), new Integer(indexFirstBlankKey), new Integer(indexLastNonBlankKey)});
                }
            }
            if (childCount != 0 && childCount != keyCount + 1) {
                this.valid = false;
                this.msg = String.valueOf(this.msg) + MessageFormat.format((String)Messages.getString("BTree.IntegrityErrorB"), (Object[])new Object[]{new Long(node)});
            }
            if (node == BTree.this.db.getRecPtr(BTree.this.rootPointer)) {
                return;
            }
            if (keyCount < BTree.this.MIN_RECORDS || keyCount > BTree.this.MAX_RECORDS) {
                this.valid = false;
                this.msg = String.valueOf(this.msg) + MessageFormat.format((String)Messages.getString("BTree.IntegrityErrorC"), (Object[])new Object[]{new Long(node)});
            }
            if (childCount == 0) {
                if (this.leafDepth == null) {
                    this.leafDepth = new Integer(this.depth);
                }
                if (this.depth != this.leafDepth) {
                    this.valid = false;
                    this.msg = String.valueOf(this.msg) + Messages.getString("BTree.IntegrityErrorD");
                }
            }
        }
    }
}

