/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.breakpoint;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.internal.debug.core.breakpoint.PBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLineBreakpoint
extends PBreakpoint
implements IPLineBreakpoint {
    public AbstractLineBreakpoint() {
    }

    public AbstractLineBreakpoint(IResource resource, String markerType, Map<String, ? extends Object> attributes, String jobId, String setId, boolean add) throws CoreException {
        super(resource, markerType, attributes, jobId, setId, add);
    }

    @Override
    public String getAddress() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.address", "");
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    @Override
    public String getFileName() throws CoreException {
        String fileName = this.getSourceHandle();
        Path path = new Path(fileName);
        return path.isValidPath(fileName) ? path.lastSegment() : null;
    }

    @Override
    public String getFunction() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.function", "");
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    @Override
    public void setAddress(String address) throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.address", address);
    }

    @Override
    public void setFunction(String function) throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.function", function);
    }
}

