/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.event;

import java.util.EventObject;
import org.eclipse.ptp.debug.core.event.IPDebugEvent;
import org.eclipse.ptp.debug.core.event.IPDebugInfo;
import org.eclipse.ptp.internal.debug.core.messages.Messages;

public final class PDebugEvent
extends EventObject
implements IPDebugEvent {
    private static final long serialVersionUID = 1L;
    private int fKind = 0;
    private int fDetail = 0;
    private IPDebugInfo fInfo = null;

    public PDebugEvent(Object eventSource, int kind, int detail, IPDebugInfo info) {
        super(eventSource);
        if ((kind & 0x7F) == 0) {
            throw new IllegalArgumentException(Messages.PDebugEvent_0);
        }
        if (kind != 32 && detail != 0 && (detail & 0xFFF) == 0) {
            throw new IllegalArgumentException(Messages.PDebugEvent_1);
        }
        this.fKind = kind;
        this.fDetail = detail;
        this.fInfo = info;
    }

    public int getKind() {
        return this.fKind;
    }

    public int getDetail() {
        return this.fDetail;
    }

    public IPDebugInfo getInfo() {
        return this.fInfo;
    }

    public boolean isStepStart() {
        return (this.getDetail() & 7) > 0;
    }

    public boolean isEvaluation() {
        return (this.getDetail() & 0xC0) > 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DebugEvent[");
        if (this.getSource() != null) {
            buf.append(this.getSource().toString());
        } else {
            buf.append("null");
        }
        buf.append(", ");
        switch (this.getKind()) {
            case 4: {
                buf.append("CREATE");
                break;
            }
            case 8: {
                buf.append("TERMINATE");
                break;
            }
            case 1: {
                buf.append("RESUME");
                break;
            }
            case 2: {
                buf.append("SUSPEND");
                break;
            }
            case 16: {
                buf.append("CHANGE");
                break;
            }
            case 0: {
                buf.append("UNSPECIFIED");
                break;
            }
            case 32: {
                buf.append("PROCESS_SPECIFIC");
            }
        }
        buf.append(", ");
        switch (this.getDetail()) {
            case 16: {
                buf.append("BREAKPOINT");
                break;
            }
            case 32: {
                buf.append("CLIENT_REQUEST");
                break;
            }
            case 8: {
                buf.append("STEP_END");
                break;
            }
            case 1: {
                buf.append("STEP_INTO");
                break;
            }
            case 2: {
                buf.append("STEP_OVER");
                break;
            }
            case 4: {
                buf.append("STEP_RETURN");
                break;
            }
            case 64: {
                buf.append("EVALUATION");
                break;
            }
            case 128: {
                buf.append("EVALUATION_IMPLICIT");
                break;
            }
            case 256: {
                buf.append("STATE");
                break;
            }
            case 512: {
                buf.append("CONTENT");
                break;
            }
            case 0: {
                buf.append("UNSPECIFIED");
                break;
            }
            default: {
                buf.append(this.getDetail());
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

