/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.rm.lml.monitor.ui.handlers.ActionUtils;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.model.Row;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractConsoleHandler
extends AbstractHandler {
    protected JobStatusData status;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty()) {
            ILaunchController control;
            Row row = (Row)selection.getFirstElement();
            this.status = row.status;
            String controlId = this.status.getString("controlId");
            if (controlId != null && (control = LaunchControllerManager.getInstance().getLaunchController(controlId)) != null) {
                ActionUtils.readRemoteFile(control.getRemoteServicesId(), control.getConnectionName(), this.getPath());
            }
        }
        return null;
    }

    protected String getPath() {
        String attr = this.isError() ? "stderrRemotePath" : "stdoutRemotePath";
        return this.status.getString(attr);
    }

    protected boolean getReady() {
        if (this.isError()) {
            return this.status.getErrReady();
        }
        return this.status.getOutReady();
    }

    protected abstract boolean isError();
}

