/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.internal.services.ui.messages.Messages;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.widgets.ServiceConfigurationSelectionWidget;
import org.eclipse.ptp.services.ui.wizards.FilenameStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ServiceConfigurationImportWizard
extends Wizard
implements IImportWizard {
    private SelectFilePage mainPage;
    private IServiceConfiguration[] fServiceConfigurations;
    private IServiceModelManager fModelManager = ServiceModelManager.getInstance();

    public ServiceConfigurationImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ServiceConfigurationImportWizard_10);
    }

    public void addPages() {
        this.mainPage = new SelectFilePage("importMainPage", Messages.ServiceConfigurationImportWizard_11, null);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IServiceConfiguration[] iServiceConfigurationArray = this.mainPage.getServiceConfigurations();
        int n = iServiceConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServiceConfiguration config = iServiceConfigurationArray[n2];
            this.fModelManager.addConfiguration(config);
            ++n2;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        FilenameStore.setDefaultFromSelection(workbench);
    }

    private class SelectFilePage
    extends WizardPage {
        private String file;
        private Combo fileCombo;
        private Button browseButton;
        private ServiceConfigurationSelectionWidget fServiceWidget;
        private int messageType;

        public SelectFilePage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
            this.file = "";
            this.messageType = 0;
            this.setDescription(Messages.ServiceConfigurationImportWizard_1);
        }

        public void createControl(Composite parent) {
            Composite workArea = new Composite(parent, 0);
            this.setControl((Control)workArea);
            workArea.setFont(parent.getFont());
            workArea.setLayout((Layout)new GridLayout());
            workArea.setLayoutData((Object)new GridData(1808));
            this.createFileSelectionArea(workArea);
            this.createConfigurationsArea(workArea);
            this.updateEnablement();
            Dialog.applyDialogFont((Control)parent);
            this.messageType = 3;
        }

        private void createFileSelectionArea(Composite workArea) {
            Composite composite = new Composite(workArea, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setText(Messages.ServiceConfigurationImportWizard_2);
            this.fileCombo = new Combo(composite, 4);
            GridData comboData = new GridData(768);
            comboData.verticalAlignment = 2;
            comboData.grabExcessVerticalSpace = false;
            comboData.widthHint = 200;
            this.fileCombo.setLayoutData((Object)comboData);
            this.file = FilenameStore.getSuggestedDefault();
            this.fileCombo.setItems(FilenameStore.getHistory());
            this.fileCombo.setText(this.file);
            this.fileCombo.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    SelectFilePage.this.file = SelectFilePage.this.fileCombo.getText();
                    SelectFilePage.this.updateEnablement();
                }
            });
            this.browseButton = new Button(composite, 8);
            this.browseButton.setText(Messages.ServiceConfigurationImportWizard_3);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.browseButton.setLayoutData((Object)data);
            this.browseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog d = new FileDialog(SelectFilePage.this.getShell(), 4096);
                    d.setFilterExtensions(new String[]{"*.cfg", "*"});
                    d.setFilterNames(new String[]{Messages.ServiceConfigurationImportWizard_4, Messages.ServiceConfigurationImportWizard_5});
                    String fileName = SelectFilePage.this.getFileName();
                    if (fileName != null && fileName.length() > 0) {
                        int separator = fileName.lastIndexOf(System.getProperty("file.separator").charAt(0));
                        if (separator != -1) {
                            fileName = fileName.substring(0, separator);
                        }
                    } else {
                        fileName = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                    }
                    d.setFilterPath(fileName);
                    String f = d.open();
                    if (f != null) {
                        SelectFilePage.this.fileCombo.setText(f);
                        SelectFilePage.this.file = f;
                        SelectFilePage.this.updateConfigurations(SelectFilePage.this.file);
                    }
                }
            });
        }

        private void updateConfigurations(String file) {
            try {
                final String filename = file;
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.ServiceConfigurationImportWizard_0, 100);
                        ServiceConfigurationImportWizard.this.fServiceConfigurations = ServiceConfigurationImportWizard.this.fModelManager.importConfigurations(filename);
                        monitor.worked(100);
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            this.fServiceWidget.setConfigurations(ServiceConfigurationImportWizard.this.fServiceConfigurations);
            this.fServiceWidget.setAllChecked(true);
        }

        private void createConfigurationsArea(Composite workArea) {
            Composite composite = new Composite(workArea, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            Label label = new Label(composite, 0);
            label.setText(Messages.ServiceConfigurationImportWizard_12);
            this.fServiceWidget = new ServiceConfigurationSelectionWidget(composite, 32, null, null, true);
            this.fServiceWidget.setConfigurations(new IServiceConfiguration[0]);
        }

        public String getFileName() {
            return this.file;
        }

        public IServiceConfiguration[] getServiceConfigurations() {
            return this.fServiceWidget.getCheckedServiceConfigurations();
        }

        private void updateEnablement() {
            boolean complete = false;
            this.setMessage(null);
            if (this.file.length() == 0) {
                this.setMessage(Messages.ServiceConfigurationImportWizard_6, this.messageType);
                this.setPageComplete(false);
                return;
            }
            File f = new File(this.file);
            if (!f.exists()) {
                this.setMessage(Messages.ServiceConfigurationImportWizard_7, this.messageType);
                this.setPageComplete(false);
                return;
            }
            if (f.isDirectory()) {
                this.setMessage(Messages.ServiceConfigurationImportWizard_8, this.messageType);
                this.setPageComplete(false);
                return;
            }
            if (!ServiceConfigurationImportWizard.this.fModelManager.isValidConfigurationFile(this.file)) {
                this.setMessage(Messages.ServiceConfigurationImportWizard_13, this.messageType);
                this.setPageComplete(false);
                return;
            }
            complete = true;
            if (complete) {
                this.setErrorMessage(null);
                this.setDescription(Messages.ServiceConfigurationImportWizard_9);
            }
            this.setPageComplete(complete);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.fileCombo.setFocus();
            }
        }
    }
}

